/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestBundle;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestInfo;
import com.jetbrains.cidr.cpp.execution.testing.ctest.CidrCTestProjectTestLocation;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonBacktraceGraphNodeModel;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonModel;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonTestModel;
import com.jetbrains.cidr.cpp.execution.testing.ctest.json.model.v1.CTestJsonTestPropertyModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTestJsonModelUtil {
    private static final Logger LOG = Logger.getInstance(CTestJsonModelUtil.class);

    private CTestJsonModelUtil() {
    }

    @Nullable
    public static CTestJsonModel parseModel(@NotNull String text) {
        String json;
        if (text == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(0);
        }
        if ((json = CTestJsonModel.filterKnownJSON(text)) == null) {
            LOG.warn(CidrCTestBundle.message("ctest.error.json.filter.error", text));
            return null;
        }
        try {
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            return (CTestJsonModel)gson.fromJson(json, CTestJsonModel.class);
        }
        catch (Exception e) {
            LOG.warn(CidrCTestBundle.message("ctest.error.json.model", text, json), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public static List<CidrCTestProjectTestInfo> getTestsInfo(@NotNull CTestJsonModel model) {
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(1);
        }
        if (model.tests == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                CTestJsonModelUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<CidrCTestProjectTestInfo> tests = new ArrayList<CidrCTestProjectTestInfo>();
        for (int testIndex = 0; testIndex < model.tests.size(); ++testIndex) {
            tests.add(CTestJsonModelUtil.getTestInfo(model.tests.get(testIndex), testIndex + 1, model));
        }
        ArrayList<CidrCTestProjectTestInfo> arrayList = tests;
        if (arrayList == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static CidrCTestProjectTestInfo getTestInfo(@NotNull CTestJsonTestModel testModel, int testIndex, @NotNull CTestJsonModel model) {
        if (testModel == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(4);
        }
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(5);
        }
        return new CidrCTestProjectTestInfo(testIndex, StringUtil.notNullize((String)testModel.name), CTestJsonModelUtil.getLocation(testModel, model), CTestJsonModelUtil.getExecutionCommand(testModel));
    }

    @Nullable
    private static CidrCTestProjectTestLocation getLocation(@NotNull CTestJsonTestModel testModel, @NotNull CTestJsonModel model) {
        if (testModel == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(6);
        }
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(7);
        }
        if (model.backtraceGraph == null || model.backtraceGraph.nodes == null || model.backtraceGraph.nodes.isEmpty() || model.backtraceGraph.files == null || model.backtraceGraph.files.isEmpty()) {
            return null;
        }
        if (testModel.backtrace < 0 || testModel.backtrace >= model.backtraceGraph.nodes.size()) {
            return null;
        }
        CTestJsonBacktraceGraphNodeModel nodeModel = model.backtraceGraph.nodes.get(testModel.backtrace);
        if (nodeModel.file < 0 || nodeModel.file >= model.backtraceGraph.files.size()) {
            return null;
        }
        return new CidrCTestProjectTestLocation(model.backtraceGraph.files.get(nodeModel.file), nodeModel.line - 1);
    }

    @Nullable
    public static GeneralCommandLine getExecutionCommand(@NotNull CTestJsonTestModel model) {
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(8);
        }
        if (model.commands == null || model.commands.isEmpty()) {
            return null;
        }
        String binaryPath = model.commands.get(0);
        if (StringUtil.isEmpty((String)binaryPath)) {
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{binaryPath});
        for (int parameterIndex = 1; parameterIndex < model.commands.size(); ++parameterIndex) {
            String parameter = model.commands.get(parameterIndex);
            if (!StringUtil.isNotEmpty((String)parameter)) continue;
            commandLine.addParameter(parameter);
        }
        commandLine.withWorkDirectory(CTestJsonModelUtil.getWorkingDirectory(model));
        commandLine.withEnvironment(CTestJsonModelUtil.getEnvironmentVariables(model));
        return commandLine;
    }

    @Nullable
    public static String getWorkingDirectory(@NotNull CTestJsonTestModel model) {
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(9);
        }
        if (model.properties == null) {
            return null;
        }
        for (CTestJsonTestPropertyModel property : model.properties) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)property.name, (CharSequence)"WORKING_DIRECTORY") || !(property.value instanceof String)) continue;
            return (String)property.value;
        }
        return null;
    }

    @NotNull
    public static Map<String, String> getEnvironmentVariables(@NotNull CTestJsonTestModel model) {
        if (model == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(10);
        }
        if (model.properties == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        for (CTestJsonTestPropertyModel property : model.properties) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)property.name, (CharSequence)"ENVIRONMENT")) continue;
            if (!(property.value instanceof List)) {
                LOG.debug("ENVIRONMENT property values must be of List type");
                continue;
            }
            List propertyValues = (List)property.value;
            for (Object propertyObject : propertyValues) {
                if (!(propertyObject instanceof String)) {
                    LOG.debug("ENVIRONMENT property object must be of String type");
                    continue;
                }
                String propertyValue = (String)propertyObject;
                int equalityIndex = propertyValue.indexOf(61);
                if (equalityIndex < 0) {
                    LOG.debug("ENVIRONMENT property value doesn't contain '=' symbol");
                    continue;
                }
                String name = propertyValue.substring(0, equalityIndex);
                String value = propertyValue.substring(equalityIndex + 1);
                if (name.isEmpty() || value.isEmpty()) {
                    LOG.debug("ENVIRONMENT variable name or value is empty");
                    continue;
                }
                variables.put(name, value);
            }
        }
        HashMap<String, String> hashMap = variables;
        if (hashMap == null) {
            CTestJsonModelUtil.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/testing/ctest/json/model/v1/CTestJsonModelUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/testing/ctest/json/model/v1/CTestJsonModelUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTestsInfo";
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTestInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionCommand";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

