/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters;

import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.util.NullableFunction;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RequestBuilder<T, R extends RequestFormBodyPart> {
    public void withUrl(@NotNull String var1);

    public void withMethod(@NotNull String var1);

    public void withProtocol(@NotNull HttpProtocol var1);

    public <E extends Throwable> void withQueryParameters(@NotNull ThrowableConsumer<QueryBuilder, E> var1) throws E;

    public void withAuthData(@NotNull HttpClientAuthData var1);

    public void withHeader(@NotNull String var1, @NotNull String var2, @NotNull NullableFunction<String, String> var3);

    public void withFileToSend(@NotNull File var1);

    public void withTextToSend(@NotNull String var1);

    public <E extends Throwable> void withMultipartBody(@Nullable String var1, ThrowableConsumer<? super MultipartBodyBuilder<R>, E> var2) throws E;

    public void withConfig(@NotNull HttpRequestConfig var1);

    public void withEmptyCredentials();

    public void withSslConfiguration(@Nullable SslConfiguration var1);

    public T build();

    public static enum HttpProtocol {
        HTTP_10,
        HTTP_11,
        HTTP_2;

    }

    public static interface RequestFormBodyPart {
        public RequestFormBodyPart addHeader(@NotNull String var1, @Nullable String var2);
    }

    public static interface MultipartBodyBuilder<T> {
        public T createPartForFile(@NotNull String var1, @NotNull String var2, @NotNull File var3, @NotNull ContentType var4);

        public T createPartForString(@NotNull String var1, @NotNull String var2, @NotNull ContentType var3);

        public void addFormBodyPart(@NotNull T var1);
    }

    public static interface QueryBuilder {
        public void addQueryParameter(@NotNull String var1, @NotNull String var2);
    }
}

