/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.completion.HttpRequestHeaderIndex;
import com.intellij.httpClient.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.httpClient.http.request.completion.HttpVariableCompletionProvider;
import com.intellij.httpClient.http.request.completion.HttpVariableInMessageBodyCompletionProvider;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocCommentElementTypes;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocCommentTagDescriptor;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocCommentTags;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocCommentTag;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldName;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.microservices.http.HttpHeaderDocumentation;
import com.intellij.microservices.http.HttpHeadersDictionary;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestCompletionContributor
extends CompletionContributor {
    private static final TokenSet IDENTIFIER_PREDECESSOR = TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.IDENTIFIER, HttpRequestElementTypes.LBRACES, HttpRequestElementTypes.DYNAMIC_SIGN, HttpDocCommentElementTypes.UNKNOWN});

    public HttpRequestCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(HttpHeaderFieldName.class), new HttpHeaderFieldNamesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(HttpHeaderFieldValue.class), new HttpHeaderFieldValuesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.HOST_VALUE).withParent(HttpHost.class), new HttpMethodsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.IDENTIFIER).withParent(HttpDynamicVariable.class), HttpVariableCompletionProvider.getProvider(HttpVariableCompletionProvider.ProviderType.DYNAMIC_VARIABLE));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.IDENTIFIER).withParent(HttpVariable.class), HttpVariableCompletionProvider.getProvider(HttpVariableCompletionProvider.ProviderType.ENVIRONMENT_VARIABLE));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.MESSAGE_TEXT), new HttpVariableInMessageBodyCompletionProvider());
        PsiElementPattern.Capture inTag = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HttpDocCommentElementTypes.UNKNOWN).withParent(HttpDocCommentTag.class);
        PsiElementPattern.Capture inComment = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HttpDocCommentElementTypes.COMMENT_TEXT).withParent(HttpDocComment.class);
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{inComment, inTag}), new HttpDocCommentsCompletionProvider());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(0);
        }
        super.beforeCompletion(context);
        PsiElement psiElement = context.getFile().findElementAt(context.getStartOffset());
        if (psiElement != null && HttpRequestPsiUtils.isOfType(psiElement, HttpRequestElementTypes.FIELD_VALUE)) {
            int startOffset = psiElement.getTextRange().getStartOffset();
            int separator = psiElement.getText().indexOf(",", context.getStartOffset() - startOffset);
            context.setReplacementOffset(separator < 0 ? psiElement.getTextRange().getEndOffset() : startOffset + separator);
        } else {
            PsiElement parent;
            PsiElement psiElement2 = parent = psiElement != null ? psiElement.getParent() : null;
            if (parent instanceof HttpScheme) {
                context.setReplacementOffset(HttpRequestCompletionContributor.getSchemeReplacementOffset(parent));
            }
            if (parent instanceof HttpHeaderFieldName || parent instanceof HttpHost) {
                context.setReplacementOffset(parent.getTextRange().getEndOffset());
            }
            if (parent instanceof HttpRequestTarget) {
                context.setReplacementOffset(parent.getTextRange().getStartOffset());
                if (context.getStartOffset() > 0) {
                    PsiElement previousElementParent;
                    PsiElement previousElement = context.getFile().findElementAt(context.getStartOffset() - 1);
                    PsiElement psiElement3 = previousElementParent = previousElement != null ? previousElement.getParent() : null;
                    if (previousElementParent instanceof HttpScheme) {
                        context.setReplacementOffset(HttpRequestCompletionContributor.getSchemeReplacementOffset(previousElementParent));
                    }
                }
            } else {
                PsiElement toReplace = HttpRequestCompletionContributor.getReplacedIdentifier(context, psiElement, parent);
                if (toReplace != null) {
                    context.setReplacementOffset(toReplace.getTextRange().getEndOffset());
                }
            }
        }
    }

    private static int getSchemeReplacementOffset(@NotNull PsiElement scheme) {
        PsiElement possibleSeparator;
        if (scheme == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((possibleSeparator = scheme.getNextSibling()) != null && HttpRequestPsiUtils.isOfType(possibleSeparator, HttpRequestElementTypes.SCHEME_SEPARATOR)) {
            PsiElement possibleHost = possibleSeparator.getNextSibling();
            if (possibleHost != null && HttpRequestPsiUtils.isOfType(possibleHost, HttpRequestElementTypes.HOST)) {
                return possibleHost.getTextRange().getEndOffset();
            }
            return possibleSeparator.getTextRange().getEndOffset();
        }
        return scheme.getTextRange().getEndOffset();
    }

    @Nullable
    private static PsiElement getReplacedIdentifier(@NotNull CompletionInitializationContext context, @Nullable PsiElement element, @Nullable PsiElement parent) {
        PsiElement prevElement;
        if (context == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(2);
        }
        if (parent instanceof HttpVariable) {
            PsiElement toReplace = ((HttpVariable)parent).getNameIdentifier();
            return toReplace != null ? toReplace : parent.getFirstChild();
        }
        if (parent instanceof HttpDynamicVariable) {
            PsiElement toReplace = ((HttpDynamicVariable)parent).getNameIdentifier();
            return toReplace != null ? toReplace : parent.getFirstChild().getNextSibling();
        }
        if (element != null && HttpRequestPsiUtils.isOfTypes(element, TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.IDENTIFIER, HttpRequestElementTypes.DYNAMIC_SIGN}))) {
            return element;
        }
        if (context.getStartOffset() > 0 && (prevElement = context.getFile().findElementAt(context.getStartOffset() - 1)) != null && HttpRequestPsiUtils.isOfTypes(prevElement, IDENTIFIER_PREDECESSOR)) {
            return prevElement;
        }
        return null;
    }

    private static boolean isRequestStart(@NotNull CompletionParameters parameters) {
        HttpRequest request;
        if (parameters == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(3);
        }
        return (request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), HttpRequest.class)) != null && request.getTextRange().getStartOffset() == parameters.getPosition().getTextRange().getStartOffset();
    }

    @NotNull
    private static CompletionResultSet updatePrefixMatcherByElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull PsiElement element) {
        int endOffset;
        int startOffset;
        if (parameters == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(5);
        }
        if (element == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((startOffset = element.getTextRange().getStartOffset()) < (endOffset = parameters.getOffset())) {
            result = result.withPrefixMatcher(parameters.getOriginalFile().getText().substring(startOffset, endOffset));
        }
        CompletionResultSet completionResultSet = result;
        if (completionResultSet == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(7);
        }
        return completionResultSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePrefixMatcherByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSchemeReplacementOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRequestStart";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixMatcherByElement";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HttpDocCommentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpDocCommentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            HttpDocComment comment;
            if (parameters == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((comment = HttpDocCommentsCompletionProvider.getParentComment(position = parameters.getPosition())) == null || !HttpDocCommentsCompletionProvider.hasCorrespondingRequest((PsiElement)comment)) {
                return;
            }
            if (HttpRequestPsiUtils.isOfType(position, HttpDocCommentElementTypes.UNKNOWN)) {
                result = HttpRequestCompletionContributor.updatePrefixMatcherByElement(parameters, result, position);
            }
            for (HttpDocCommentTagDescriptor tag : HttpDocCommentTags.TAGS) {
                result.addElement((LookupElement)LookupElementBuilder.create((Object)tag, (String)tag.getText()));
            }
        }

        @Nullable
        private static HttpDocComment getParentComment(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof HttpDocComment)) {
                parent = parent.getParent();
            }
            return parent instanceof HttpDocComment ? (HttpDocComment)parent : null;
        }

        private static boolean hasCorrespondingRequest(@NotNull PsiElement comment) {
            PsiElement next;
            if (comment == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(4);
            }
            if ((next = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(comment, true)) instanceof HttpRequestBlock) {
                next = next.getFirstChild();
            }
            if (next instanceof HttpRequest) {
                return true;
            }
            PsiElement prev = HttpRequestPsiUtils.getPrevSiblingIgnoreWhitespace(comment);
            if (prev instanceof HttpRequestBlock) {
                prev = prev.getLastChild();
            }
            return prev == null || HttpRequestPsiUtils.isOfType(prev, HttpRequestElementTypes.REQUEST_SEPARATOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpDocCommentsCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParentComment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCorrespondingRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpHeaderFieldValuesProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpHeaderFieldValuesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            HttpHeaderField header;
            String headerName;
            if (parameters == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(2);
            }
            String string = headerName = (header = (HttpHeaderField)PsiTreeUtil.getParentOfType((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)parameters.getPosition()), HttpHeaderField.class)) != null ? header.getName() : null;
            if (StringUtil.isNotEmpty((String)headerName)) {
                Set alreadyAdded = CollectionFactory.createCaseInsensitiveStringSet();
                for (String value : HttpHeadersDictionary.getHeaderValues((Project)header.getProject(), (String)headerName)) {
                    alreadyAdded.add(value);
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value), (double)200.0));
                }
                String currentHeaderValue = header.getValue(HttpRequestVariableSubstitutor.empty());
                for (String value : HttpRequestHeaderIndex.getAllHeaderValues(header.getProject(), headerName, currentHeaderValue)) {
                    if (alreadyAdded.contains(value)) continue;
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value), (double)100.0));
                }
                for (String option : HttpHeadersDictionary.getHeaderOptionNames((String)headerName)) {
                    result.addElement((LookupElement)LookupElementBuilder.create((String)option).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.HEADER_OPTION));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpHeaderFieldValuesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpHeaderFieldNamesProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpHeaderFieldNamesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(2);
            }
            Set alreadyAdded = CollectionFactory.createCaseInsensitiveStringSet();
            for (HttpHeaderDocumentation header : HttpHeadersDictionary.getHeaders().values()) {
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)header, (String)header.getName()).withStrikeoutness(header.isDeprecated()).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.FIELD_SEPARATOR), (double)200.0));
                alreadyAdded.add(header.getName());
            }
            Project project = parameters.getOriginalFile().getProject();
            HttpHeaderField currentHeader = (HttpHeaderField)PsiTreeUtil.getParentOfType((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)parameters.getPosition()), HttpHeaderField.class);
            String currentHeaderValue = currentHeader != null ? currentHeader.getName() : "";
            for (String header : HttpRequestHeaderIndex.getAllHeaders(project, currentHeaderValue)) {
                if (alreadyAdded.contains(header)) continue;
                result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)header, (String)header).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.FIELD_SEPARATOR), (double)100.0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpHeaderFieldNamesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpMethodsProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpMethodsProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                HttpMethodsProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                HttpMethodsProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                HttpMethodsProvider.$$$reportNull$$$0(2);
            }
            if (HttpRequestCompletionContributor.isRequestStart(parameters)) {
                for (String header : UrlConstants.HTTP_METHODS) {
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)header).withBoldness(true).withInsertHandler(AddSpaceInsertHandler.INSTANCE), (double)100.0));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpMethodsProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

