/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.debug;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.debug.HttpRequestDebugger;
import com.intellij.httpClient.http.request.run.HttpClientExecutionController;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.RunHttpRequestProfileState;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.openapi.project.Project;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIUtils;
import org.jetbrains.annotations.NotNull;

public class DebugHttpRequestProfileState
extends RunHttpRequestProfileState {
    private final HttpRequestDebugger myDebugger;

    public DebugHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestDebugger debugger, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties, @NotNull HttpRequestVariableSubstitutor substitutor) {
        if (project == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (config == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        if (substitutor == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        super(project, config, properties, substitutor);
        this.myDebugger = debugger;
    }

    @Override
    @NotNull
    protected HttpClientExecutionController createExecutionController(@NotNull Project project, @NotNull Iterator<HttpRunRequestInfo> requests, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console, boolean showResponseInplace) throws ExecutionException {
        if (project == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        if (requests == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(7);
        }
        if (console == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        PeekingIterator peekableRequests = Iterators.peekingIterator(requests);
        DebugHttpRequestProfileState.prepareDebugSession(project, (PeekingIterator<HttpRunRequestInfo>)peekableRequests, processHandler, this.myDebugger);
        HttpClientExecutionController httpClientExecutionController = super.createExecutionController(project, (Iterator<HttpRunRequestInfo>)peekableRequests, processHandler, console, showResponseInplace);
        if (httpClientExecutionController == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        return httpClientExecutionController;
    }

    private static void prepareDebugSession(@NotNull Project project, @NotNull PeekingIterator<HttpRunRequestInfo> requests, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpRequestDebugger debugger) throws ExecutionException {
        if (project == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(10);
        }
        if (requests == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(11);
        }
        if (processHandler == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(12);
        }
        if (debugger == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(13);
        }
        if (!requests.hasNext()) {
            return;
        }
        HttpRunRequestInfo requestInfo = (HttpRunRequestInfo)requests.peek();
        RestClientRequest request = requestInfo.getRequest();
        HttpHost host = DebugHttpRequestProfileState.getHost(request);
        String hostName = host.getHostName();
        debugger.startDebugSession(project, request, hostName, processHandler);
    }

    @NotNull
    private static HttpHost getHost(@NotNull RestClientRequest request) throws ExecutionException {
        URI uri;
        if (request == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(14);
        }
        String url = request.getURL();
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new ExecutionException(RestClientBundle.message("debug.http.client.can.not.parse.url", url), (Throwable)ex);
        }
        HttpHost host = URIUtils.extractHost((URI)uri);
        if (host == null) {
            throw new ExecutionException(RestClientBundle.message("debug.http.client.can.not.resolve.host.name", url));
        }
        HttpHost httpHost = host;
        if (httpHost == null) {
            DebugHttpRequestProfileState.$$$reportNull$$$0(15);
        }
        return httpHost;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/debug/DebugHttpRequestProfileState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/debug/DebugHttpRequestProfileState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutionController";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionController";
                break;
            }
            case 9: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "prepareDebugSession";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

