/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.microservices.RestClientRequestNavigatorBase;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.RunHttpRequestAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class RestClientRequestRunnerNavigator
extends RestClientRequestNavigatorBase {
    @NotNull
    public String getId() {
        return "RestClientRequestRunnerNavigator";
    }

    @Override
    protected void performNavigation(@NotNull NavigatablePsiElement psiElement) {
        if (psiElement == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(0);
        }
        HttpRequest httpRequest = null;
        if (psiElement instanceof HttpRequest) {
            httpRequest = (HttpRequest)psiElement;
        } else if (psiElement instanceof HttpRequestBlock) {
            httpRequest = ((HttpRequestBlock)psiElement).getRequest();
        }
        if (httpRequest != null) {
            HttpRequest request = httpRequest;
            Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
            promise.onSuccess(dataContext -> {
                DataContext wrapper = dataId -> {
                    if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
                        return new PsiElement[]{request};
                    }
                    if (CommonDataKeys.EDITOR.is(dataId)) {
                        return null;
                    }
                    return dataContext.getData(dataId);
                };
                new RunHttpRequestAction.RunRequestWithDefaultEnvAction(request).actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)wrapper));
            });
            promise.onError(error -> {
                LOG.info("Failed to run HTTP request", error);
                psiElement.navigate(true);
            });
        } else {
            LOG.info("Failed to run HTTP request: request not found in " + psiElement.getContainingFile());
            psiElement.navigate(true);
        }
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Execute;
        if (icon == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayText() {
        String string = RestClientBundle.message("http.request.navigator.rest.client.display.text", new Object[0]);
        if (string == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/microservices/RestClientRequestRunnerNavigator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/microservices/RestClientRequestRunnerNavigator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performNavigation";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

