/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.ExecutionException;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandlerExecutor;
import com.intellij.httpClient.http.request.run.HttpClientSession;
import com.intellij.httpClient.http.request.run.HttpClientTest;
import com.intellij.httpClient.http.request.run.HttpRequestGlobalContext;
import com.intellij.httpClient.http.request.run.HttpRequestNotifications;
import com.intellij.httpClient.http.request.run.HttpResponseExecutionResult;
import com.intellij.httpClient.http.request.run.console.HttpResponseOutputAdapter;
import com.intellij.httpClient.http.request.run.nashorn.HttpResponseHandlerNashornExecutor;
import com.intellij.httpClient.http.request.run.rhino.HttpClientRhinoResponseHandler;
import com.intellij.httpClient.http.request.run.test.HttpClientTestsRunner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientResponseHandler {
    private static final Logger LOG = Logger.getInstance(HttpClientResponseHandler.class);
    private static final String SUITE_NAME = "Post-processor";
    private final String myJsScript;

    public HttpClientResponseHandler(@NotNull String jsScript) {
        if (jsScript == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(0);
        }
        this.myJsScript = jsScript;
    }

    @NotNull
    public HttpClientResponseHandlerExecutor createExecutor(@NotNull Project project) {
        HttpResponseHandlerNashornExecutor executor;
        if (project == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"http.client.response.handler.force.use.rhino") && (executor = HttpResponseHandlerNashornExecutor.create()) != null) {
            HttpResponseHandlerNashornExecutor httpResponseHandlerNashornExecutor = executor;
            if (httpResponseHandlerNashornExecutor == null) {
                HttpClientResponseHandler.$$$reportNull$$$0(2);
            }
            return httpResponseHandlerNashornExecutor;
        }
        HttpClientRhinoResponseHandler httpClientRhinoResponseHandler = HttpClientRhinoResponseHandler.create(project);
        if (httpClientRhinoResponseHandler == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(3);
        }
        return httpClientRhinoResponseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull Project project, @NotNull RestClientResponse response, @Nullable HttpResponseOutputAdapter printer, @Nullable HttpResponseOutputAdapter testPrinter, boolean showNotification2) throws ExecutionException {
        if (project == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(4);
        }
        if (response == null) {
            HttpClientResponseHandler.$$$reportNull$$$0(5);
        }
        HttpClientResponseHandlerExecutor executor = this.createExecutor(project);
        if (printer != null) {
            executor.configureStdout(printer);
        }
        ProgressManager.checkCanceled();
        long start = System.currentTimeMillis();
        if (printer != null) {
            printer.printStart(SUITE_NAME);
        }
        try {
            HttpClientSession session = HttpClientSession.create(project, response);
            ProgressManager.checkCanceled();
            HttpResponseExecutionResult result = executor.execute(session, response, this.myJsScript);
            ProgressManager.checkCanceled();
            if (printer != null) {
                printer.printEnd(SUITE_NAME, System.currentTimeMillis() - start);
            }
            ProgressManager.checkCanceled();
            if (testPrinter != null) {
                executor.configureStdout(testPrinter);
                List<HttpClientTest> tests = result.getTests();
                int failed = HttpClientTestsRunner.runTests(testPrinter, tests);
                ProgressManager.checkCanceled();
                if (failed > 0 && showNotification2) {
                    HttpRequestNotifications.showErrorBalloon(project, "", RestClientBundle.message("rest.client.request.test.result", failed, tests.size() - failed));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(HttpRequestGlobalContext.getInstance(project).getGlobal().toString());
            }
        }
        finally {
            executor.close();
            ProgressManager.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsScript";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpClientResponseHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientResponseHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

