/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.execution.RestClientResponse;
import com.intellij.httpClient.http.request.run.HttpClientExternal;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientSession {
    public HttpClientExternal client;
    public HttpResponseHeaders headers;
    public HttpResponseContentType contentType;
    public String content;
    public int statusCode;

    public HttpClientSession(@NotNull HttpClientExternal client, @NotNull HttpResponseHeaders headers, @NotNull HttpResponseContentType contentType, @NotNull String content, int statusCode) {
        if (client == null) {
            HttpClientSession.$$$reportNull$$$0(0);
        }
        if (headers == null) {
            HttpClientSession.$$$reportNull$$$0(1);
        }
        if (contentType == null) {
            HttpClientSession.$$$reportNull$$$0(2);
        }
        if (content == null) {
            HttpClientSession.$$$reportNull$$$0(3);
        }
        this.client = client;
        this.headers = headers;
        this.contentType = contentType;
        this.content = content;
        this.statusCode = statusCode;
    }

    @NotNull
    public static HttpClientSession create(@NotNull Project project, @NotNull RestClientResponse response) {
        if (project == null) {
            HttpClientSession.$$$reportNull$$$0(4);
        }
        if (response == null) {
            HttpClientSession.$$$reportNull$$$0(5);
        }
        HttpClientExternal client = new HttpClientExternal(project);
        HttpResponseHeaders headers = new HttpResponseHeaders(response.getAllHeaders());
        ContentType type = response.getContentType();
        Charset charset = type.getCharset();
        HttpResponseContentType contentType = new HttpResponseContentType(type.getMimeType(), charset != null ? charset.name() : "");
        return new HttpClientSession(client, headers, contentType, response.getContent(), response.getStatusLine().getStatusCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientSession";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class HttpResponseHeaders {
        private static final String EMPTY_HEADERS = "Empty";
        public Header[] headers;

        public HttpResponseHeaders(Header[] headers) {
            this.headers = headers;
        }

        @Nullable
        public String valueOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(0);
            }
            for (Header header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                return header.getValue();
            }
            return null;
        }

        @Nullable
        public List<String> valuesOf(@NotNull String name) {
            if (name == null) {
                HttpResponseHeaders.$$$reportNull$$$0(1);
            }
            ArrayList<String> values = new ArrayList<String>();
            for (Header header : this.headers) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)name)) continue;
                values.add(header.getValue());
            }
            return values;
        }

        public String toString() {
            if (this.headers.length == 0) {
                return EMPTY_HEADERS;
            }
            return Stream.of(this.headers).map(header -> header.getName() + ": " + header.getValue()).collect(Collectors.joining("\n"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpClientSession$HttpResponseHeaders";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valuesOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HttpResponseContentType {
        public String mimeType;
        public String charset;

        public HttpResponseContentType(String mimeType, String charset) {
            this.mimeType = mimeType;
            this.charset = charset;
        }

        public String toString() {
            return this.mimeType + "; charset=" + this.charset;
        }
    }
}

