/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.collaboration.auth.credentials.Credentials;
import com.intellij.collaboration.auth.credentials.SimpleCredentials;
import com.intellij.collaboration.auth.services.OAuthServiceBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import java.net.http.HttpHeaders;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0005H\u0014J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\tH\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\tH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "Lcom/intellij/collaboration/auth/services/OAuthServiceBase;", "Lcom/intellij/collaboration/auth/credentials/Credentials;", "()V", "authorizationCodeUrl", "Lcom/intellij/util/Url;", "getAuthorizationCodeUrl", "()Lcom/intellij/util/Url;", "codeChallenge", "", "getCodeChallenge", "()Ljava/lang/String;", "codeVerifier", "errorRedirectUrl", "getErrorRedirectUrl", "name", "getName", "port", "", "getPort", "()I", "successRedirectUrl", "getSuccessRedirectUrl", "getAuthUrlWithParameters", "getCredentials", "responseBody", "responseHeaders", "Ljava/net/http/HttpHeaders;", "getTokenUrlWithParameters", "code", "revokeToken", "", "token", "Companion", "intellij.vcs.github"})
public final class GHOAuthService
extends OAuthServiceBase<Credentials> {
    private final String codeVerifier = DigestUtil.randomToken();
    private static final Url SERVICE_URL;
    @NotNull
    public static final Companion Companion;

    private final String getCodeChallenge() {
        Base64.Encoder encoder = Base64.getEncoder();
        MessageDigest messageDigest = DigestUtil.sha256();
        String string = this.codeVerifier;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = encoder.encodeToString(messageDigest.digest(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().enco\u2026eVerifier.toByteArray()))");
        return string3;
    }

    private final int getPort() {
        return BuiltInServerManager.Companion.getInstance().getPort();
    }

    @NotNull
    public String getName() {
        return "github/oauth";
    }

    @NotNull
    public Url getAuthorizationCodeUrl() {
        return Urls.newFromEncoded((String)("http://127.0.0.1:" + this.getPort() + "/api/" + this.getName() + "/authorization_code"));
    }

    @NotNull
    public Url getSuccessRedirectUrl() {
        Url url = SERVICE_URL.resolve("complete");
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"SERVICE_URL.resolve(\"complete\")");
        return url;
    }

    @NotNull
    public Url getErrorRedirectUrl() {
        Url url = SERVICE_URL.resolve("error");
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"SERVICE_URL.resolve(\"error\")");
        return url;
    }

    public void revokeToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    protected Url getAuthUrlWithParameters() {
        Url url = Companion.getAUTHORIZE_URL().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"code_challenge", (Object)this.getCodeChallenge()), TuplesKt.to((Object)"callback_url", (Object)this.getAuthorizationCodeUrl().toExternalForm())}));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"AUTHORIZE_URL.addParamet\u2026Url.toExternalForm()\n  ))");
        return url;
    }

    @NotNull
    protected Credentials getCredentials(@NotNull String responseBody, @NotNull HttpHeaders responseHeaders) {
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        Intrinsics.checkNotNullParameter((Object)responseHeaders, (String)"responseHeaders");
        String string = responseHeaders.firstValue("X-OAuth-Token").get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"responseHeaders.firstValue(\"X-OAuth-Token\").get()");
        return (Credentials)new SimpleCredentials(string);
    }

    @NotNull
    protected Url getTokenUrlWithParameters(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Url url = Companion.getACCESS_TOKEN_URL().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)this.codeVerifier)}));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"ACCESS_TOKEN_URL.addPara\u2026ier\" to codeVerifier\n  ))");
        return url;
    }

    static {
        Companion = new Companion(null);
        SERVICE_URL = Urls.newFromEncoded((String)"https://account.jetbrains.com/github/oauth/intellij");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHOAuthService$Companion;", "", "()V", "ACCESS_TOKEN_URL", "Lcom/intellij/util/Url;", "getACCESS_TOKEN_URL", "()Lcom/intellij/util/Url;", "AUTHORIZE_URL", "getAUTHORIZE_URL", "SERVICE_URL", "instance", "Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "getInstance", "()Lorg/jetbrains/plugins/github/authentication/GHOAuthService;", "intellij.vcs.github"})
    public static final class Companion {
        @NotNull
        public final GHOAuthService getInstance() {
            boolean $i$f$service = false;
            Class<GHOAuthService> serviceClass$iv = GHOAuthService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (GHOAuthService)((Object)object);
        }

        @NotNull
        public final Url getAUTHORIZE_URL() {
            Url url = SERVICE_URL.resolve("authorize");
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"SERVICE_URL.resolve(\"authorize\")");
            return url;
        }

        @NotNull
        public final Url getACCESS_TOKEN_URL() {
            Url url = SERVICE_URL.resolve("access_token");
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"SERVICE_URL.resolve(\"access_token\")");
            return url;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

