/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.PatternUtil;
import git4idea.config.GitSharedSettings;
import git4idea.fetch.GitFetchHandler;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.extensions.GHProtectedBranchRulesLoaderKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHProjectRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubProjectSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader;", "Lgit4idea/fetch/GitFetchHandler;", "()V", "doAfterSuccessfulFetch", "", "project", "Lcom/intellij/openapi/project/Project;", "fetches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadProtectionRules", "intellij.vcs.github"})
public final class GHProtectedBranchRulesLoader
implements GitFetchHandler {
    public void doAfterSuccessfulFetch(@NotNull Project project, @NotNull Map<GitRepository, ? extends List<GitRemote>> fetches, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(fetches, (String)"fetches");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            this.loadProtectionRules(indicator, fetches, project);
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                throw (Throwable)e;
            }
            GHProtectedBranchRulesLoaderKt.access$getLOG$p().info("Error occurred while trying to load branch protection rules", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProtectionRules(ProgressIndicator indicator, Map<GitRepository, ? extends List<GitRemote>> fetches, Project project) {
        Application app$iv;
        GithubAuthenticationManager githubAuthenticationManager;
        block18: {
            Application app$iv2;
            block17: {
                githubAuthenticationManager = GithubAuthenticationManager.Companion.getInstance();
                GitSharedSettings gitSharedSettings = GitSharedSettings.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)gitSharedSettings, (String)"GitSharedSettings.getInstance(project)");
                if (!gitSharedSettings.isSynchronizeBranchProtectionRules()) break block17;
                if (githubAuthenticationManager.hasAccounts()) break block18;
            }
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                Project $this$service$iv22 = project;
                boolean $i$f$service = false;
                Object object = $this$service$iv22.getService(GithubProjectSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                boolean $this$service$iv22 = false;
                ((GithubProjectSettings)object).setBranchProtectionPatterns(new ArrayList());
            } else {
                boolean $i$f$invokeLater = false;
                Application application2 = ApplicationManager.getApplication();
                Runnable runnable = new Runnable(project){
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        Project $this$service$iv = this.$project$inlined;
                        boolean $i$f$service = false;
                        Object object = $this$service$iv.getService(GithubProjectSettings.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                        boolean bl2 = false;
                        ((GithubProjectSettings)object).setBranchProtectionPatterns((List<String>)new ArrayList<E>());
                    }
                };
                ModalityState modalityState = ModalityState.defaultModalityState();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                application2.invokeLater(runnable, modalityState);
            }
            return;
        }
        indicator.setText(GithubBundle.message("progress.text.loading.protected.branches", new Object[0]));
        boolean $i$f$runInEdt = false;
        Set branchProtectionPatterns = new LinkedHashSet();
        GitRepository bl = fetches;
        boolean $this$service$iv22 = false;
        Iterator<Map.Entry<GitRepository, ? extends List<GitRemote>>> app$iv2 = bl.entrySet().iterator();
        while (app$iv2.hasNext()) {
            Map.Entry<GitRepository, ? extends List<GitRemote>> $i$f$service = $i$f$runInEdt = app$iv2.next();
            boolean $i$f$invokeLater = false;
            bl = $i$f$service.getKey();
            $i$f$service = $i$f$runInEdt;
            $i$f$invokeLater = false;
            List<GitRemote> remotes = $i$f$service.getValue();
            indicator.checkCanceled();
            for (GitRemote remote : remotes) {
                void $this$forEach$iv;
                GHGitRepositoryMapping githubRepositoryMapping;
                Object v10;
                GithubApiRequestExecutor.WithTokenAuth requestExecutor;
                block16: {
                    void repository;
                    GithubAccount account;
                    Object v8;
                    Object it;
                    block15: {
                        indicator.checkCanceled();
                        Iterable iterable = githubAuthenticationManager.getAccounts();
                        boolean bl2 = false;
                        Iterable iterable2 = iterable;
                        boolean bl3 = false;
                        for (Object t : iterable2) {
                            it = (GithubAccount)((Object)t);
                            boolean bl4 = false;
                            GithubServerPath githubServerPath = ((GithubAccount)((Object)it)).getServer();
                            String string = remote.getFirstUrl();
                            boolean bl5 = false;
                            String string2 = string;
                            if (string2 == null) {
                                string2 = "";
                            }
                            if (!githubServerPath.matches(string2)) continue;
                            v8 = t;
                            break block15;
                        }
                        v8 = null;
                    }
                    if ((GithubAccount)v8 == null) {
                        continue;
                    }
                    requestExecutor = GithubApiRequestExecutorManager.Companion.getInstance().getExecutor(account);
                    Object $this$service$iv = project;
                    boolean $i$f$service2 = false;
                    Object object = $this$service$iv.getService(GHProjectRepositoriesManager.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    $this$service$iv = ((GHProjectRepositoriesManager)object).findKnownRepositories((GitRepository)repository);
                    $i$f$service2 = false;
                    Object object2 = $this$service$iv;
                    boolean bl6 = false;
                    it = object2.iterator();
                    while (it.hasNext()) {
                        Object bl4 = it.next();
                        GHGitRepositoryMapping it2 = (GHGitRepositoryMapping)bl4;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it2.getGitRemoteUrlCoordinates().getRemote(), (Object)remote)) continue;
                        v10 = bl4;
                        break block16;
                    }
                    v10 = null;
                }
                if ((GHGitRepositoryMapping)v10 == null) {
                    continue;
                }
                GHRepositoryCoordinates repositoryCoordinates = githubRepositoryMapping.getGhRepositoryCoordinates();
                Iterable $i$f$service2 = new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHBranchProtectionRule>>>(repositoryCoordinates){
                    final /* synthetic */ GHRepositoryCoordinates $repositoryCoordinates;

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHBranchProtectionRule>> invoke(@NotNull GHGQLRequestPagination it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GHGQLRequests.Repo.getProtectionRules$default(GHGQLRequests.Repo.INSTANCE, this.$repositoryCoordinates, null, 2, null);
                    }
                    {
                        this.$repositoryCoordinates = gHRepositoryCoordinates;
                        super(1);
                    }
                }, false, 0, 12, null).loadAll((ProgressIndicator)new SensitiveProgressWrapper(indicator));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GHBranchProtectionRule rule = (GHBranchProtectionRule)element$iv;
                    boolean bl8 = false;
                    String string = PatternUtil.convertToRegex((String)rule.getPattern());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PatternUtil.convertToRegex(rule.pattern)");
                    branchProtectionPatterns.add(string);
                }
            }
        }
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt2 = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl9 = false;
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(GithubProjectSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            ((GithubProjectSettings)object).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)branchProtectionPatterns));
        } else {
            boolean $i$f$invokeLater = false;
            Application application3 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(project, branchProtectionPatterns){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Set $branchProtectionPatterns$inlined;
                {
                    this.$project$inlined = project;
                    this.$branchProtectionPatterns$inlined = set;
                }

                public final void run() {
                    boolean bl = false;
                    Project $this$service$iv = this.$project$inlined;
                    boolean $i$f$service = false;
                    Object object = $this$service$iv.getService(GithubProjectSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
                    ((GithubProjectSettings)object).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)this.$branchProtectionPatterns$inlined));
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application3.invokeLater(runnable, modalityState);
        }
    }
}

