/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.dvcs.hosting.RepositoryListLoader;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.remote.GitRepositoryHostingService;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.extensions.GHHttpAuthDataProvider;
import org.jetbrains.plugins.github.extensions.GHRepositoryListLoader;
import org.jetbrains.plugins.github.extensions.GHSelectAccountHttpAuthDataProvider;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0017J$\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHRepositoryHostingService;", "Lgit4idea/remote/GitRepositoryHostingService;", "()V", "getInteractiveAuthDataProvider", "Lgit4idea/remote/InteractiveGitHttpAuthDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "login", "getProvider", "getRepositoryListLoader", "Lcom/intellij/dvcs/hosting/RepositoryListLoader;", "getServiceDisplayName", "intellij.vcs.github"})
public final class GHRepositoryHostingService
extends GitRepositoryHostingService {
    @NotNull
    public String getServiceDisplayName() {
        return "GitHub";
    }

    @NotNull
    public RepositoryListLoader getRepositoryListLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new GHRepositoryListLoader(project);
    }

    @RequiresBackgroundThread
    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getProvider(project, url, null);
    }

    @RequiresBackgroundThread
    @Nullable
    public InteractiveGitHttpAuthDataProvider getInteractiveAuthDataProvider(@NotNull Project project, @NotNull String url, @NotNull String login2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)login2, (String)"login");
        return this.getProvider(project, url, login2);
    }

    private final InteractiveGitHttpAuthDataProvider getProvider(Project project, String url, String login2) {
        Set<GithubAccount> accounts = GHHttpAuthDataProvider.Companion.getGitAuthenticationAccounts(project, url, login2);
        Collection collection = accounts;
        boolean bl = false;
        return !collection.isEmpty() ? (InteractiveGitHttpAuthDataProvider)new GHSelectAccountHttpAuthDataProvider(project, (Collection<GithubAccount>)accounts) : null;
    }
}

