/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.javascript.debugger.browserConnection.BrowserQualifier;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChromeExtensionUtil {
    private static final Logger LOG = Logger.getInstance(ChromeExtensionUtil.class);
    @NonNls
    public static final String URL = "https://chrome.google.com/webstore/detail/jetbrains-ide-support/hmhgeddbohgjknpmjagkdomcpobmllji";

    private ChromeExtensionUtil() {
    }

    public static boolean isChromeRunning(@NotNull WebBrowser browser) {
        if (browser == null) {
            ChromeExtensionUtil.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isUnix) {
            String[] files = SystemInfo.isMac ? new String[]{"/Library/Application Support/Google/Chrome", "/Library/Application Support/Google/Chrome Canary", "/Library/Application Support/Chromium", "/Library/Application Support/Yandex/YandexBrowser", "/Library/Application Support/com.operasoftware.Opera"} : new String[]{"/.config/google-chrome", "/.config/chromium"};
            for (String file : files) {
                if (!ChromeExtensionUtil.isChromeRunningUnderUnix(file)) continue;
                return true;
            }
        } else {
            String pattern;
            BrowserQualifier browserQualifier = BrowserConnectionManager.browserToQualifier((WebBrowser)browser);
            switch (browserQualifier) {
                case CHROME: 
                case DARTIUM: {
                    pattern = "chrome.exe";
                    break;
                }
                case YANDEX: {
                    pattern = "browser.exe";
                    break;
                }
                case OPERA: {
                    pattern = "opera.exe";
                    break;
                }
                default: {
                    return false;
                }
            }
            for (ProcessInfo process2 : OSProcessUtil.getProcessList()) {
                if (!process2.getCommandLine().contains(pattern)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isChromeRunningUnderUnix(String singletonLockFilename) {
        File file = new File(SystemProperties.getUserHome() + singletonLockFilename, "SingletonLock");
        if (!SystemInfo.isMac && FileSystemUtil.isSymLink((File)file)) {
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        try {
            FileLock lock = null;
            RandomAccessFile in = new RandomAccessFile(file, "rw");
            try {
                lock = in.getChannel().tryLock();
                if (lock != null) return false;
                boolean bl = true;
                return bl;
            }
            catch (OverlappingFileLockException ignored) {
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                finally {
                    in.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browser", "com/jetbrains/debugger/wip/ChromeExtensionUtil", "isChromeRunning"));
    }

    public static class ExtLinkListener
    extends BrowserHyperlinkListener
    implements NotificationListener {
        private final WebBrowser browser;
        @Nullable
        private final Project project;

        public ExtLinkListener(@NotNull WebBrowser browser, @Nullable Project project) {
            if (browser == null) {
                ExtLinkListener.$$$reportNull$$$0(0);
            }
            this.browser = browser;
            this.project = project;
        }

        protected void hyperlinkActivated(@NotNull HyperlinkEvent event) {
            if (event == null) {
                ExtLinkListener.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)event.getDescription())) {
                BrowserLauncher.getInstance().browse(ChromeExtensionUtil.URL, this.browser, this.project);
            } else {
                super.hyperlinkActivated(event);
            }
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                ExtLinkListener.$$$reportNull$$$0(2);
            }
            if (event == null) {
                ExtLinkListener.$$$reportNull$$$0(3);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.hyperlinkActivated(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "browser";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/debugger/wip/ChromeExtensionUtil$ExtLinkListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkActivated";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hyperlinkUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

