/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunner;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140 2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createRunProcess", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "enableDebuggingMode", "Lorg/jetbrains/concurrency/Promise;", "", "execute", "Lcom/intellij/execution/ui/RunContentDescriptor;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "resolveAndroidPackageName", "resolveAndroidPackageNameInManifest", "projectPath", "runReactNative", "", "packagerProcess", "Lcom/intellij/execution/process/ProcessHandler;", "startDebugProcess", "Ljava/util/concurrent/CompletableFuture;", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "reactNativeRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof ReactNativeRunConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Run") || Intrinsics.areEqual((Object)executorId, (Object)"Debug"));
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration");
        }
        ReactNativeRunConfiguration configuration = (ReactNativeRunConfiguration)runProfile;
        PackagerState startedPackager = ReactNativePackagerKt.findStartedPackager(configuration);
        CompletableFuture<Unit> packagerFuture = null;
        ProcessHandler packagerProcess = null;
        if (startedPackager != null) {
            packagerFuture = startedPackager.getReady();
            packagerProcess = startedPackager.getProcess();
        } else {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(Unit)");
            packagerFuture = completableFuture;
            packagerProcess = null;
        }
        Executor executor = environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"environment.executor");
        boolean isRun = Intrinsics.areEqual((Object)executor.getId(), (Object)"Run");
        AsyncPromise result = new AsyncPromise();
        ((CompletableFuture)packagerFuture.thenCompose(new Function(this, isRun, configuration, environment, packagerProcess){
            final /* synthetic */ ReactNativeProgramRunner this$0;
            final /* synthetic */ boolean $isRun;
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ ProcessHandler $packagerProcess;

            public final CompletionStage<RunContentDescriptor> apply(Unit it) {
                if (!this.$isRun && this.$configuration.getBuildAndLaunch()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ execute.1 this$0;

                        public final void run() {
                            ReactNativeProgramRunner.access$runReactNative(this.this$0.this$0, this.this$0.$environment, this.this$0.$configuration, this.this$0.$packagerProcess);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                if (this.$isRun) {
                    if (!this.$configuration.getBuildAndLaunch()) {
                        return CompletableFuture.completedFuture(null);
                    }
                    CompletableFuture<T> runContentFuture = new CompletableFuture<T>();
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, runContentFuture){
                        final /* synthetic */ execute.1 this$0;
                        final /* synthetic */ CompletableFuture $runContentFuture;

                        public final void run() {
                            KillableColoredProcessHandler runHandler = ReactNativeProgramRunner.access$createRunProcess(this.this$0.this$0, this.this$0.$configuration, this.this$0.$environment);
                            ConsoleViewImpl consoleView = new ConsoleViewImpl(this.this$0.$environment.getProject(), false);
                            consoleView.attachToProcess((ProcessHandler)runHandler);
                            RunContentBuilder builder = new RunContentBuilder((ExecutionResult)new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)runHandler), this.this$0.$environment);
                            this.$runContentFuture.complete(builder.showRunContent(this.this$0.$environment.getContentToReuse()));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$runContentFuture = completableFuture;
                        }
                    });
                    return runContentFuture;
                }
                return ReactNativeProgramRunner.access$startDebugProcess(this.this$0, this.$configuration, this.$environment);
            }
            {
                this.this$0 = reactNativeProgramRunner;
                this.$isRun = bl;
                this.$configuration = reactNativeRunConfiguration;
                this.$environment = executionEnvironment;
                this.$packagerProcess = processHandler;
            }
        })).handle(new BiFunction(result){
            final /* synthetic */ AsyncPromise $result;

            public final Object apply(RunContentDescriptor r, Throwable t) {
                Object object;
                if (t != null) {
                    Object object2 = t.getCause();
                    if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                        object2 = "Failed to connect to bundler";
                    }
                    object = this.$result.setError((String)object2);
                } else {
                    this.$result.setResult((Object)r);
                    object = Unit.INSTANCE;
                }
                return object;
            }
            {
                this.$result = asyncPromise;
            }
        });
        return (Promise)result;
    }

    private final void runReactNative(ExecutionEnvironment environment, ReactNativeRunConfiguration configuration, ProcessHandler packagerProcess) {
        KillableColoredProcessHandler runHandler = this.createRunProcess(configuration, environment);
        ConsoleView consoleView = ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native " + configuration.getPlatform().getCommandLineArgument(), (ProcessHandler)runHandler, environment);
        if (packagerProcess != null) {
            AtomicBoolean packagerStartedDebug = new AtomicBoolean(false);
            ProcessAdapter startDebuggerListener = null;
            startDebuggerListener = new ProcessAdapter(packagerStartedDebug, packagerProcess, environment){
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ExecutionEnvironment $environment;

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = event.getText();
                    if (string != null) {
                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting custom debugger by executing", (boolean)false, (int)2, null)) {
                            this.$packagerStartedDebug.set(true);
                            this.$packagerProcess.removeProcessListener((ProcessListener)this);
                            Project project = this.$environment.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
                            Balloon balloon = ToolWindowManager.Companion.getInstance(project).getToolWindowBalloon("Debug");
                            if (balloon != null) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(balloon){
                                    final /* synthetic */ Balloon $balloon;

                                    public final void run() {
                                        this.$balloon.hide();
                                    }
                                    {
                                        this.$balloon = balloon;
                                    }
                                });
                            }
                        }
                    }
                }
                {
                    this.$packagerStartedDebug = $captured_local_variable$0;
                    this.$packagerProcess = $captured_local_variable$1;
                    this.$environment = $captured_local_variable$2;
                }
            };
            packagerProcess.addProcessListener((ProcessListener)startDebuggerListener);
            Disposer.register((Disposable)((Disposable)consoleView), (Disposable)new Disposable(packagerProcess, startDebuggerListener){
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ProcessAdapter $startDebuggerListener;

                public final void dispose() {
                    this.$packagerProcess.removeProcessListener((ProcessListener)this.$startDebuggerListener);
                }
                {
                    this.$packagerProcess = processHandler;
                    this.$startDebuggerListener = processAdapter;
                }
            });
            AtomicBoolean appLaunchedMessageReceived = new AtomicBoolean(false);
            runHandler.addProcessListener((ProcessListener)new ProcessAdapter(this, appLaunchedMessageReceived, packagerStartedDebug, configuration, packagerProcess, startDebuggerListener, environment){
                final /* synthetic */ ReactNativeProgramRunner this$0;
                final /* synthetic */ AtomicBoolean $appLaunchedMessageReceived;
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ReactNativeRunConfiguration $configuration;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ProcessAdapter $startDebuggerListener;
                final /* synthetic */ ExecutionEnvironment $environment;

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                    block2: {
                        block1: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            String string = event.getText();
                            if (string != null && StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting", (boolean)false, (int)2, null)) break block1;
                            String string2 = event.getText();
                            if (string2 == null) break block2;
                            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"Launching", (boolean)false, (int)2, null)) break block2;
                        }
                        this.$appLaunchedMessageReceived.set(true);
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this){
                        final /* synthetic */ runReactNative.3 this$0;

                        public final void run() {
                            if (!this.this$0.$packagerStartedDebug.get()) {
                                ReactNativeProgramRunner.access$enableDebuggingMode(this.this$0.this$0, this.this$0.$configuration);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                    Function2<String, Long, Unit> $fun$scheduleWarning$2 = new Function2<String, Long, Unit>(this){
                        final /* synthetic */ runReactNative.3 this$0;

                        public final void invoke(@NotNull String message, long timeoutSec) {
                            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                            AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(this, message){
                                final /* synthetic */ runReactNative.processTerminated.2 this$0;
                                final /* synthetic */ String $message;

                                public final void run() {
                                    if (!this.this$0.this$0.$packagerStartedDebug.get()) {
                                        this.this$0.this$0.$packagerProcess.removeProcessListener((ProcessListener)this.this$0.this$0.$startDebuggerListener);
                                        ApplicationManager.getApplication().invokeLater(new Runnable(this){
                                            final /* synthetic */ runReactNative.processTerminated.1 this$0;

                                            public final void run() {
                                                Project project = this.this$0.this$0.this$0.$environment.getProject();
                                                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
                                                ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                                                MessageType messageType = MessageType.WARNING;
                                                Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.WARNING");
                                                toolWindowManager.notifyByBalloon("Debug", messageType, this.this$0.$message);
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        });
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$message = string;
                                }
                            }, timeoutSec, TimeUnit.SECONDS);
                        }
                        {
                            this.this$0 = var1_1;
                            super(2);
                        }
                    };
                    String string = this.$appLaunchedMessageReceived.get() ? JSDebuggerBundle.message((String)"react.native.runner.warning.connection.wait", (Object[])new Object[0]) : JSDebuggerBundle.message((String)"react.native.runner.warning.build.failed", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (appLaunchedMessageRe\u2026er.warning.build.failed\")");
                    String message = string;
                    $fun$scheduleWarning$2.invoke(message, 5L);
                }
                {
                    this.this$0 = this$0;
                    this.$appLaunchedMessageReceived = $captured_local_variable$1;
                    this.$packagerStartedDebug = $captured_local_variable$2;
                    this.$configuration = $captured_local_variable$3;
                    this.$packagerProcess = $captured_local_variable$4;
                    this.$startDebuggerListener = $captured_local_variable$5;
                    this.$environment = $captured_local_variable$6;
                }
            });
        }
        runHandler.startNotify();
    }

    private final KillableColoredProcessHandler createRunProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        NodeJsInterpreter nodeJsInterpreter = configuration.getNodePath().resolveNotNull(environment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"configuration.nodePath.r\u2026Null(environment.project)");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodePackage nodePackage = configuration.getReactNativePackage();
        if (nodePackage == null) {
            throw (Throwable)new ConfigurationException(JSDebuggerBundle.message((String)"react.native.error.invalid.react.native.path", (Object[])new Object[0]));
        }
        NodePackage reactNativePackage = nodePackage;
        runCommandLine.addParameter(ReactNativeProgramRunnerKt.reactNativePackageToNodeArgument(reactNativePackage));
        runCommandLine.addParameter(configuration.getPlatform().getCommandLineArgument());
        runCommandLine.getParametersList().addParametersString(configuration.getRunArguments());
        runCommandLine.withWorkDirectory(configuration.getEffectiveWorkingDirectory());
        configuration.getEnvData().configureCommandLine(runCommandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)runCommandLine);
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(runCommandLine);
        return new KillableColoredProcessHandler(runCommandLine);
    }

    private final CompletableFuture<RunContentDescriptor> startDebugProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        CompletableFuture<RunContentDescriptor> result = new CompletableFuture<RunContentDescriptor>();
        AppUIUtil.invokeOnEdt((Runnable)new Runnable(configuration, environment, result){
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ CompletableFuture $result;

            public final void run() {
                XDebugProcessStarter starter2 = new XDebugProcessStarter(this){
                    final /* synthetic */ startDebugProcess.1 this$0;

                    @NotNull
                    public XDebugProcess start(@NotNull XDebugSession session) {
                        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                        Url debugUrl = ReactNativeProgramRunnerKt.chromeDebugUrl(this.this$0.$configuration.getPackagerHost(), this.this$0.$configuration.getPackagerPort());
                        DefaultExecutionResult executionResult = new DefaultExecutionResult();
                        ChromeLocalVmConnection connection2 = new ChromeLocalVmConnection(debugUrl, true, this.this$0.$configuration.getBrowser(), session.getRunProfile());
                        ChromeDebugProcess process2 = new ChromeDebugProcess(session, (DebuggableFileFinder)new RemoteDebuggingFileFinder(null, null, 3, null), (VmConnection<? extends WipVm>)((VmConnection)connection2), (ExecutionResult)executionResult);
                        connection2.connect(session);
                        return (XDebugProcess)process2;
                    }
                    {
                        this.this$0 = this$0;
                    }
                };
                try {
                    XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.$environment.getProject()).startSession(this.$environment, starter2);
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026ion(environment, starter)");
                    XDebugSession startSession = xDebugSession;
                    this.$result.complete(startSession.getRunContentDescriptor());
                }
                catch (Throwable e) {
                    this.$result.completeExceptionally(e);
                    throw e;
                }
            }
            {
                this.$configuration = reactNativeRunConfiguration;
                this.$environment = executionEnvironment;
                this.$result = completableFuture;
            }
        });
        return result;
    }

    private final Promise<Object> enableDebuggingMode(ReactNativeRunConfiguration configuration) {
        if (configuration.getPlatform() != ReactNativePlatform.ANDROID) {
            return Promises.resolvedPromise();
        }
        String string = this.resolveAndroidPackageName(configuration);
        if (string == null) {
            return Promises.resolvedPromise();
        }
        String packageName = string;
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        runCommandLine.setExePath("adb");
        runCommandLine.addParameters(new String[]{"shell", "am", "broadcast", "-a", packageName + ".RELOAD_APP_ACTION", "--ez", "jsproxy", "true"});
        AsyncPromise result = new AsyncPromise();
        KillableProcessHandler adbProcessHandler = new KillableProcessHandler(runCommandLine);
        adbProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(result){
            final /* synthetic */ AsyncPromise $result;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$result.setResult(null);
            }
            {
                this.$result = $captured_local_variable$0;
            }
        });
        adbProcessHandler.startNotify();
        return (Promise)result;
    }

    private final String resolveAndroidPackageName(ReactNativeRunConfiguration configuration) {
        String effectiveWorkingDirectory = configuration.getEffectiveWorkingDirectory();
        String valueInAndroidXml = this.resolveAndroidPackageNameInManifest(effectiveWorkingDirectory);
        if (valueInAndroidXml != null) {
            return valueInAndroidXml;
        }
        String string = PathUtil.getFileName((String)effectiveWorkingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(effectiveWorkingDirectory)");
        String defaultName = string;
        String string2 = "com." + defaultName;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return string4;
    }

    private final String resolveAndroidPackageNameInManifest(String projectPath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(projectPath);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026ojectPath) ?: return null");
        VirtualFile workingDir = virtualFile;
        VirtualFile virtualFile2 = workingDir.findFileByRelativePath("android/app/src/main/AndroidManifest.xml");
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"workingDir.findFileByRel\u2026fest.xml\") ?: return null");
        VirtualFile manifestFile = virtualFile2;
        String string = VfsUtil.loadText((VirtualFile)manifestFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtil.loadText(manifestFile)");
        String text = string;
        Matcher matcher = Pattern.compile("package=\"([^\"\\n]+)\"").matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final /* synthetic */ void access$runReactNative(ReactNativeProgramRunner $this, ExecutionEnvironment environment, ReactNativeRunConfiguration configuration, ProcessHandler packagerProcess) {
        $this.runReactNative(environment, configuration, packagerProcess);
    }

    public static final /* synthetic */ KillableColoredProcessHandler access$createRunProcess(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        return $this.createRunProcess(configuration, environment);
    }

    public static final /* synthetic */ CompletableFuture access$startDebugProcess(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        return $this.startDebugProcess(configuration, environment);
    }

    public static final /* synthetic */ Promise access$enableDebuggingMode(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration) {
        return $this.enableDebuggingMode(configuration);
    }
}

