/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.protocol;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;
import org.jetbrains.v8.liveEditProtocol.LiveEditProtocolReader;
import org.jetbrains.v8.liveEditProtocol.LiveEditProtocolReaderImpl;
import org.jetbrains.v8.protocol.ObjectValueHandle;
import org.jetbrains.v8.protocol.PropertyInfo;
import org.jetbrains.v8.protocol.PropertyNameGetter;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.SomeRef;
import org.jetbrains.v8.protocol.V8ProtocolReader;
import org.jetbrains.v8.protocol.V8ProtocolReaderImpl;
import org.jetbrains.v8.value.PropertyItem;
import org.jetbrains.v8.value.PropertyType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u0002H\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\u00a2\u0006\u0002\u0010\u0011\u001a)\u0010\u0012\u001a\u0004\u0018\u00010\r\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0013\u001a\u0002H\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0010\u00a2\u0006\u0002\u0010\u0014\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010\u0016\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"LIVE_EDIT", "Lorg/jetbrains/v8/liveEditProtocol/LiveEditProtocolReader;", "getLIVE_EDIT", "()Lorg/jetbrains/v8/liveEditProtocol/LiveEditProtocolReader;", "PROTOCOL_READER", "Lorg/jetbrains/v8/protocol/V8ProtocolReader;", "getPROTOCOL_READER", "()Lorg/jetbrains/v8/protocol/V8ProtocolReader;", "addPropertyItem", "", "OBJ", "list", "", "Lorg/jetbrains/v8/value/PropertyItem;", "propertyInfo", "nameGetter", "Lorg/jetbrains/v8/protocol/PropertyNameGetter;", "(Ljava/util/List;Ljava/lang/Object;Lorg/jetbrains/v8/protocol/PropertyNameGetter;)V", "createPropertyItem", "prop", "(Ljava/lang/Object;Lorg/jetbrains/v8/protocol/PropertyNameGetter;)Lorg/jetbrains/v8/value/PropertyItem;", "extractObjectProperties", "", "handle", "Lorg/jetbrains/v8/protocol/ObjectValueHandle;", "getScriptType", "Lorg/jetbrains/debugger/Script$Type;", "typeNumber", "", "validScript", "Lorg/jetbrains/v8/protocol/ScriptHandle;", "script", "refs", "Lorg/jetbrains/v8/protocol/SomeHandle;", "intellij.javascript.v8.backend"})
public final class V8ProtocolUtilKt {
    @NotNull
    private static final V8ProtocolReader PROTOCOL_READER = new V8ProtocolReaderImpl();
    @NotNull
    private static final LiveEditProtocolReader LIVE_EDIT = new LiveEditProtocolReaderImpl();

    @NotNull
    public static final V8ProtocolReader getPROTOCOL_READER() {
        return PROTOCOL_READER;
    }

    @NotNull
    public static final LiveEditProtocolReader getLIVE_EDIT() {
        return LIVE_EDIT;
    }

    @Nullable
    public static final Script.Type getScriptType(int typeNumber) {
        Script.Type type;
        if (typeNumber == -1) {
            return null;
        }
        switch (typeNumber) {
            case 4: {
                type = Script.Type.NORMAL;
                break;
            }
            case 0: 
            case 1: {
                type = Script.Type.NATIVE;
                break;
            }
            case 2: {
                type = Script.Type.EXTENSION;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("unknown script type: " + typeNumber);
            }
        }
        return type;
    }

    @NotNull
    public static final List<PropertyItem> extractObjectProperties(@NotNull ObjectValueHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        List<PropertyInfo> properties = handle.getProperties();
        SomeRef protoObject = handle.getProtoObject();
        List result = null;
        if (UtilKt.isNullOrEmpty((Collection)properties)) {
            if (protoObject == null) {
                return CollectionsKt.emptyList();
            }
            result = (List)new SmartList();
        } else {
            List<PropertyInfo> list = properties;
            Intrinsics.checkNotNull(list);
            result = new ArrayList(list.size() + (protoObject == null ? 0 : 1));
            for (PropertyInfo property : properties) {
                PropertyNameGetter<PropertyInfo> propertyNameGetter = PropertyNameGetter.SUB_PROPERTY;
                Intrinsics.checkNotNullExpressionValue(propertyNameGetter, (String)"PropertyNameGetter.SUB_PROPERTY");
                V8ProtocolUtilKt.addPropertyItem(result, property, propertyNameGetter);
            }
        }
        if (protoObject != null) {
            PropertyNameGetter<SomeRef> propertyNameGetter = PropertyNameGetter.PROTO_OBJECT;
            Intrinsics.checkNotNullExpressionValue(propertyNameGetter, (String)"PropertyNameGetter.PROTO_OBJECT");
            V8ProtocolUtilKt.addPropertyItem(result, protoObject, propertyNameGetter);
        }
        return result;
    }

    public static final <OBJ> void addPropertyItem(@NotNull List<PropertyItem> list, OBJ propertyInfo, @NotNull PropertyNameGetter<OBJ> nameGetter) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(nameGetter, (String)"nameGetter");
        PropertyItem reference = V8ProtocolUtilKt.createPropertyItem(propertyInfo, nameGetter);
        if (reference != null) {
            list.add(reference);
        }
    }

    @Nullable
    public static final <OBJ> PropertyItem createPropertyItem(OBJ prop, @NotNull PropertyNameGetter<OBJ> nameGetter) {
        int propTypeValue;
        Intrinsics.checkNotNullParameter(nameGetter, (String)"nameGetter");
        String name = nameGetter.getName(prop);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        int propType = nameGetter.getPropertyType(prop);
        int n = propTypeValue = propType != -1 ? propType : PropertyType.NORMAL.value;
        if (propTypeValue == PropertyType.FIELD.value || propTypeValue == PropertyType.CONSTANT_FUNCTION.value || propTypeValue == PropertyType.CALLBACKS.value || propTypeValue == PropertyType.NORMAL.value) {
            return new PropertyItem(name, nameGetter.getRef(prop));
        }
        return null;
    }

    @Nullable
    public static final ScriptHandle validScript(@Nullable ScriptHandle script, @Nullable List<? extends SomeHandle> refs) {
        if (refs == null || script == null) {
            return null;
        }
        SomeRef child = script.getContext();
        int contextRef = child == null ? -1 : child.getRef();
        for (SomeHandle someHandle : refs) {
            if (someHandle.handle() != contextRef) continue;
            return script;
        }
        return null;
    }
}

