/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.EvaluateSessionKt;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipEvaluateContextBase;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.EvaluateOnCallFrameResult;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001:\u0018\u00002\u00020\u0001:\u0001HB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010G\u001a\u00020\u000fH\u0016R\"\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0016\u0010%\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u001e\u0010,\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0011R\u0014\u0010.\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u0014\u0010/\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0015R\u001c\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u000103028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u000103X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0010\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010;R*\u0010=\u001a\b\u0012\u0004\u0012\u00020<0\b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020<0\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u000bR\"\u0010?\u001a\u0004\u0018\u00010\u000f2\b\u0010+\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0011R\u0010\u0010A\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\u000b\u00a8\u0006I"}, d2={"Lorg/jetbrains/wip/WipCallFrame;", "Lorg/jetbrains/debugger/CallFrame;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "cf", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "(Lorg/jetbrains/wip/WipValueManager;Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;)V", "_variableScopes", "", "Lorg/jetbrains/debugger/Scope;", "get_variableScopes", "()Ljava/util/List;", "set_variableScopes", "(Ljava/util/List;)V", "asyncFunctionName", "", "getAsyncFunctionName", "()Ljava/lang/String;", "column", "", "getColumn", "()I", "equalityObject", "", "getEqualityObject", "()Ljava/lang/Object;", "evaluateContext", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "getEvaluateContext", "()Lorg/jetbrains/wip/WipEvaluateContextBase;", "functionLocation", "Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "getFunctionLocation", "()Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "setFunctionLocation", "(Lorg/jetbrains/wip/protocol/debugger/LocationValue;)V", "functionName", "getFunctionName", "hasOnlyGlobalScope", "", "getHasOnlyGlobalScope", "()Z", "<set-?>", "id", "getId", "isFromAsyncStack", "line", "getLine", "receiverVariable", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/Variable;", "getReceiverVariable", "()Lorg/jetbrains/concurrency/Promise;", "returnValue", "getReturnValue", "()Lorg/jetbrains/debugger/Variable;", "returnValueModifier", "org/jetbrains/wip/WipCallFrame$returnValueModifier$1", "Lorg/jetbrains/wip/WipCallFrame$returnValueModifier$1;", "Lorg/jetbrains/wip/protocol/debugger/ScopeValue;", "scopesData", "getScopesData", "scriptId", "getScriptId", "thisObject", "variableScopes", "getVariableScopes", "reinit", "", "frameData", "toString", "WipCallFrameEvaluateContext", "intellij.javascript.wip.backend"})
public final class WipCallFrame
implements CallFrame {
    private final int line;
    private final int column;
    @Nullable
    private final String functionName;
    @Nullable
    private final String asyncFunctionName;
    @Nullable
    private final Variable returnValue;
    @NotNull
    private final WipEvaluateContextBase<EvaluateOnCallFrameResult> evaluateContext;
    @Nullable
    private LocationValue functionLocation;
    @NotNull
    private String id;
    private Variable thisObject;
    @Nullable
    private String scriptId;
    @NotNull
    private List<? extends ScopeValue> scopesData;
    @Nullable
    private List<? extends Scope> _variableScopes;
    private final returnValueModifier.1 returnValueModifier;
    private final WipValueManager valueManager;

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    @Nullable
    public String getAsyncFunctionName() {
        return this.asyncFunctionName;
    }

    public boolean isFromAsyncStack() {
        return false;
    }

    @Nullable
    public Variable getReturnValue() {
        return this.returnValue;
    }

    @NotNull
    public WipEvaluateContextBase<EvaluateOnCallFrameResult> getEvaluateContext() {
        return this.evaluateContext;
    }

    @Nullable
    public final LocationValue getFunctionLocation() {
        return this.functionLocation;
    }

    public final void setFunctionLocation(@Nullable LocationValue locationValue) {
        this.functionLocation = locationValue;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getScriptId() {
        return this.scriptId;
    }

    @NotNull
    public final List<ScopeValue> getScopesData() {
        return this.scopesData;
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        return Promises.resolvedPromise((Object)this.thisObject);
    }

    @NotNull
    public Object getEqualityObject() {
        return this.scriptId + '#' + this.getFunctionName();
    }

    public boolean getHasOnlyGlobalScope() {
        return this.scopesData.size() == 1 && ((ScopeValue)CollectionsKt.first(this.scopesData)).type() == ScopeValue.Type.GLOBAL;
    }

    @Nullable
    public final List<Scope> get_variableScopes() {
        return this._variableScopes;
    }

    public final void set_variableScopes(@Nullable List<? extends Scope> list) {
        this._variableScopes = list;
    }

    @NotNull
    public List<Scope> getVariableScopes() {
        if (this._variableScopes == null) {
            this._variableScopes = ArraysKt.asList((Object[])WipSuspendContextManagerKt.createScopes(this.scopesData, this.id, this.valueManager));
        }
        List<Scope> list = this._variableScopes;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public final void reinit(@NotNull CallFrameValue frameData, @NotNull WipValueManager valueManager) {
        Intrinsics.checkNotNullParameter((Object)frameData, (String)"frameData");
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        CommandProcessorKt.getLOG().assertTrue(Comparing.strEqual((String)frameData.functionName(), (String)this.getFunctionName()));
        CommandProcessorKt.getLOG().assertTrue(this.getLine() == frameData.location().getLineNumber());
        this.scopesData = frameData.scopeChain();
        this._variableScopes = null;
        this.id = frameData.callFrameId();
        this.scriptId = frameData.location().scriptId();
        RemoteObjectValue thisObjectData = frameData.getGetThis();
        if (thisObjectData == null) {
            CommandProcessorKt.getLOG().warn("Missing local scope");
            this.thisObject = null;
        } else {
            this.thisObject = (Variable)valueManager.createVariable("this", thisObjectData, null);
        }
    }

    @NotNull
    public String toString() {
        return this.scriptId + ' ' + this.getFunctionName() + ' ' + this.getLine() + ':' + this.getColumn();
    }

    public WipCallFrame(@NotNull WipValueManager valueManager, @NotNull CallFrameValue cf) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        Intrinsics.checkNotNullParameter((Object)cf, (String)"cf");
        this.valueManager = valueManager;
        this.scopesData = CollectionsKt.emptyList();
        this.returnValueModifier = new ValueModifier(this){
            final /* synthetic */ WipCallFrame this$0;

            @NotNull
            public Promise<?> setValue(@NotNull Variable variable, @NotNull Value newValue, @NotNull EvaluateContext evaluateContext2) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)evaluateContext2, (String)"evaluateContext");
                variable.setValue(newValue);
                return WipCallFrame.access$getValueManager$p(this.this$0).getVm().getCommandProcessor().send((Request)DebuggerKt.SetReturnValue(EvaluateSessionKt.createCallArgument(newValue)));
            }

            @NotNull
            public Promise<?> setValue(@NotNull Variable variable, @NotNull String newValue, @NotNull EvaluateContext evaluateContext2) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)evaluateContext2, (String)"evaluateContext");
                return ValueModifierUtil.INSTANCE.setValue(variable, "{\n(" + newValue + ")\n}", evaluateContext2, (ValueModifier)this);
            }

            @NotNull
            public Promise<Value> evaluateGet(@NotNull Variable variable, @NotNull EvaluateContext evaluateContext2) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)evaluateContext2, (String)"evaluateContext");
                return ValueModifierUtil.INSTANCE.evaluateGet(variable, (Object)this, evaluateContext2, "this");
            }
            {
                this.this$0 = this$0;
            }
        };
        this.evaluateContext = new WipCallFrameEvaluateContext(this.valueManager);
        this.line = cf.location().getLineNumber();
        this.column = cf.location().getColumnNumber();
        this.functionName = cf.functionName();
        this.functionLocation = cf.getFunctionLocation();
        this.asyncFunctionName = null;
        this.id = cf.callFrameId();
        this.reinit(cf, this.valueManager);
        this.returnValue = cf.getReturnValue() != null ? (Variable)this.valueManager.createVariable("returnValue", cf.getReturnValue(), this.returnValueModifier) : null;
    }

    public static final /* synthetic */ String access$getId$p(WipCallFrame $this) {
        return $this.id;
    }

    public static final /* synthetic */ void access$setId$p(WipCallFrame $this, String string) {
        $this.id = string;
    }

    public static final /* synthetic */ WipValueManager access$getValueManager$p(WipCallFrame $this) {
        return $this.valueManager;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0014\u0010\u0010\u001a\u00060\u0000R\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/wip/WipCallFrame$WipCallFrameEvaluateContext;", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "(Lorg/jetbrains/wip/WipCallFrame;Lorg/jetbrains/wip/WipValueManager;)V", "createRequest", "Lorg/jetbrains/wip/protocol/WipRequest;", "expression", "", "awaitPromise", "", "getRemoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "data", "getWasThrown", "withValueManager", "Lorg/jetbrains/wip/WipCallFrame;", "objectGroup", "intellij.javascript.wip.backend"})
    private final class WipCallFrameEvaluateContext
    extends WipEvaluateContextBase<EvaluateOnCallFrameResult> {
        @Override
        @NotNull
        public WipRequest<EvaluateOnCallFrameResult> createRequest(@NotNull String expression, @NotNull WipValueManager valueManager, boolean awaitPromise) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
            return DebuggerKt.EvaluateOnCallFrame$default(WipCallFrame.this.getId(), expression, valueManager.getObjectGroupId$intellij_javascript_wip_backend(), null, null, null, true, null, null, 440, null);
        }

        @Override
        @NotNull
        protected RemoteObjectValue getRemoteObjectValue(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.result();
        }

        @Override
        protected boolean getWasThrown(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.getExceptionDetails() != null;
        }

        @NotNull
        public WipCallFrameEvaluateContext withValueManager(@NotNull String objectGroup) {
            Intrinsics.checkNotNullParameter((Object)objectGroup, (String)"objectGroup");
            return new WipCallFrameEvaluateContext(new WipValueManager(((WipValueManager)this.getValueManager()).getVm(), objectGroup));
        }

        public WipCallFrameEvaluateContext(WipValueManager valueManager) {
            Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
            super(valueManager);
        }
    }
}

