/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.apple.sdk;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.apple.sdk.AppleSdkManagerBase;
import com.jetbrains.cidr.ArchitectureType;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArchitectureValue
implements Comparable<ArchitectureValue> {
    public static final ArchitectureValue i386 = new ArchitectureValue("i386");
    public static final ArchitectureValue x86_64 = new ArchitectureValue("x86_64");
    public static final ArchitectureValue arm64 = new ArchitectureValue("arm64");
    public static final ArchitectureValue HOST_ARCH = CpuArch.isArm64() ? arm64 : x86_64;
    public static final ImmutableSet<ArchitectureValue> KNOWN_HOST_ARCHS = ImmutableSet.of((Object)i386, (Object)x86_64, (Object)arm64);
    private static final List<@NlsSafe String> SORTED_ARCHS = ContainerUtil.newLinkedList((Object[])new String[]{"armv7k", "armv7s", "armv7", "arm64_32", "arm64", "i386", "x86_64"});
    @NotNull
    private final String myId;

    @Contract(pure=true)
    public ArchitectureValue(@NotNull @NlsSafe String id) {
        if (id == null) {
            ArchitectureValue.$$$reportNull$$$0(0);
        }
        this.myId = id;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static ArchitectureValue create(@Nullable String id) {
        return id != null ? new ArchitectureValue(id) : null;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = this.myId;
        if (string == null) {
            ArchitectureValue.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ArchitectureType getType() {
        ArchitectureType architectureType = ArchitectureType.forArchitecture((String)this.myId);
        if (architectureType == null) {
            ArchitectureValue.$$$reportNull$$$0(2);
        }
        return architectureType;
    }

    public int getBits() {
        return this.getType().getBits();
    }

    @NlsSafe
    public String toString() {
        return this.myId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArchitectureValue value = (ArchitectureValue)o;
        return this.myId.equals(value.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    @Override
    public int compareTo(@NotNull ArchitectureValue o) {
        if (o == null) {
            ArchitectureValue.$$$reportNull$$$0(3);
        }
        return Integer.compare(ArchitectureValue.getArchWeight(this.myId), ArchitectureValue.getArchWeight(o.myId));
    }

    private static int getArchWeight(@NotNull String id) {
        int weight;
        if (id == null) {
            ArchitectureValue.$$$reportNull$$$0(4);
        }
        if ((weight = SORTED_ARCHS.indexOf(id)) == -1) {
            AppleSdkManagerBase.LOG.warn("Unknown architecture: " + id);
        }
        return weight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/apple/sdk/ArchitectureValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/apple/sdk/ArchitectureValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArchWeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

