/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.StringKt;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.cpp.toolchains.CheckedVersion;
import com.jetbrains.cidr.cpp.ui.UIUtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J!\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\rJ1\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\n2\b\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/VersionChecker;", "ItemT", "", "requireNonEmpty", "", "(Z)V", "selectedItem", "getSelectedItem", "()Ljava/lang/Object;", "check", "Lcom/jetbrains/cidr/cpp/toolchains/CheckedVersion;", "selectedToolSet", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPToolSet;Ljava/lang/Object;)Lcom/jetbrains/cidr/cpp/toolchains/CheckedVersion;", "readAndCheckVersion", "render", "", "version", "text", "Lcom/intellij/ui/ColoredTextContainer;", "showRawVersion", "(Lcom/jetbrains/cidr/cpp/toolchains/CheckedVersion;Ljava/lang/Object;Lcom/intellij/ui/ColoredTextContainer;Z)V", "intellij.cidr.toolchains"})
public abstract class VersionChecker<ItemT> {
    private final boolean requireNonEmpty;

    @Nullable
    public abstract ItemT getSelectedItem();

    @Nullable
    public abstract CheckedVersion readAndCheckVersion(@Nullable CPPToolSet var1, @Nullable ItemT var2);

    @Nullable
    public final CheckedVersion check(@Nullable CPPToolSet selectedToolSet, @Nullable ItemT selectedItem) {
        if (selectedItem == null && this.requireNonEmpty) {
            return null;
        }
        return this.readAndCheckVersion(selectedToolSet, selectedItem);
    }

    public final void render(@Nullable CheckedVersion version, @Nullable ItemT selectedItem, @NotNull ColoredTextContainer text, boolean showRawVersion) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"SimpleTextAttributes.ERROR_ATTRIBUTES");
        SimpleTextAttributes errorAttributes = CPPToolchainsUIUtils.access$smallerTextAttributes(simpleTextAttributes);
        SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"SimpleTextAttributes.REGULAR_ATTRIBUTES");
        SimpleTextAttributes regularAttributes = CPPToolchainsUIUtils.access$smallerTextAttributes(simpleTextAttributes2);
        SimpleTextAttributes grayedAttributes = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
        text.setIcon(UIUtilKt.getNO_ICON());
        if (version == null) {
            text.setIcon(UIUtilKt.getERROR_ICON());
            text.append(ToolchainsBundle.message("cpp.toolchains.not.specified", new Object[0]), errorAttributes);
            return;
        }
        if (version.isDisabled()) {
            return;
        }
        String rawVersion = StringKt.nullize$default((String)version.getRawVersion(), (boolean)false, (int)1, null);
        if (version.getVersion() == null) {
            text.setIcon(UIUtilKt.getERROR_ICON());
            text.append(CPPToolchainsUIUtils.getNotFoundMessage(version.isBundled(), version.isFromToolSet()), errorAttributes);
            return;
        }
        text.setIcon((Icon)UIUtilKt.getOK_ICON());
        text.append(ToolchainsBundle.message("cpp.toolchains.version", version.getVersion()), regularAttributes);
        if (version.getWarning() != null || version.isUnknown()) {
            text.setIcon(UIUtilKt.getWARNING_ICON());
            if (version.getWarning() != null) {
                text.append("; " + version.getWarning(), regularAttributes);
            }
        }
        if (rawVersion != null) {
            if (version.getWarning() != null || version.isUnknown() || !showRawVersion) {
                text.setToolTipText(rawVersion);
            } else {
                text.append(' ' + version.getRawVersion(), grayedAttributes);
            }
        }
    }

    public static /* synthetic */ void render$default(VersionChecker versionChecker, CheckedVersion checkedVersion, Object object, ColoredTextContainer coloredTextContainer, boolean bl, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: render");
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        versionChecker.render(checkedVersion, object, coloredTextContainer, bl);
    }

    public VersionChecker(boolean requireNonEmpty) {
        this.requireNonEmpty = requireNonEmpty;
    }
}

