/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunProfile;
import com.jetbrains.cidr.execution.ConsoleOptions;
import com.jetbrains.cidr.execution.ElevationOptions;
import com.jetbrains.cidr.execution.EnvironmentFileOptions;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfiguration<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>>
extends LocatableConfigurationBase<Element>
implements CidrRunProfile,
OCRunConfigurationWithResolveConfiguration,
CommonProgramRunConfigurationParameters,
InputRedirectAware.InputRedirectOptions,
ElevationOptions,
EnvironmentFileOptions,
ConsoleOptions {
    @NonNls
    protected static final String PROJECT_NAME = "PROJECT_NAME";
    @NonNls
    protected static final String TARGET_NAME = "TARGET_NAME";
    @NonNls
    protected static final String CONFIG_NAME = "CONFIG_NAME";
    @Nullable
    private BuildTargetAndConfigurationData myTargetAndConfigurationData;
    @Nullable
    private String myProgramParameters;
    @Nullable
    private String myWorkingDirectoryUrl;
    private boolean myElevate;
    private boolean myUseExternalConsole;
    private boolean myRedirectInput;
    @Nullable
    private String myRedirectInputPath;
    @Nullable
    private String myEnvironmentFile;
    @NotNull
    private LinkedHashMap<String, String> myEnvs = new LinkedHashMap();
    private static final boolean DEFAULT_PASS_PARENT_ENVS = true;
    private boolean myPassParentEnvs = true;

    public CidrRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NlsActions.ActionText
    public String suggestedName() {
        return this.suggestNameForTarget();
    }

    @Nullable
    @Nls
    public String suggestNameForTarget() {
        return this.suggestNameForTargetAndConfigurationData(this.myTargetAndConfigurationData);
    }

    @Nullable
    @Nls
    protected String suggestNameForTargetAndConfigurationData(@Nullable BuildTargetAndConfigurationData data) {
        return data != null && data.target != null ? data.target.targetName : null;
    }

    public void setTargetAndConfigurationData(@Nullable BuildTargetAndConfigurationData data) {
        this.myTargetAndConfigurationData = data;
    }

    @Nullable
    public BuildTargetAndConfigurationData getTargetAndConfigurationData() {
        return this.myTargetAndConfigurationData;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myProgramParameters = StringUtil.isEmptyOrSpaces((String)value) ? null : value;
    }

    @Nullable
    @NlsSafe
    public String getProgramParameters() {
        return this.myProgramParameters;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.myWorkingDirectoryUrl = ExternalizablePath.urlValue((String)value);
    }

    @Nullable
    @NlsSafe
    public String getWorkingDirectory() {
        return StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectoryUrl) ? "" : FileUtilRt.toSystemIndependentName((String)VirtualFileManager.extractPath((String)this.myWorkingDirectoryUrl.trim()));
    }

    @Override
    public boolean isElevated() {
        return this.myElevate;
    }

    @Override
    public void setElevated(boolean value) {
        this.myElevate = value;
    }

    @Override
    public boolean isUseExternalConsole() {
        return this.myUseExternalConsole;
    }

    @Override
    public void setUseExternalConsole(boolean value) {
        this.myUseExternalConsole = value;
    }

    public boolean isRedirectInput() {
        return this.myRedirectInput;
    }

    public void setRedirectInput(boolean value) {
        this.myRedirectInput = value;
    }

    @Nullable
    public String getRedirectInputPath() {
        return this.myRedirectInputPath;
    }

    public void setRedirectInputPath(@Nullable String value) {
        this.myRedirectInputPath = value;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            CidrRunConfiguration.$$$reportNull$$$0(0);
        }
        this.myEnvs = new LinkedHashMap<String, String>(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        LinkedHashMap<String, String> linkedHashMap = this.myEnvs;
        if (linkedHashMap == null) {
            CidrRunConfiguration.$$$reportNull$$$0(1);
        }
        return linkedHashMap;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    @Override
    public void setEnvironmentFile(@Nullable String file) {
        this.myEnvironmentFile = file;
    }

    @Override
    @Nullable
    public String getEnvironmentFile() {
        return this.myEnvironmentFile;
    }

    @NotNull
    protected BuildTargetAndConfigurationData createBuildTargetAndConfigurationData(@Nullable String projectName, @Nullable String targetName, @Nullable String configName) {
        return new BuildTargetAndConfigurationData(projectName, targetName, configName);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            CidrRunConfiguration.$$$reportNull$$$0(2);
        }
        super.readExternal(element);
        this.myProgramParameters = element.getAttributeValue("PROGRAM_PARAMS");
        this.myWorkingDirectoryUrl = element.getAttributeValue("WORKING_DIR");
        this.myRedirectInput = CidrRunConfiguration.getBoolean(element.getAttributeValue("REDIRECT_INPUT"), false);
        this.myRedirectInputPath = element.getAttributeValue("REDIRECT_INPUT_PATH");
        this.myElevate = CidrRunConfiguration.getBoolean(element.getAttributeValue("ELEVATE"), false);
        this.myUseExternalConsole = CidrRunConfiguration.getBoolean(element.getAttributeValue("USE_EXTERNAL_CONSOLE"), false);
        this.myEnvs = CidrRunConfiguration.createEnvMap();
        EnvironmentVariablesComponent.readExternal((Element)element, this.myEnvs);
        this.myPassParentEnvs = CidrRunConfiguration.getBoolean(element.getAttributeValue("PASS_PARENT_ENVS_2"), true);
        this.myEnvironmentFile = element.getAttributeValue("ENVFILE");
        String projectName = element.getAttributeValue(PROJECT_NAME);
        String targetName = element.getAttributeValue(TARGET_NAME);
        String configName = element.getAttributeValue(CONFIG_NAME);
        this.setTargetAndConfigurationData(this.createBuildTargetAndConfigurationData(projectName, targetName, configName));
    }

    @NotNull
    private static LinkedHashMap<String, String> createEnvMap() {
        return new LinkedHashMap<String, String>();
    }

    @NotNull
    private static Boolean getBoolean(@Nullable String reload, boolean def) {
        Boolean bl = StringUtil.isEmptyOrSpaces((String)reload) ? def : Boolean.valueOf(reload);
        if (bl == null) {
            CidrRunConfiguration.$$$reportNull$$$0(3);
        }
        return bl;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            CidrRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        if (!StringUtil.isEmptyOrSpaces((String)this.myProgramParameters)) {
            element.setAttribute("PROGRAM_PARAMS", this.myProgramParameters);
        }
        element.setAttribute("REDIRECT_INPUT", String.valueOf(this.myRedirectInput));
        if (!StringUtil.isEmptyOrSpaces((String)this.myRedirectInputPath)) {
            element.setAttribute("REDIRECT_INPUT_PATH", this.myRedirectInputPath);
        }
        element.setAttribute("ELEVATE", String.valueOf(this.myElevate));
        element.setAttribute("USE_EXTERNAL_CONSOLE", String.valueOf(this.myUseExternalConsole));
        if (!StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectoryUrl)) {
            element.setAttribute("WORKING_DIR", this.myWorkingDirectoryUrl);
        }
        EnvironmentVariablesComponent.writeExternal((Element)element, this.myEnvs);
        element.setAttribute("PASS_PARENT_ENVS_2", String.valueOf(this.myPassParentEnvs));
        if (this.myEnvironmentFile != null) {
            element.setAttribute("ENVFILE", this.myEnvironmentFile);
        }
        if (this.myTargetAndConfigurationData != null) {
            BuildTargetData targetData = this.myTargetAndConfigurationData.target;
            if (targetData != null) {
                element.setAttribute(PROJECT_NAME, targetData.projectName);
                element.setAttribute(TARGET_NAME, targetData.targetName);
            }
            CidrRunConfiguration.writeStringAttribute(element, CONFIG_NAME, this.myTargetAndConfigurationData.configurationName);
        }
    }

    protected static void writeStringAttribute(@NotNull Element element, @NotNull String attributeName, @Nullable String attributeValue) {
        if (element == null) {
            CidrRunConfiguration.$$$reportNull$$$0(5);
        }
        if (attributeName == null) {
            CidrRunConfiguration.$$$reportNull$$$0(6);
        }
        if (attributeValue != null) {
            element.setAttribute(attributeName, attributeValue);
        }
    }

    public RunConfiguration clone() {
        CidrRunConfiguration result = (CidrRunConfiguration)super.clone();
        result.myProgramParameters = this.myProgramParameters;
        result.myWorkingDirectoryUrl = this.myWorkingDirectoryUrl;
        result.myRedirectInput = this.myRedirectInput;
        result.myRedirectInputPath = this.myRedirectInputPath;
        result.myElevate = this.myElevate;
        result.myUseExternalConsole = this.myUseExternalConsole;
        result.myEnvs = new LinkedHashMap<String, String>(this.myEnvs);
        result.myPassParentEnvs = this.myPassParentEnvs;
        result.myTargetAndConfigurationData = this.myTargetAndConfigurationData;
        result.myEnvironmentFile = this.myEnvironmentFile;
        return result;
    }

    public void onNewConfigurationCreated() {
        CidrBuildConfigurationHelper<BC, CidrBuildTarget> helper = this.getHelper();
        CidrBuildTarget target = null;
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        if (data != null && data.target != null) {
            target = (CidrBuildTarget)helper.findRunTarget(data.target);
        }
        if (target == null) {
            target = (CidrBuildTarget)helper.getDefaultTarget();
            data = null;
        }
        String configurationName = null;
        if (data != null && data.configurationName != null) {
            configurationName = data.configurationName;
        } else {
            BC config = helper.getDefaultConfiguration(target);
            if (config != null) {
                configurationName = config.getName();
            }
        }
        this.setTargetAndConfigurationData(new BuildTargetAndConfigurationData(target == null ? null : target.getProjectName(), target == null ? null : target.getName(), configurationName));
    }

    @NotNull
    public abstract CidrBuildConfigurationHelper<BC, TARGET> getHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrRunConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoolean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeStringAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

