/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.OCTestExecution;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class CidrTestExecutionUtil {
    @NotNull
    public static String getAsPatternForCommandLine(@NotNull Project project, @NotNull Function<PsiFile, Collection<? extends CidrTestScopeElement>> getFileElements, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull Supplier<Boolean> areSymbolsLoaded, @NotNull CidrTestScope testScope, @NotNull ProgressIndicator progress) {
        String pattern;
        if (project == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(0);
        }
        if (getFileElements == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(1);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(2);
        }
        if (areSymbolsLoaded == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(3);
        }
        if (testScope == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(5);
        }
        if (!(pattern = testScope.getAsPattern()).contains("all-tests(")) {
            String string = pattern;
            if (string == null) {
                CidrTestExecutionUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        CidrTestLog.LOG.assertTrue(OCTestExecution.canWaitInThisThread());
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        CidrTestScope finalFileScope = emptyTestScopeProducer.get();
        block2: for (String _pattern : testScope.getAsPatternList()) {
            if (!(_pattern = _pattern.trim()).startsWith("all-tests(") || !_pattern.endsWith(")")) continue;
            String fileId = _pattern.substring("all-tests(".length(), _pattern.length() - ")".length());
            VirtualFile vfile = virtualFileManager.findFileByUrl(fileId);
            if (vfile == null) {
                progress.setText2(CidrExecutionBundle.message("test.file.not.found.in.fs", fileId));
                continue;
            }
            boolean first = true;
            while (!progress.isCanceled()) {
                if (!areSymbolsLoaded.get().booleanValue()) {
                    if (first) {
                        first = false;
                        progress.setText2(CidrExecutionBundle.message("test.waiting.for.symbols", new Object[0]));
                    }
                } else if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    PsiFile pfile = psiManager.findFile(vfile);
                    if (pfile == null) {
                        progress.setText2(CidrExecutionBundle.message("test.file.not.found.in.project", fileId));
                        return;
                    }
                    progress.setText2(CidrExecutionBundle.message("test.processing.file", vfile.getPath()));
                    finalFileScope.addPattern(CidrTestExecutionUtil.createFilePatternAsTestList((Collection)getFileElements.fun((Object)pfile), emptyTestScopeProducer, CidrTestScopeElement::isTest));
                }, (ProgressIndicator)new SensitiveProgressWrapper(progress))) continue block2;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (!progress.isCanceled()) {
            String finalFileScopeAsPattern = finalFileScope.getAsPattern();
            progress.setText2(CidrExecutionBundle.message("test.pattern.to.run", finalFileScopeAsPattern));
            String string = finalFileScopeAsPattern;
            if (string == null) {
                CidrTestExecutionUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String createFilePatternAsTestList(@NotNull Collection<? extends CidrTestScopeElement> fileElements, @NotNull Supplier<? extends CidrTestScope> emptyTestScopeProducer, @NotNull Predicate<CidrTestScopeElement> filter2) {
        if (fileElements == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(8);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(9);
        }
        if (filter2 == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(10);
        }
        CidrTestScope fileScope = emptyTestScopeProducer.get();
        for (CidrTestScopeElement cidrTestScopeElement : fileElements) {
            if (!filter2.test(cidrTestScopeElement)) continue;
            fileScope.addScopeElement(cidrTestScopeElement);
        }
        String string = fileScope.getAsPattern();
        if (string == null) {
            CidrTestExecutionUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getFileElements";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyTestScopeProducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areSymbolsLoaded";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileElements";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestExecutionUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsPatternForCommandLine";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilePatternAsTestList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAsPatternForCommandLine";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFilePatternAsTestList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

