/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CidrTestScope {
    @NonNls
    public static final String ALL_IN_FILE_PREFIX = "all-tests(";
    @NonNls
    public static final String ALL_IN_FILE_SUF = ")";
    private final String mySeparator;
    private List<CidrTestScopeElement> myElements;
    private String myPreRenderedScope;

    protected CidrTestScope(@NotNull String separator) {
        if (separator == null) {
            CidrTestScope.$$$reportNull$$$0(0);
        }
        this.mySeparator = separator;
    }

    @NotNull
    public List<CidrTestScopeElement> getElements() {
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        List<CidrTestScopeElement> list = this.myElements.stream().sorted().distinct().collect(Collectors.toUnmodifiableList());
        if (list == null) {
            CidrTestScope.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static CidrTestScope createEmptyTestScope(@NotNull String separator) {
        if (separator == null) {
            CidrTestScope.$$$reportNull$$$0(2);
        }
        return new CidrTestScope(separator);
    }

    @NotNull
    public CidrTestScope configureForPreRenderedScope(@NotNull String switches) {
        if (switches == null) {
            CidrTestScope.$$$reportNull$$$0(3);
        }
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null && (this.myElements == null || this.myElements.isEmpty()));
        this.myPreRenderedScope = switches;
        CidrTestScope cidrTestScope = this;
        if (cidrTestScope == null) {
            CidrTestScope.$$$reportNull$$$0(4);
        }
        return cidrTestScope;
    }

    @NotNull
    public CidrTestScope addScopeElement(@NotNull CidrTestScopeElement element) {
        if (element == null) {
            CidrTestScope.$$$reportNull$$$0(5);
        }
        CidrTestLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        this.myElements.add(element);
        CidrTestScope cidrTestScope = this;
        if (cidrTestScope == null) {
            CidrTestScope.$$$reportNull$$$0(6);
        }
        return cidrTestScope;
    }

    @NotNull
    public CidrTestScope addPattern(@NotNull String pattern) {
        if (pattern == null) {
            CidrTestScope.$$$reportNull$$$0(7);
        }
        CidrTestLog.LOG.assertTrue(this.myElements == null || this.myElements.isEmpty());
        this.myPreRenderedScope = this.myPreRenderedScope == null ? pattern : this.myPreRenderedScope + this.mySeparator + pattern;
        CidrTestScope cidrTestScope = this;
        if (cidrTestScope == null) {
            CidrTestScope.$$$reportNull$$$0(8);
        }
        return cidrTestScope;
    }

    @NotNull
    public String toString() {
        String string = this.getAsPattern();
        if (string == null) {
            CidrTestScope.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getAsPattern() {
        String string = this.myPreRenderedScope != null ? this.myPreRenderedScope : StringUtil.join(this.getAsPatternList(), (String)this.mySeparator);
        if (string == null) {
            CidrTestScope.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<String> getAsPatternList() {
        if (this.myPreRenderedScope != null) {
            if (this.myPreRenderedScope.contains(ALL_IN_FILE_PREFIX)) {
                ArrayList<String> split = new ArrayList<String>();
                int pos = 0;
                while (pos < this.myPreRenderedScope.length()) {
                    int spos;
                    String prefix = "";
                    if (StringUtil.startsWith((CharSequence)this.myPreRenderedScope, (int)pos, (CharSequence)ALL_IN_FILE_PREFIX)) {
                        int end = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)ALL_IN_FILE_SUF, (int)pos);
                        int npos = end + ALL_IN_FILE_SUF.length();
                        prefix = this.myPreRenderedScope.substring(pos, npos);
                        pos = npos;
                    }
                    if ((spos = StringUtil.indexOf((CharSequence)this.myPreRenderedScope, (CharSequence)this.mySeparator, (int)pos)) < 0) {
                        split.add(prefix + this.myPreRenderedScope.substring(pos));
                        break;
                    }
                    split.add(prefix + this.myPreRenderedScope.substring(pos, spos));
                    pos = spos + this.mySeparator.length();
                }
                ArrayList<String> arrayList = split;
                if (arrayList == null) {
                    CidrTestScope.$$$reportNull$$$0(11);
                }
                return arrayList;
            }
            List list = StringUtil.split((String)this.myPreRenderedScope, (String)this.mySeparator);
            if (list == null) {
                CidrTestScope.$$$reportNull$$$0(12);
            }
            return list;
        }
        this.createElementCollectionIfNull();
        List<String> list = this.myElements.stream().sorted(Comparator.comparingLong(CidrTestScopeElement::getSortIndex)).distinct().map(CidrTestScopeElement::getPattern).collect(Collectors.toList());
        if (list == null) {
            CidrTestScope.$$$reportNull$$$0(13);
        }
        return list;
    }

    private void createElementCollectionIfNull() {
        if (this.myElements == null) {
            this.myElements = new ArrayList<CidrTestScopeElement>();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "configureForPreRenderedScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addScopeElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addPattern";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsPattern";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsPatternList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTestScope";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureForPreRenderedScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

