/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardUtil {
    public static final String DEFAULT_HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${FILE_NAME}_${EXT}";
    private static final Logger LOG = Logger.getInstance(OCHeaderGuardUtil.class);

    public static boolean headerGuardMatchesPattern(@NotNull String headerGuardToMatch, @NotNull String headerGuardStylePattern, @NotNull String filePath, @NotNull Project project) {
        if (headerGuardToMatch == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(0);
        }
        if (headerGuardStylePattern == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(3);
        }
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project);
        String uuid = StringUtil.toUpperCase((String)builtinProperties.getProperty("UUID"));
        String builtHeaderGuardName = OCHeaderGuardUtil.doBuildHeaderGuardName(headerGuardStylePattern, builtinProperties, project);
        Pattern headerGuardPattern = OCHeaderGuardUtil.buildHeaderGuardRegexPattern(builtHeaderGuardName, ContainerUtil.newHashMap((Pair)Pair.create((Object)uuid, (Object)"[A-F0-9]{32}"), (Pair[])new Pair[0]));
        return headerGuardPattern.matcher(headerGuardToMatch).matches();
    }

    @NotNull
    public static String buildDefaultHeaderGuardName(@NotNull String filePath, @NotNull String projectName) {
        String rawHeaderGuardName;
        String headerGuard;
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(4);
        }
        if (projectName == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(5);
        }
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuard = StringUtil.toUpperCase((String)(rawHeaderGuardName = StringUtil.join((Collection)ContainerUtil.newArrayList((Object[])new String[]{projectName, OCHeaderGuardUtil.getFileName(filePath), OCHeaderGuardUtil.getExtension(filePath)}), (String)"_"))))) {
            String string = "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
            if (string == null) {
                OCHeaderGuardUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        Object object = Character.isJavaIdentifierStart(headerGuard.charAt(0)) ? headerGuard : "INC_" + headerGuard;
        if (object == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(7);
        }
        return object;
    }

    @NotNull
    public static String buildHeaderGuardName(@NotNull String headerGuardStylePattern, @NotNull String filePath, @NotNull Project project) {
        if (headerGuardStylePattern == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(8);
        }
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(10);
        }
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project);
        return OCHeaderGuardUtil.doBuildHeaderGuardName(headerGuardStylePattern, builtinProperties, project);
    }

    @NotNull
    private static String doBuildHeaderGuardName(@NotNull String headerGuardStylePattern, @NotNull Properties builtinProperties, @NotNull Project project) {
        if (headerGuardStylePattern == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(11);
        }
        if (builtinProperties == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(13);
        }
        OCHeaderGuardUtil.convertPropertiesToMacroParts(builtinProperties);
        OCHeaderGuardUtil.setDefaultValuesForDummyProperties(headerGuardStylePattern, builtinProperties, project);
        String rawHeaderGuardName = FileTemplateUtil.mergeTemplate((Properties)builtinProperties, (String)headerGuardStylePattern, (boolean)true, null);
        String headerGuardName = rawHeaderGuardName.trim();
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuardName)) {
            String string = "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
            if (string == null) {
                OCHeaderGuardUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        Object object = Character.isJavaIdentifierStart(headerGuardName.charAt(0)) ? headerGuardName : "INC_" + headerGuardName;
        if (object == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(15);
        }
        return object;
    }

    @NotNull
    private static Properties getBuiltinProperties(@NotNull String filePath, @NotNull Project project) {
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(17);
        }
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project).getDefaultProperties());
        properties.setProperty("FILE_NAME", OCHeaderGuardUtil.getFileName(filePath));
        properties.setProperty("EXT", OCHeaderGuardUtil.getExtension(filePath));
        properties.setProperty("PROJECT_REL_PATH", OCHeaderGuardUtil.getProjectRelativePath(filePath, project.getBasePath()));
        properties.setProperty("UUID", OCHeaderGuardUtil.getRandomUUID());
        Properties properties2 = properties;
        if (properties2 == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(18);
        }
        return properties2;
    }

    @NotNull
    private static String getRandomUUID() {
        String string = UUID.randomUUID().toString().replace("-", "");
        if (string == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void convertPropertiesToMacroParts(@NotNull Properties properties) {
        if (properties == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(20);
        }
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            properties.setProperty(propertyName, OCHeaderGuardUtil.toMacroPart(properties.getProperty(propertyName)));
        }
    }

    private static void setDefaultValuesForDummyProperties(@NotNull String templatePattern, @NotNull Properties properties, @NotNull Project project) {
        if (templatePattern == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(21);
        }
        if (properties == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(22);
        }
        if (project == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(23);
        }
        try {
            String[] unsetAttributes;
            for (String unsetAttribute : unsetAttributes = FileTemplateUtil.calculateAttributes((String)templatePattern, (Properties)properties, (boolean)true, (Project)project)) {
                properties.setProperty(unsetAttribute, "");
            }
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse header guard template pattern: " + e);
        }
    }

    private static boolean headerGuardIsCorrect(@NotNull String headerGuardName) {
        String trimmedHeaderGuard;
        if (headerGuardName == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(24);
        }
        return !(trimmedHeaderGuard = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)headerGuardName, (char)'_'), (char)'_')).isEmpty() && trimmedHeaderGuard.chars().allMatch(c -> c == 95 || c == 36 || Character.isLetterOrDigit(c));
    }

    @NotNull
    private static String toMacroPart(@NotNull String str) {
        if (str == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(25);
        }
        String string = StringUtil.toUpperCase((String)StringUtil.join((Collection)StringUtil.getWordsIn((String)str), (String)"_"));
        if (string == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getProjectRelativePath(@Nullable String filePath, @Nullable String projectPath) {
        if (StringUtil.isEmpty((String)filePath) || StringUtil.isEmpty((String)projectPath)) {
            return "";
        }
        String relativePath = FileUtil.getRelativePath((String)PathUtil.toSystemDependentName((String)projectPath), (String)PathUtil.toSystemDependentName((String)filePath), (char)File.separatorChar);
        return StringUtil.isNotEmpty((String)relativePath) ? PathUtil.getParentPath((String)relativePath) : "";
    }

    @NotNull
    private static String getFileName(@NotNull String filePath) {
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(27);
        }
        String string = FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)filePath));
        if (string == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String getExtension(@NotNull String filePath) {
        if (filePath == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(29);
        }
        String string = StringUtil.notNullize((String)PathUtil.getFileExtension((String)filePath));
        if (string == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static Pattern buildHeaderGuardRegexPattern(@NotNull String headerGuard, @NotNull Map<String, String> replacements) {
        if (headerGuard == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(31);
        }
        if (replacements == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(32);
        }
        String escapedHeaderGuard = StringUtil.replace((String)headerGuard, (String)"$", (String)"\\$");
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            escapedHeaderGuard = StringUtil.replace((String)escapedHeaderGuard, (String)replacement.getKey(), (String)replacement.getValue());
        }
        Pattern pattern = Pattern.compile(escapedHeaderGuard, 32);
        if (pattern == null) {
            OCHeaderGuardUtil.$$$reportNull$$$0(33);
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerGuardToMatch";
                break;
            }
            case 1: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerGuardStylePattern";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: 
            case 10: 
            case 13: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/util/OCHeaderGuardUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtinProperties";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatePattern";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerGuardName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerGuard";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/util/OCHeaderGuardUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDefaultHeaderGuardName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildHeaderGuardName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinProperties";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRandomUUID";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "toMacroPart";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHeaderGuardRegexPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "headerGuardMatchesPattern";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildDefaultHeaderGuardName";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildHeaderGuardName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doBuildHeaderGuardName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinProperties";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertPropertiesToMacroParts";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValuesForDummyProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "headerGuardIsCorrect";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "toMacroPart";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildHeaderGuardRegexPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

