/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class IncludedFilesProcessor {
    public static boolean processFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (project == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        if (IncludedFilesProcessor.shouldSkip(file, processor)) {
            return true;
        }
        return IncludedFilesProcessor.processFileImpl(project, file, processor);
    }

    private static boolean processFileImpl(@NotNull Project project, @NotNull VirtualFile file, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (project == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(5);
        }
        if (processor instanceof HeadersSearchRootProcessor) {
            return ((HeadersSearchRootProcessor)processor).process(file);
        }
        if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(file.getName(), file.isDirectory())) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Object element = null;
        if (file.isValid()) {
            element = file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
        }
        return element == null || processor.execute(element);
    }

    public static boolean shouldSkip(@NotNull VirtualFile file, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (file == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(7);
        }
        return AppleFramework.isFrameworkRoot(file) || processor instanceof HeadersSearchRootProcessor && ((HeadersSearchRootProcessor)processor).shouldSkip(file);
    }

    public static boolean processFiles(final @NotNull Project project, @NotNull Iterable<VirtualFile> files, boolean recursive, final @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (project == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(8);
        }
        if (files == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(10);
        }
        for (VirtualFile each : IncludedFilesProcessor.iterateFilesFirst(files)) {
            if (recursive && each.isDirectory()) {
                class CancelException
                extends RuntimeException
                implements ControlFlowException {
                    CancelException() {
                        super(null, null, true, false);
                    }
                }
                try {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)each, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            ProgressManager.checkCanceled();
                            if (IncludedFilesProcessor.shouldSkip(file, (PsiElementProcessor<? super PsiFileSystemItem>)processor)) {
                                VirtualFileVisitor.Result result = SKIP_CHILDREN;
                                if (result == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                return result;
                            }
                            if (!IncludedFilesProcessor.processFileImpl(project, file, (PsiElementProcessor<? super PsiFileSystemItem>)processor)) {
                                throw new CancelException();
                            }
                            VirtualFileVisitor.Result result = CONTINUE;
                            if (result == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return result;
                        }

                        @NotNull
                        public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                            if (file == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            Iterable<VirtualFile> iterable = IncludedFilesProcessor.iterateFilesFirst(Arrays.asList(file.getChildren()));
                            if (iterable == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return iterable;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "file";
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor$1";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "visitFileEx";
                                    break;
                                }
                                case 4: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getChildrenIterable";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "visitFileEx";
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: {
                                    break;
                                }
                                case 3: {
                                    objectArray = objectArray;
                                    objectArray[2] = "getChildrenIterable";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 4: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                    continue;
                }
                catch (CancelException ignore) {
                    return false;
                }
            }
            if (IncludedFilesProcessor.processFile(project, each, processor)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Iterable<VirtualFile> iterateFilesFirst(final @NotNull Iterable<VirtualFile> files) {
        if (files == null) {
            IncludedFilesProcessor.$$$reportNull$$$0(11);
        }
        return new Iterable<VirtualFile>(){

            @Override
            public Iterator<VirtualFile> iterator() {
                return new Iterator<VirtualFile>(){
                    Iterator<VirtualFile> iterator = null;
                    List<VirtualFile> dirs = null;
                    boolean processingDirs = false;
                    VirtualFile prefetched = null;

                    @Override
                    public boolean hasNext() {
                        this.prefetchNext();
                        return this.prefetched != null;
                    }

                    @Override
                    public VirtualFile next() {
                        if (this.prefetched == null) {
                            this.prefetchNext();
                        }
                        if (this.prefetched == null) {
                            throw new NoSuchElementException("No more items");
                        }
                        VirtualFile result = this.prefetched;
                        this.prefetched = null;
                        return result;
                    }

                    private void prefetchNext() {
                        if (this.prefetched != null) {
                            return;
                        }
                        if (this.iterator == null) {
                            this.iterator = files.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            VirtualFile next = this.iterator.next();
                            boolean isDir = next.isDirectory();
                            if (isDir == this.processingDirs) {
                                this.prefetched = next;
                                return;
                            }
                            if (this.processingDirs) continue;
                            if (this.dirs == null) {
                                this.dirs = new SmartList();
                            }
                            this.dirs.add(next);
                        }
                        if (this.prefetched == null && !this.processingDirs && this.dirs != null) {
                            this.processingDirs = true;
                            this.iterator = this.dirs.iterator();
                            this.prefetchNext();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/workspace/headerRoots/IncludedFilesProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processFileImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSkip";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "iterateFilesFirst";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

