/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.project.CidrChangeProjectContentRootAction;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrWorkspace {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrWorkspace.class.getPackage().getName()));
    @Nullable
    protected static BalloonNotifier ourBalloonNotifier;
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile Path myProjectDir;
    @Nullable
    protected volatile File myContentRoot;
    private volatile boolean myBaseStateInitialized;
    private volatile boolean isInitialized;
    private volatile Set<File> myFilesOutsideRootsToReport;
    private volatile boolean myIgnoreFilesOutsideOfProjectRoot;
    protected final Disposable myBusConnectionDisposable;

    @NotNull
    public static List<CidrWorkspace> getInitializedWorkspaces(@NotNull Project project) {
        if (project == null) {
            CidrWorkspace.$$$reportNull$$$0(0);
        }
        ImmutableList immutableList = ContainerUtil.immutableList(CidrWorkspaceManager.getInstance(project).getInitializedWorkspaces());
        if (immutableList == null) {
            CidrWorkspace.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @NotNull
    public static List<CidrWorkspace> getWorkspaces(@NotNull Project project) {
        if (project == null) {
            CidrWorkspace.$$$reportNull$$$0(2);
        }
        List<CidrWorkspace> list = CidrWorkspaceProvider.EP_NAME.getExtensionList().stream().map(provider -> provider.getWorkspace(project)).filter(workspace -> workspace != null).collect(Collectors.toList());
        if (list == null) {
            CidrWorkspace.$$$reportNull$$$0(3);
        }
        return list;
    }

    protected CidrWorkspace(@NotNull Project project) {
        if (project == null) {
            CidrWorkspace.$$$reportNull$$$0(4);
        }
        this.myBaseStateInitialized = false;
        this.isInitialized = false;
        this.myBusConnectionDisposable = Disposer.newDisposable();
        this.myProject = project;
    }

    protected boolean shouldLoadWorkspaceForProject() {
        return !this.myProject.isDefault() && !ProjectManagerImpl.isLight((Project)this.myProject);
    }

    public final boolean isLinked() {
        return this.myProjectDir != null;
    }

    public final boolean wasLinkedBefore() {
        return this.isLinked() || this.myContentRoot != null;
    }

    protected final void linkWithProject(@Nullable Path projectDir) {
        this.myProjectDir = projectDir;
    }

    protected final void unlink() {
        this.myProjectDir = null;
    }

    protected final void linkWithProject(@Nullable Path projectDir, boolean preserveContentRoot) {
        if (preserveContentRoot) {
            this.preserveContentRootIfNecessary(projectDir);
        }
        this.linkWithProject(projectDir);
    }

    private void preserveContentRootIfNecessary(@Nullable Path newProjectDir) {
        Path projectDir = this.myProjectDir;
        if (projectDir == null && newProjectDir == null || projectDir != null && this.myContentRoot != null) {
            return;
        }
        this.setContentRoot(newProjectDir, this.getProjectPath().toFile());
    }

    protected final void setContentRoot(@Nullable File newContentRoot) {
        this.setContentRoot(this.myProjectDir, newContentRoot);
    }

    protected final void setContentRoot(@Nullable Path projectDir, @Nullable File newContentRoot) {
        this.myContentRoot = newContentRoot != null && (projectDir == null || !FileUtil.pathsEqual((String)projectDir.toString(), (String)newContentRoot.getPath())) ? newContentRoot : null;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    protected abstract OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File var1);

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CidrWorkspace.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public Path getProjectSubDir(@NotNull Path subdir) {
        if (subdir == null) {
            CidrWorkspace.$$$reportNull$$$0(6);
        }
        if (subdir.isAbsolute()) {
            Path path = subdir;
            if (path == null) {
                CidrWorkspace.$$$reportNull$$$0(7);
            }
            return path;
        }
        Path path = this.getProjectPath().resolve(subdir).toAbsolutePath();
        if (path == null) {
            CidrWorkspace.$$$reportNull$$$0(8);
        }
        return path;
    }

    @Deprecated
    @NotNull
    public File getProjectDir() {
        File file = this.getProjectPath().toFile();
        if (file == null) {
            CidrWorkspace.$$$reportNull$$$0(9);
        }
        return file;
    }

    @Nullable
    protected final Path getProjectPathOrNull() {
        return this.myProjectDir;
    }

    @NotNull
    private Path getFallbackProjectPath() {
        String basePath = this.myProject.getBasePath();
        if (basePath == null) {
            throw new NullPointerException("Project base path is null. default = " + this.myProject.isDefault());
        }
        Path path = Paths.get(basePath, new String[0]);
        if (path == null) {
            CidrWorkspace.$$$reportNull$$$0(10);
        }
        return path;
    }

    @NotNull
    public Path getProjectPath() {
        Path projectDir = this.getProjectPathOrNull();
        Path path = (projectDir != null ? projectDir : this.getFallbackProjectPath()).toAbsolutePath();
        if (path == null) {
            CidrWorkspace.$$$reportNull$$$0(11);
        }
        return path;
    }

    protected boolean initializeAndStart() {
        return this.markInitialized();
    }

    public boolean load(boolean projectOpening) {
        return this.shouldLoadWorkspaceForProject() && this.isLinked() && this.initializeAndStart();
    }

    public boolean unload(boolean projectClosing) {
        return this.markUninitialized();
    }

    private synchronized boolean markInitialized() {
        this.isInitialized = true;
        return CidrWorkspaceManager.getInstance(this.myProject).markInitialized(this);
    }

    private synchronized boolean markUninitialized() {
        this.isInitialized = false;
        return CidrWorkspaceManager.getInstance(this.myProject).markUninitialized(this);
    }

    public final List<String> collectExcludeUrls() {
        return ContainerUtil.map(this.collectExcludeRoots(this.myContentRoot, true), file -> VfsUtilCore.pathToUrl((String)file.getPath()));
    }

    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot, boolean includePotentialNotYetExistingExcludes) {
        List<File> list = Collections.emptyList();
        if (list == null) {
            CidrWorkspace.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        if (contentRoot != null && this.isLinked()) {
            this.setContentRoot(contentRoot);
            return this.myContentRoot;
        }
        return contentRoot;
    }

    protected void afterUpdateContentRoots(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        Set<File> outsideFiles;
        if (rootsInfo == null) {
            CidrWorkspace.$$$reportNull$$$0(13);
        }
        if ((outsideFiles = this.collectFilesOutsideContentRoots(rootsInfo)).isEmpty()) {
            this.myIgnoreFilesOutsideOfProjectRoot = false;
        }
        this.myFilesOutsideRootsToReport = outsideFiles;
    }

    protected boolean shouldEnableRootConfiguration() {
        return this.isLinked();
    }

    public final void updateContentRoots() {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this);
    }

    protected final void updateContentRoots(boolean forceRootChangesEvents) {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this, forceRootChangesEvents);
    }

    protected final void updateContentRoots(@Nullable File contentRoot) {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this, contentRoot);
    }

    protected Set<File> collectFilesOutsideContentRoots(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        if (rootsInfo == null) {
            CidrWorkspace.$$$reportNull$$$0(14);
        }
        return OCRootsSynchronizer.collectFilesNotUnder(rootsInfo.contentRoots, rootsInfo.sourceFiles);
    }

    protected void reportFilesOutsideContentRoot(@Nls @NotNull String message, @Nullable @NonNls String toolWindowId) {
        if (message == null) {
            CidrWorkspace.$$$reportNull$$$0(15);
        }
        if (!this.myFilesOutsideRootsToReport.isEmpty() && !this.myIgnoreFilesOutsideOfProjectRoot) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            LOG.info("The following files are located outside of the project: \n\t\t" + StringUtil.join(this.myFilesOutsideRootsToReport, (String)"\n\t\t"));
            this.myFilesOutsideRootsToReport = Collections.emptySet();
            HyperlinkAdapter listener = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if ("change".equals(e.getDescription())) {
                        CidrChangeProjectContentRootAction.perform(CidrWorkspace.this.myProject, CidrWorkspace.this);
                    } else if ("ignore".equals(e.getDescription())) {
                        CidrWorkspace.this.myIgnoreFilesOutsideOfProjectRoot = true;
                    }
                }
            };
            if (ourBalloonNotifier != null) {
                ourBalloonNotifier.notify(MessageType.WARNING, message, (HyperlinkListener)listener);
            } else if (toolWindowId != null) {
                ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon(toolWindowId, MessageType.WARNING, message, null, (HyperlinkListener)listener);
            } else {
                @NonNls String id = "Workspace";
                NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)"Workspace");
                if (notificationGroup == null) {
                    notificationGroup = NotificationGroup.balloonGroup((String)"Workspace");
                }
                notificationGroup.createNotification(message, NotificationType.WARNING).setListener((notification, event) -> {
                    listener.hyperlinkUpdate(event);
                    notification.expire();
                }).notify(this.myProject);
            }
        }
    }

    public void changeContentRoot(@Nullable VirtualFile contentRoot) {
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        this.updateContentRoots(contentRoot == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot));
    }

    public static OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<OCResolveConfiguration> resolveConfigurations, @NotNull List<File> roots, @NotNull List<File> additionalSourceFiles, @NotNull List<File> generatedSourceFiles) {
        if (resolveConfigurations == null) {
            CidrWorkspace.$$$reportNull$$$0(16);
        }
        if (roots == null) {
            CidrWorkspace.$$$reportNull$$$0(17);
        }
        if (additionalSourceFiles == null) {
            CidrWorkspace.$$$reportNull$$$0(18);
        }
        if (generatedSourceFiles == null) {
            CidrWorkspace.$$$reportNull$$$0(19);
        }
        OCRootsSynchronizer.RootsInfo info = new OCRootsSynchronizer.RootsInfo();
        info.contentRoots.addAll(roots);
        for (OCResolveConfiguration it : resolveConfigurations) {
            for (String sourceUrl : it.getSourceUrls()) {
                info.sourceFiles.add(new File(VfsUtilCore.urlToPath((String)sourceUrl)));
            }
            it.getAllCompilerSettings().forEach(settings -> info.headersSearchRoots.addAll(settings.getHeadersSearchRoots().getAllRoots()));
        }
        info.sourceFiles.addAll(additionalSourceFiles);
        info.generatedSourceFiles.addAll(generatedSourceFiles);
        return info;
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        File root = this.myContentRoot;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @Nullable
    public Module getModule() {
        return OCRootsSynchronizer.getInstance(this.myProject).getModuleIfExists();
    }

    @Nullable
    public File getContentRoot() {
        return this.myContentRoot;
    }

    @NotNull
    public State getBaseState() {
        Path projectDir = this.myProjectDir;
        return new State(projectDir == null ? null : projectDir.toFile(), this.myContentRoot, this.myIgnoreFilesOutsideOfProjectRoot);
    }

    @NonNls
    @Nullable
    public String getClientKey() {
        return null;
    }

    public void noStateLoaded() {
        this.myBaseStateInitialized = true;
    }

    public void loadBaseState(@NotNull State state) {
        if (state == null) {
            CidrWorkspace.$$$reportNull$$$0(20);
        }
        Path projectDir = state.myProjectDir != null ? state.myProjectDir.toPath() : null;
        this.myContentRoot = state.myContentRoot;
        this.myIgnoreFilesOutsideOfProjectRoot = state.myIgnoreFilesOutsideOfProjectRoot;
        this.linkWithProject(projectDir, this.myBaseStateInitialized);
        this.myBaseStateInitialized = true;
    }

    @TestOnly
    public static void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
        ourBalloonNotifier = notifier;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/project/workspace/CidrWorkspace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdir";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsInfo";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveConfigurations";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalSourceFiles";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedSourceFiles";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/project/workspace/CidrWorkspace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedWorkspaces";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspaces";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSubDir";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDir";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFallbackProjectPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExcludeRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedWorkspaces";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWorkspaces";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSubDir";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterUpdateContentRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesOutsideContentRoots";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportFilesOutsideContentRoot";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRootsInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadBaseState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BalloonNotifier {
        public void notify(@NotNull MessageType var1, @NotNull String var2, @NotNull HyperlinkListener var3);
    }

    public static class State {
        @Nullable
        public File myProjectDir = null;
        @Nullable
        public File myContentRoot = null;
        public boolean myIgnoreFilesOutsideOfProjectRoot = false;

        public State() {
        }

        public State(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            this.myProjectDir = projectDir;
            this.myContentRoot = contentRoot;
            this.myIgnoreFilesOutsideOfProjectRoot = ignoreFilesOutsideOfProjectRoot;
        }

        @NotNull
        public Element createElement() {
            return State.createStateElement(this);
        }

        @TestOnly
        @NotNull
        public static Element createStateElement(@Nullable Path projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            return State.createStateElement(new State(projectDir != null ? projectDir.toFile() : null, contentRoot, ignoreFilesOutsideOfProjectRoot));
        }

        @NotNull
        public static Element createStateElement(@NotNull State state) {
            if (state == null) {
                State.$$$reportNull$$$0(0);
            }
            Element element = new Element("state");
            if (state.myIgnoreFilesOutsideOfProjectRoot) {
                element.setAttribute("IGNORE_OUTSIDE_FILES", "true");
            }
            if (state.myProjectDir != null) {
                element.setAttribute("PROJECT_DIR", FileUtil.toSystemIndependentName((String)state.myProjectDir.getPath()));
            }
            if (state.myContentRoot != null) {
                Element contentRootElement = new Element("contentRoot");
                contentRootElement.setAttribute("DIR", FileUtil.toSystemIndependentName((String)state.myContentRoot.getPath()));
                element.addContent(contentRootElement);
            }
            Element element2 = element;
            if (element2 == null) {
                State.$$$reportNull$$$0(1);
            }
            return element2;
        }

        @NotNull
        public static State loadStateElement(@NotNull Element element) {
            if (element == null) {
                State.$$$reportNull$$$0(2);
            }
            State state = new State();
            state.loadElement(element);
            State state2 = state;
            if (state2 == null) {
                State.$$$reportNull$$$0(3);
            }
            return state2;
        }

        public void loadElement(@NotNull Element element) {
            String projectDirString;
            if (element == null) {
                State.$$$reportNull$$$0(4);
            }
            this.myProjectDir = (projectDirString = element.getAttributeValue("PROJECT_DIR")) == null ? null : new File(projectDirString);
            Element contentRootElement = element.getChild("contentRoot");
            String contentRootDirString = contentRootElement == null ? null : contentRootElement.getAttributeValue("DIR");
            this.myContentRoot = contentRootDirString == null ? null : new File(contentRootDirString);
            this.myIgnoreFilesOutsideOfProjectRoot = Boolean.parseBoolean(element.getAttributeValue("IGNORE_OUTSIDE_FILES"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/project/workspace/CidrWorkspace$State";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/project/workspace/CidrWorkspace$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStateElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadStateElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createStateElement";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "loadStateElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "loadElement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

