/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.util.AsyncProducer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.cidr.system.EmptyPathMapper;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDeploymentHelper {
    private RemoteDeploymentHelper() {
    }

    public static boolean isRemoteDeploymentServiceAvailable() {
        return ApplicationManager.getApplication().getService(RemoteDeployment.class) != null;
    }

    public static <Comp extends JComponent> void addBrowseRemoteHostAction(@NotNull @NlsContexts.DialogTitle String title, @NotNull ComponentWithBrowseButton<Comp> pathField, @NotNull AsyncProducer<RemoteCredentials> producer) {
        if (title == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(0);
        }
        if (pathField == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(1);
        }
        if (producer == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(2);
        }
        RemoteDeploymentHelper.addBrowseRemoteHostAction(title, pathField, producer, null);
    }

    public static <Comp extends JComponent> void addBrowseRemoteHostAction(@NotNull @NlsContexts.DialogTitle String title, @NotNull ComponentWithBrowseButton<Comp> pathField, @NotNull AsyncProducer<RemoteCredentials> producer, @Nullable Consumer<String> pathConsumer) {
        RemoteDeployment remoteDeployment;
        if (title == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(3);
        }
        if (pathField == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(4);
        }
        if (producer == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(5);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            return;
        }
        TextComponentAccessor accessor2 = TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT;
        if (pathField.getChildComponent() instanceof JComboBox) {
            accessor2 = TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT;
        }
        remoteDeployment.addBrowseRemoteHostAction(title, pathField, pathField.getChildComponent(), accessor2, producer, pathConsumer);
    }

    public static boolean isDeploymentConfigAvailable(@NotNull String hostId) {
        RemoteDeployment service;
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(6);
        }
        return (service = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) != null && service.isDeploymentConfigAvailable(hostId);
    }

    @Nullable
    public static String addRemoteHost(@NotNull String hostName, @NotNull SshConfig sshConfig) {
        RemoteDeployment remoteDeployment;
        if (hostName == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(7);
        }
        if (sshConfig == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(8);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            return null;
        }
        String hostId = remoteDeployment.addRemoteHost(hostName, sshConfig);
        if (hostId == null) {
            RemoteHostUtil.LOG.warn("Cannot add new remote host: " + sshConfig.getName());
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: add remote host: " + hostId);
        }
        return hostId;
    }

    public static void migrateToDedicatedServerGroup(@NotNull List<String> hostIds) {
        RemoteDeployment remoteDeployment;
        if (hostIds == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(9);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            RemoteHostUtil.LOG.warn("Remote deployment service is not available");
            return;
        }
        remoteDeployment.migrateToDedicatedServerGroup(hostIds);
    }

    @Nullable
    public static SshConfig getSshConfig(@NotNull String hostId) {
        RemoteDeployment remoteDeployment;
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(10);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            return null;
        }
        SshConfig sshConfig = remoteDeployment.getSshConfig(hostId);
        if (sshConfig == null) {
            RemoteHostUtil.LOG.warn("Empty sshConfig for host: " + hostId);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: get sshConfig of host: " + hostId);
        }
        return sshConfig;
    }

    public static void updateRemoteHost(@NotNull String hostId, @NotNull SshConfig SshConfig2) {
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(11);
        }
        if (SshConfig2 == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(12);
        }
        RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: update host data: " + hostId);
        ((RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)).updateRemoteHost(hostId, SshConfig2);
    }

    public static void updateRemoteHost(@NotNull String hostId, @NotNull String hostName, @NotNull SshConfig SshConfig2) {
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(13);
        }
        if (hostName == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(14);
        }
        if (SshConfig2 == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(15);
        }
        RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: update host data: " + hostId + " " + hostName);
        ((RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)).updateRemoteHost(hostId, hostName, SshConfig2);
    }

    public static void deleteRemoteHost(@NotNull String hostId) {
        RemoteDeployment remoteDeployment;
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(16);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: delete host: " + hostId);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            return;
        }
        boolean success = remoteDeployment.deleteRemoteHost(hostId);
        if (!success) {
            RemoteHostUtil.LOG.warn("Cannot delete host: " + hostId);
        }
    }

    @Nullable
    public static PathMapper getPathMapper(@NotNull String hostId, @NotNull Project project) {
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(17);
        }
        if (project == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(18);
        }
        List<PathMappingSettings.PathMapping> mappings = ((RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)).getPathMapping(hostId, project);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: get path-mapping by host: (" + hostId + ") " + mappings);
        }
        if (mappings.isEmpty()) {
            return null;
        }
        String rootPath = RemoteDeploymentHelper.getRootPath(hostId);
        if (rootPath.length() > 1) {
            for (PathMappingSettings.PathMapping mapping : mappings) {
                String remotePath = FileUtil.toCanonicalPath((String)(rootPath + "/" + mapping.getRemoteRoot()), (char)'/');
                mapping.setRemoteRoot(remotePath);
            }
        }
        return new PathMappingSettings(mappings);
    }

    @NotNull
    public static String getRootPath(@NotNull String hostId) {
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(19);
        }
        String string = ((RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)).getRootPath(hostId);
        if (string == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static PathMapper getOrCreatePathMapper(@Nullable String hostId, @NotNull SshConfig sshConfig, @Nullable Project project, @Nullable File projectDir) {
        Object tempDir;
        if (sshConfig == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(21);
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: create or get path-mapping for host: " + hostId);
        }
        if (hostId == null) {
            PathMapper pathMapper = EmptyPathMapper.INSTANCE;
            if (pathMapper == null) {
                RemoteDeploymentHelper.$$$reportNull$$$0(22);
            }
            return pathMapper;
        }
        if (project == null) {
            PathMapper pathMapper = EmptyPathMapper.INSTANCE;
            if (pathMapper == null) {
                RemoteDeploymentHelper.$$$reportNull$$$0(23);
            }
            return pathMapper;
        }
        PathMapper mapper = RemoteDeploymentHelper.getPathMapper(hostId, project);
        if (mapper != null) {
            PathMapper pathMapper = mapper;
            if (pathMapper == null) {
                RemoteDeploymentHelper.$$$reportNull$$$0(24);
            }
            return pathMapper;
        }
        if (projectDir == null) {
            PathMapper pathMapper = EmptyPathMapper.INSTANCE;
            if (pathMapper == null) {
                RemoteDeploymentHelper.$$$reportNull$$$0(25);
            }
            return pathMapper;
        }
        RemoteCredentials credentials = sshConfig.copyToCredentials();
        try {
            tempDir = ApplicationManager.getApplication().isUnitTestMode() ? "/tmp/" + projectDir.getName() : RemoteUtil.mktemp(credentials, OSType.LINUX, true);
        }
        catch (com.intellij.execution.ExecutionException e) {
            tempDir = "/tmp/" + projectDir.getName();
            RemoteHostUtil.LOG.warn((Throwable)e);
        }
        List<PathMappingSettings.PathMapping> mapping = Collections.singletonList(new PathMappingSettings.PathMapping(projectDir.getPath(), (String)tempDir));
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: create path-mapping for host: (" + hostId + ") " + mapping);
        }
        ((RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)).setPathMapping(hostId, project, mapping);
        return new PathMappingSettings(mapping);
    }

    public static void download(@NotNull String hostId, @Nullable SshConfig sshConfig, @NotNull Project project, @NotNull String remotePath, @NotNull String localPath, @NotNull ProgressIndicator parentIndicator) throws IOException {
        RemoteDeployment remoteDeployment;
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(26);
        }
        if (project == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(27);
        }
        if (remotePath == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(28);
        }
        if (localPath == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(29);
        }
        if (parentIndicator == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(30);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            throw new IOException("Remote deployment service is disabled");
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: download: (" + hostId + ") " + remotePath + " -> " + localPath);
        }
        RemoteDeploymentHelper.waitForTransferOperation(remoteDeployment.download(hostId, sshConfig, project, remotePath, localPath, parentIndicator));
    }

    public static void upload(@NotNull String hostId, @NotNull Project project, @NotNull String localPath, @NotNull String remotePath, @NotNull ProgressIndicator parentIndicator) throws IOException {
        RemoteDeployment remoteDeployment;
        if (hostId == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(31);
        }
        if (project == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(32);
        }
        if (localPath == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(33);
        }
        if (remotePath == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(34);
        }
        if (parentIndicator == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(35);
        }
        if ((remoteDeployment = (RemoteDeployment)ApplicationManager.getApplication().getService(RemoteDeployment.class)) == null) {
            throw new IOException("Remote deployment service is disabled");
        }
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: upload: (" + hostId + ") " + localPath + " -> " + remotePath);
        }
        RemoteDeploymentHelper.waitForTransferOperation(remoteDeployment.upload(hostId, project, localPath, remotePath, parentIndicator));
    }

    public static void waitForTransferOperation(@NotNull Future<?> future) {
        if (future == null) {
            RemoteDeploymentHelper.$$$reportNull$$$0(36);
        }
        try {
            future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            if (ExceptionUtil.causedBy((Throwable)e, CancellationException.class)) {
                if (RemoteHostUtil.LOG.isDebugEnabled()) {
                    RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: Transfer operation was canceled");
                }
            }
            RemoteHostUtil.LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathField";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostId";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfig";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostIds";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "SshConfig";
                break;
            }
            case 18: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/RemoteDeploymentHelper";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentIndicator";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/RemoteDeploymentHelper";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreatePathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseRemoteHostAction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDeploymentConfigAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteHost";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "migrateToDedicatedServerGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSshConfig";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateRemoteHost";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteHost";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPathMapper";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRootPath";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePathMapper";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "upload";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "waitForTransferOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

