/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.Decompressor;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TarUtil {
    @NotNull
    public static String tar(@NotNull HostMachine host, @NotNull String directoryPath, @Nullable ProgressIndicator progressIndicator, boolean syncOnlyTextFiles) throws IOException {
        String string;
        block9: {
            if (host == null) {
                TarUtil.$$$reportNull$$$0(0);
            }
            if (directoryPath == null) {
                TarUtil.$$$reportNull$$$0(1);
            }
            Path fileListPath = null;
            try {
                if (syncOnlyTextFiles) {
                    fileListPath = Files.createTempFile(host.getTempDirectory(), "fileList", "txt", new FileAttribute[0]);
                    fileListPath = RemoteUtil.filterTextFiles(host, directoryPath, fileListPath);
                }
                String archivePath = RemoteUtil.generateTempFileName(host) + ".tar.gz";
                boolean isDereferenceEnabled = Registry.is((String)"clion.remote.tar.dereference", (boolean)false);
                TarUtil.tar(host, archivePath, directoryPath, isDereferenceEnabled, fileListPath, progressIndicator);
                string = archivePath;
                if (fileListPath == null) break block9;
            }
            catch (ExecutionException e) {
                try {
                    throw new IOException(e);
                }
                catch (Throwable throwable) {
                    if (fileListPath != null) {
                        FileUtil.delete(fileListPath);
                    }
                    throw throwable;
                }
            }
            FileUtil.delete((Path)fileListPath);
        }
        String string2 = string;
        if (string2 == null) {
            TarUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public static void tar(@NotNull HostMachine host, @NotNull String archiveName, @NotNull String directoryPath, boolean isDereferenceEnabled, @Nullable Path fileListPath, @Nullable ProgressIndicator progressIndicator) throws ExecutionException {
        if (host == null) {
            TarUtil.$$$reportNull$$$0(3);
        }
        if (archiveName == null) {
            TarUtil.$$$reportNull$$$0(4);
        }
        if (directoryPath == null) {
            TarUtil.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        RemoteUtil.assertUnixOnly(host.getOSType());
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteUtil: tar: " + directoryPath + " -> " + archiveName);
        }
        GeneralCommandLine command = new GeneralCommandLine(new String[]{"tar"});
        command.addParameter(isDereferenceEnabled ? "czfhP" : "czfP");
        command.addParameter(archiveName);
        if (isDereferenceEnabled) {
            command.addParameter("--hard-dereference");
        }
        command.setWorkDirectory(directoryPath);
        if (fileListPath != null) {
            command.addParameter("--files-from=" + fileListPath.toString());
        } else {
            command.addParameter(".");
        }
        int tarTimeout = Registry.intValue((String)"clion.remote.tar.timeout", (int)240000);
        ProcessOutput output = host.runProcess(command, progressIndicator, tarTimeout);
        if (output.isTimeout()) {
            throw new ExecutionException(ToolchainsBundle.message("dialog.message.timeout", directoryPath));
        }
        if (output.getExitCode() != 0) {
            RemoteHostUtil.LOG.warn(directoryPath + ": " + output.getExitCode() + ", " + output.getStderr());
        }
    }

    public static void decompress(@NotNull File archive, @NotNull File outputDir, @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (archive == null) {
            TarUtil.$$$reportNull$$$0(6);
        }
        if (outputDir == null) {
            TarUtil.$$$reportNull$$$0(7);
        }
        if (progressIndicator == null) {
            TarUtil.$$$reportNull$$$0(8);
        }
        new Decompressor.Tar(archive).entryFilter(entry -> {
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (SystemInfo.isWindows && entry.linkTarget != null) {
                try {
                    Path outputFile = Decompressor.entryFile((Path)outputDir.toPath(), (String)entry.name);
                    TarUtil.createWinJunctionDirectory(outputFile, entry.linkTarget);
                }
                catch (ExecutionException | IOException e) {
                    RemoteHostUtil.LOG.error(e);
                }
                return false;
            }
            return true;
        }).extract(outputDir);
        FileUtil.createIfDoesntExist((File)outputDir);
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteHost: decompression finished -> " + outputDir);
        }
    }

    static void createWinJunctionDirectory(@NotNull Path outputFile, String linkTarget) throws IOException, ExecutionException {
        if (outputFile == null) {
            TarUtil.$$$reportNull$$$0(9);
        }
        Path wd = outputFile.getParent();
        Files.createDirectories(wd, new FileAttribute[0]);
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"cmd", "/C", "mklink", "/J", outputFile.toString(), FileUtil.toSystemDependentName((String)linkTarget)});
        cmd.setWorkDirectory(wd.toString());
        ProcessOutput output = new CapturingProcessHandler(cmd).runProcess();
        output.checkSuccess(RemoteHostUtil.LOG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/TarUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archive";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/TarUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "tar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tar";
                break;
            }
            case 2: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "decompress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createWinJunctionDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

