/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlArrayType;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class Field {
    private final String myName;
    private final MetaTypeSupplier myMetaTypeSupplier;
    private YamlMetaType myMainType;
    private boolean myIsRequired;
    private boolean myEditable;
    private boolean myDeprecated;
    private boolean myAnyNameAllowed;
    private boolean myEmptyValueAllowed;
    private boolean myIsMany;
    private Relation myOverriddenDefaultRelation;
    private final Map<Relation, YamlMetaType> myPerRelationTypes;

    public Field(@NonNls @NotNull String name, @NotNull YamlMetaType mainType) {
        if (name == null) {
            Field.$$$reportNull$$$0(0);
        }
        if (mainType == null) {
            Field.$$$reportNull$$$0(1);
        }
        this.myEditable = true;
        this.myDeprecated = false;
        this.myPerRelationTypes = new HashMap<Relation, YamlMetaType>();
        this.myName = name;
        this.myMainType = mainType;
        if (this.myMainType instanceof YamlArrayType) {
            this.myMainType = ((YamlArrayType)this.myMainType).getElementType();
            this.myIsMany = !(this.myMainType instanceof YamlArrayType);
        }
        this.myMetaTypeSupplier = null;
    }

    public Field(@NonNls @NotNull String name, @NotNull MetaTypeSupplier supplier) {
        if (name == null) {
            Field.$$$reportNull$$$0(2);
        }
        if (supplier == null) {
            Field.$$$reportNull$$$0(3);
        }
        this.myEditable = true;
        this.myDeprecated = false;
        this.myPerRelationTypes = new HashMap<Relation, YamlMetaType>();
        this.myName = name;
        this.myMetaTypeSupplier = supplier;
    }

    @NotNull
    public Field withDefaultRelation(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(4);
        }
        this.myOverriddenDefaultRelation = relation;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(5);
        }
        return field;
    }

    public Field withRelationSpecificType(@NotNull Relation relation, @NotNull YamlMetaType specificType) {
        if (relation == null) {
            Field.$$$reportNull$$$0(6);
        }
        if (specificType == null) {
            Field.$$$reportNull$$$0(7);
        }
        this.myPerRelationTypes.put(relation, specificType);
        return this;
    }

    @NotNull
    public Field withMultiplicityMany() {
        Field field = this.withMultiplicityManyNotOne(true);
        if (field == null) {
            Field.$$$reportNull$$$0(8);
        }
        return field;
    }

    @NotNull
    public Field withMultiplicityManyNotOne(boolean manyNotOne) {
        this.myIsMany = manyNotOne;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(9);
        }
        return field;
    }

    @Contract(pure=true)
    public boolean isMany() {
        return this.myIsMany;
    }

    @NotNull
    public Field setRequired() {
        this.myIsRequired = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(10);
        }
        return field;
    }

    @NotNull
    public Field setDeprecated() {
        this.myDeprecated = true;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(11);
        }
        return field;
    }

    @NotNull
    public Field setNonEditable() {
        this.myEditable = false;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(12);
        }
        return field;
    }

    @Contract(pure=true)
    public final boolean isRequired() {
        return this.myIsRequired;
    }

    @Contract(pure=true)
    public final boolean isEditable() {
        return this.myEditable;
    }

    @Contract(pure=true)
    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    @Contract(pure=true)
    public final String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(13);
        }
        YamlMetaType yamlMetaType = this.myPerRelationTypes.getOrDefault((Object)relation, this.getMainType());
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(14);
        }
        return yamlMetaType;
    }

    @Contract(pure=true)
    @NotNull
    public YamlMetaType getDefaultType() {
        YamlMetaType yamlMetaType = this.getType(this.getDefaultRelation());
        if (yamlMetaType == null) {
            Field.$$$reportNull$$$0(15);
        }
        return yamlMetaType;
    }

    @NotNull
    public Relation getDefaultRelation() {
        if (this.myOverriddenDefaultRelation != null) {
            Relation relation = this.myOverriddenDefaultRelation;
            if (relation == null) {
                Field.$$$reportNull$$$0(16);
            }
            return relation;
        }
        if (this.myIsMany || this.getMainType() instanceof YamlArrayType) {
            Relation relation = Relation.SEQUENCE_ITEM;
            if (relation == null) {
                Field.$$$reportNull$$$0(17);
            }
            return relation;
        }
        Relation relation = this.getMainType() instanceof YamlScalarType ? Relation.SCALAR_VALUE : Relation.OBJECT_CONTENTS;
        if (relation == null) {
            Field.$$$reportNull$$$0(18);
        }
        return relation;
    }

    @NotNull
    public Field withEmptyValueAllowed(boolean allow) {
        this.myEmptyValueAllowed = allow;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(19);
        }
        return field;
    }

    @NotNull
    public final Field withAnyName() {
        Field field = this.withAnyName(true);
        if (field == null) {
            Field.$$$reportNull$$$0(20);
        }
        return field;
    }

    @NotNull
    public Field withAnyName(boolean allowAnyName) {
        this.myAnyNameAllowed = allowAnyName;
        Field field = this;
        if (field == null) {
            Field.$$$reportNull$$$0(21);
        }
        return field;
    }

    public final boolean isAnyNameAllowed() {
        return this.myAnyNameAllowed;
    }

    public final boolean isEmptyValueAllowed() {
        return this.myEmptyValueAllowed;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.getName()).append("]@");
        result.append(Integer.toHexString(this.hashCode()));
        result.append(" : ");
        result.append(this.getMainType().getTypeName());
        List nonDefaultTypes = this.myPerRelationTypes.entrySet().stream().filter(e -> e.getValue() == this.getMainType()).map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.toList());
        if (!nonDefaultTypes.isEmpty()) {
            result.append(nonDefaultTypes);
        }
        return result.toString();
    }

    @NotNull
    public List<LookupElementBuilder> getKeyLookups(@NotNull YamlMetaType ownerClass, @NotNull PsiElement insertedScalar) {
        if (ownerClass == null) {
            Field.$$$reportNull$$$0(22);
        }
        if (insertedScalar == null) {
            Field.$$$reportNull$$$0(23);
        }
        if (this.isAnyNameAllowed()) {
            List<LookupElementBuilder> list = Collections.emptyList();
            if (list == null) {
                Field.$$$reportNull$$$0(24);
            }
            return list;
        }
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)new TypeFieldPair(ownerClass, this), (String)this.getName()).withTypeText(this.getMainType().getDisplayName(), true).withIcon(this.getLookupIcon()).withStrikeoutness(this.isDeprecated());
        if (this.isRequired()) {
            lookup = lookup.bold();
        }
        List<LookupElementBuilder> list = Collections.singletonList(lookup);
        if (list == null) {
            Field.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    public PsiReference getReferenceFromKey(@NotNull YAMLKeyValue keyValue) {
        if (keyValue == null) {
            Field.$$$reportNull$$$0(26);
        }
        return null;
    }

    public boolean hasRelationSpecificType(@NotNull Relation relation) {
        if (relation == null) {
            Field.$$$reportNull$$$0(27);
        }
        return relation == this.getDefaultRelation() || this.myPerRelationTypes.containsKey((Object)relation);
    }

    @Nullable
    public Icon getLookupIcon() {
        return this.myIsMany ? AllIcons.Json.Array : this.getMainType().getIcon();
    }

    @NotNull
    public Field resolveToSpecializedField(@NotNull YAMLValue element) {
        if (element == null) {
            Field.$$$reportNull$$$0(28);
        }
        if (this.myMetaTypeSupplier == null) {
            Field field = this;
            if (field == null) {
                Field.$$$reportNull$$$0(29);
            }
            return field;
        }
        YamlMetaType specializedType = this.myMetaTypeSupplier.getSpecializedType(element);
        if (specializedType == null) {
            Field field = this;
            if (field == null) {
                Field.$$$reportNull$$$0(30);
            }
            return field;
        }
        Field field = this.cloneWithNewType(specializedType);
        if (field == null) {
            Field.$$$reportNull$$$0(31);
        }
        return field;
    }

    private Field cloneWithNewType(@NotNull YamlMetaType newType) {
        if (newType == null) {
            Field.$$$reportNull$$$0(32);
        }
        Field result = this.newField(newType);
        result.myIsRequired = this.myIsRequired;
        result.myEditable = this.myEditable;
        result.myDeprecated = this.myDeprecated;
        result.myAnyNameAllowed = this.myAnyNameAllowed;
        result.myEmptyValueAllowed = this.myEmptyValueAllowed;
        result.myIsMany = this.myIsMany;
        result.myOverriddenDefaultRelation = this.myOverriddenDefaultRelation;
        result.myPerRelationTypes.putAll(this.myPerRelationTypes);
        return result;
    }

    @NotNull
    protected Field newField(@NotNull YamlMetaType type) {
        if (type == null) {
            Field.$$$reportNull$$$0(33);
        }
        return new Field(this.myName, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private YamlMetaType getMainType() {
        if (this.myMainType != null) {
            YamlMetaType yamlMetaType = this.myMainType;
            if (yamlMetaType != null) return yamlMetaType;
            Field.$$$reportNull$$$0(34);
            return yamlMetaType;
        }
        assert (this.myMetaTypeSupplier != null);
        MetaTypeSupplier metaTypeSupplier = this.myMetaTypeSupplier;
        // MONITORENTER : metaTypeSupplier
        if (this.myMainType == null) {
            try {
                YamlMetaType mainType = this.myMetaTypeSupplier.getMainType();
                assert (!(this.myMainType instanceof YamlArrayType)) : "Type supplier must not provide array types";
                this.myMainType = mainType;
            }
            catch (Exception e) {
                throw new RuntimeException("Supplier failed to return a metatype for field: " + this, e);
            }
        }
        YamlMetaType yamlMetaType = this.myMainType;
        // MONITOREXIT : metaTypeSupplier
        if (yamlMetaType != null) return yamlMetaType;
        Field.$$$reportNull$$$0(35);
        return yamlMetaType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedScalar";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValue";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/model/Field";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withDefaultRelation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityMany";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "withMultiplicityManyNotOne";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setRequired";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setDeprecated";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "setNonEditable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultRelation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withEmptyValueAllowed";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "withAnyName";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyLookups";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToSpecializedField";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withDefaultRelation";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withRelationSpecificType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getKeyLookups";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceFromKey";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasRelationSpecificType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveToSpecializedField";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithNewType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "newField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface MetaTypeSupplier {
        @NotNull
        public YamlMetaType getMainType();

        @Nullable
        default public YamlMetaType getSpecializedType(@NotNull YAMLValue element) {
            if (element == null) {
                MetaTypeSupplier.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/meta/model/Field$MetaTypeSupplier", "getSpecializedType"));
        }
    }

    public static enum Relation {
        SCALAR_VALUE,
        SEQUENCE_ITEM,
        OBJECT_CONTENTS;

    }
}

