/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.number.ShiftUtils;
import org.jetbrains.annotations.NotNull;

public class JSReplaceMultiplyWithShiftIntention
extends JSMutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        Pair<String, String> pair = ShiftUtils.multiplyOperators.get(((JSBinaryExpression)element).getOperationSign());
        return JSIntentionBundle.message("number.replace-multiply-with-shift.display-name", pair.first, pair.second);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("number.replace-multiply-with-shift.family-name", new Object[0]);
        if (string == null) {
            JSReplaceMultiplyWithShiftIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new MultiplyByPowerOfTwoPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSReplaceMultiplyWithShiftIntention.$$$reportNull$$$0(1);
        }
        if (element instanceof JSAssignmentExpression) {
            JSReplaceMultiplyWithShiftIntention.replaceMultiplyOrDivideAssignWithShiftAssign((JSAssignmentExpression)element);
        } else {
            JSReplaceMultiplyWithShiftIntention.replaceMultiplyOrDivideWithShift((JSBinaryExpression)element);
        }
    }

    private static void replaceMultiplyOrDivideAssignWithShiftAssign(JSAssignmentExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (lhs != null && rhs != null);
        IElementType tokenType = exp.getOperationSign();
        String assignString = (String)ShiftUtils.multiplyOperators.get((Object)tokenType).second;
        String expString = lhs.getText() + assignString + ShiftUtils.getLogBase2(rhs);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static void replaceMultiplyOrDivideWithShift(JSBinaryExpression exp) throws IncorrectOperationException {
        JSExpression lhs = exp.getLOperand();
        JSExpression rhs = exp.getROperand();
        assert (lhs != null && rhs != null);
        IElementType tokenType = exp.getOperationSign();
        assert (tokenType != null);
        String operatorString = (String)ShiftUtils.multiplyOperators.get((Object)tokenType).second;
        if (ShiftUtils.isPowerOfTwo(lhs) && tokenType.equals(JSTokenTypes.MULT)) {
            JSExpression swap = lhs;
            lhs = rhs;
            rhs = swap;
        }
        String lhsText = JSParenthesesUtils.getParenthesized((JSExpression)lhs, (int)8);
        String expString = lhsText + operatorString + ShiftUtils.getLogBase2(rhs);
        JSElement parent = (JSElement)exp.getParent();
        if (parent instanceof JSExpression && !(parent instanceof JSParenthesizedExpression) && JSParenthesesUtils.getPrecedence((JSExpression)((JSExpression)parent)) < 8) {
            expString = "(" + expString + ")";
        }
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)expString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MultiplyByPowerOfTwoPredicate
    implements JSElementPredicate {
        private MultiplyByPowerOfTwoPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            JSBinaryExpression expression;
            if (element == null) {
                MultiplyByPowerOfTwoPredicate.$$$reportNull$$$0(0);
            }
            if ((expression = (JSBinaryExpression)ObjectUtils.tryCast((Object)element, JSBinaryExpression.class)) == null) {
                return false;
            }
            IElementType sign = expression.getOperationSign();
            if (!ShiftUtils.multiplyOperators.containsKey(sign)) {
                return false;
            }
            JSExpression rOperand = expression.getROperand();
            JSExpression lOperand = expression.getLOperand();
            if (ShiftUtils.isPowerOfTwo(rOperand) && lOperand != null) {
                return true;
            }
            return sign == JSTokenTypes.MULT && ShiftUtils.isPowerOfTwo(lOperand) && rOperand != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/JSReplaceMultiplyWithShiftIntention$MultiplyByPowerOfTwoPredicate", "satisfiedBy"));
        }
    }
}

