/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system.remote.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ui.AppUIUtil;
import com.jetbrains.cidr.cpp.CPPBundle;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.project.CidrProjectAction;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.plugins.remotesdk.console.SshConsoleOptionsProvider;
import com.jetbrains.plugins.remotesdk.console.SshTerminalCachingRunner;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalView;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/system/remote/actions/OpenRemoteHostTerminalAction;", "Lcom/jetbrains/cidr/project/CidrProjectAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createTerminalSession", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runner", "Lcom/jetbrains/plugins/remotesdk/console/SshTerminalCachingRunner;", "project", "Lcom/intellij/openapi/project/Project;", "dir", "", "getRemoteEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getRemoteProjectDir", "env", "projectPath", "runSshConsole", "host", "Lcom/jetbrains/cidr/system/HostMachine;", "update", "intellij.clion.webDeployment"})
public final class OpenRemoteHostTerminalAction
extends CidrProjectAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            String projectPath;
            Project project;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = project = CidrProjectAction.getEventProject((AnActionEvent)e);
            String string = projectPath = project2 != null ? project2.getBasePath() : null;
            if (projectPath == null) {
                return;
            }
            CidrToolEnvironment cidrToolEnvironment = this.getRemoteEnvironment(e);
            if (cidrToolEnvironment == null) break block2;
            CidrToolEnvironment cidrToolEnvironment2 = cidrToolEnvironment;
            boolean bl = false;
            boolean bl2 = false;
            CidrToolEnvironment env = cidrToolEnvironment2;
            boolean bl3 = false;
            String string2 = this.getRemoteProjectDir(env, projectPath);
            if (string2 != null) {
                String string3 = string2;
                boolean bl4 = false;
                boolean bl5 = false;
                String directory = string3;
                boolean bl6 = false;
                HostMachine hostMachine = env.getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"env.hostMachine");
                this.runSshConsole(project, hostMachine, directory);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        String projectPath;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean shouldBeEnabled = false;
        Project project = CidrProjectAction.getEventProject((AnActionEvent)e);
        String string = projectPath = project != null ? project.getBasePath() : null;
        if (projectPath != null) {
            CidrToolEnvironment cidrToolEnvironment = this.getRemoteEnvironment(e);
            if (cidrToolEnvironment != null) {
                CidrToolEnvironment cidrToolEnvironment2 = cidrToolEnvironment;
                boolean bl = false;
                boolean bl2 = false;
                CidrToolEnvironment env = cidrToolEnvironment2;
                boolean bl3 = false;
                String string2 = this.getRemoteProjectDir(env, projectPath);
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it = string3;
                    boolean bl6 = false;
                    shouldBeEnabled = true;
                }
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(shouldBeEnabled);
    }

    private final CidrToolEnvironment getRemoteEnvironment(AnActionEvent e) {
        Object v1;
        block4: {
            List list = CidrProjectAction.getActionWorkspaces((AnActionEvent)e);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActionWorkspaces(e)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CidrWorkspace it = (CidrWorkspace)element$iv;
                boolean bl = false;
                if (!(it instanceof WorkspaceWithEnvironment)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        Object $this$castSafelyTo$iv = v1;
        boolean $i$f$castSafelyTo = false;
        Object v2 = $this$castSafelyTo$iv;
        if (!(v2 instanceof WorkspaceWithEnvironment)) {
            v2 = null;
        }
        WorkspaceWithEnvironment workspaceWithEnvironment = v2;
        if (workspaceWithEnvironment != null) {
            Object v5;
            block5: {
                WorkspaceWithEnvironment workspaceWithEnvironment2 = workspaceWithEnvironment;
                boolean bl = false;
                boolean bl2 = false;
                WorkspaceWithEnvironment it = workspaceWithEnvironment2;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = it.getEnvironment();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CidrToolEnvironment env = (CidrToolEnvironment)element$iv;
                    boolean bl4 = false;
                    HostMachine hostMachine = env.getHostMachine();
                    if (!(hostMachine != null ? hostMachine.isRemote() : false)) continue;
                    v5 = element$iv;
                    break block5;
                }
                v5 = null;
            }
            return v5;
        }
        return null;
    }

    private final String getRemoteProjectDir(CidrToolEnvironment env, String projectPath) {
        MappedHost mappedHost;
        HostMachine $this$castSafelyTo$iv = env.getHostMachine();
        boolean $i$f$castSafelyTo = false;
        HostMachine hostMachine = $this$castSafelyTo$iv;
        if (!(hostMachine instanceof MappedHost)) {
            hostMachine = null;
        }
        return (mappedHost = (MappedHost)hostMachine) != null && (mappedHost = mappedHost.getPathMapper()) != null ? mappedHost.convertToRemote(projectPath) : null;
    }

    private final void runSshConsole(Project project, HostMachine host, String dir) {
        block0: {
            SshConsoleOptionsProvider sshConsoleOptionsProvider = SshConsoleOptionsProvider.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)sshConsoleOptionsProvider, (String)"SshConsoleOptionsProvider.getInstance(project)");
            SshConsoleOptionsProvider optionsProvider = sshConsoleOptionsProvider;
            RemoteCredentials remoteCredentials = RemoteUtil.getCredentials((HostMachine)host);
            if (remoteCredentials == null) break block0;
            RemoteCredentials remoteCredentials2 = remoteCredentials;
            boolean bl = false;
            boolean bl2 = false;
            RemoteCredentials it = remoteCredentials2;
            boolean bl3 = false;
            SshTerminalCachingRunner runner = new SshTerminalCachingRunner(project, it, optionsProvider.getCharset());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(runner, project, CPPBundle.message((String)"progress.title.connecting.to.remote.host", (Object[])new Object[0]), true, this, project, optionsProvider, dir){
                final /* synthetic */ SshTerminalCachingRunner $runner;
                final /* synthetic */ OpenRemoteHostTerminalAction this$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ SshConsoleOptionsProvider $optionsProvider$inlined;
                final /* synthetic */ String $dir$inlined;
                {
                    this.$runner = $captured_local_variable$1;
                    this.this$0 = openRemoteHostTerminalAction;
                    this.$project$inlined = project;
                    this.$optionsProvider$inlined = sshConsoleOptionsProvider;
                    this.$dir$inlined = string;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    OpenRemoteHostTerminalAction.access$createTerminalSession(this.this$0, indicator, this.$runner, this.$project$inlined, this.$dir$inlined);
                }
            });
        }
    }

    private final void createTerminalSession(ProgressIndicator indicator, SshTerminalCachingRunner runner, Project project, String dir) {
        block2: {
            try {
                runner.connect();
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)new Runnable(project, runner, dir){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ SshTerminalCachingRunner $runner;
                    final /* synthetic */ String $dir;

                    public final void run() {
                        TerminalTabState terminalTabState = new TerminalTabState();
                        boolean bl = false;
                        boolean bl2 = false;
                        TerminalTabState terminalTabState2 = terminalTabState;
                        AbstractTerminalRunner abstractTerminalRunner = (AbstractTerminalRunner)this.$runner;
                        TerminalView terminalView = TerminalView.getInstance((Project)this.$project);
                        boolean bl3 = false;
                        $this$apply.myWorkingDirectory = this.$dir;
                        Unit unit = Unit.INSTANCE;
                        terminalView.createNewSession(abstractTerminalRunner, terminalTabState);
                    }
                    {
                        this.$project = project;
                        this.$runner = sshTerminalCachingRunner;
                        this.$dir = string;
                    }
                });
            }
            catch (RemoteSdkException e) {
                if (indicator.isCanceled()) break block2;
                AppUIUtil.invokeLaterIfProjectAlive((Project)project, (Runnable)new Runnable(project, e){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RemoteSdkException $e;

                    public final void run() {
                        Messages.showErrorDialog((Project)this.$project, (String)this.$e.getMessage(), (String)CPPBundle.message((String)"dialog.title.connection.failed", (Object[])new Object[0]));
                    }
                    {
                        this.$project = project;
                        this.$e = remoteSdkException;
                    }
                });
            }
        }
    }

    public OpenRemoteHostTerminalAction() {
        super(CPPBundle.message((String)"action.open.remote.host.terminal.text", (Object[])new Object[0]));
    }

    public static final /* synthetic */ void access$createTerminalSession(OpenRemoteHostTerminalAction $this, ProgressIndicator indicator, SshTerminalCachingRunner runner, Project project, String dir) {
        $this.createTerminalSession(indicator, runner, project, dir);
    }
}

