/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFileSettings
implements Serializable {
    @NotNull
    private final OCLanguageKind myLanguageKind;
    @Nullable
    private final String myObjectTargetName;
    @NotNull
    private final List<String> myLeadingFlags;
    @NotNull
    private final List<String> myTrailingFlags;
    @NotNull
    private final List<String> myDefines;

    public CMakeFileSettings(@NotNull OCLanguageKind languageKind, @Nullable String objectTargetName, @NotNull List<String> leadingFlags, @NotNull List<String> trailingFlags, @NotNull List<String> defines) {
        if (languageKind == null) {
            CMakeFileSettings.$$$reportNull$$$0(0);
        }
        if (leadingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(1);
        }
        if (trailingFlags == null) {
            CMakeFileSettings.$$$reportNull$$$0(2);
        }
        if (defines == null) {
            CMakeFileSettings.$$$reportNull$$$0(3);
        }
        this.myLanguageKind = languageKind;
        this.myObjectTargetName = objectTargetName;
        this.myLeadingFlags = Collections.unmodifiableList(ContainerUtil.trimToSize(leadingFlags));
        this.myTrailingFlags = Collections.unmodifiableList(ContainerUtil.trimToSize(trailingFlags));
        this.myDefines = Collections.unmodifiableList(ContainerUtil.trimToSize(defines));
    }

    @NotNull
    public OCLanguageKind getLanguageKind() {
        OCLanguageKind oCLanguageKind = this.myLanguageKind;
        if (oCLanguageKind == null) {
            CMakeFileSettings.$$$reportNull$$$0(4);
        }
        return oCLanguageKind;
    }

    public boolean hasCustomSettings() {
        return !this.myLeadingFlags.isEmpty() || !this.myTrailingFlags.isEmpty() || !this.myDefines.isEmpty();
    }

    @Nullable
    public String getObjectTargetName() {
        return this.myObjectTargetName;
    }

    @NotNull
    public List<String> getLeadingFlags() {
        List<String> list = this.myLeadingFlags;
        if (list == null) {
            CMakeFileSettings.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<String> getTrailingFlags() {
        List<String> list = this.myTrailingFlags;
        if (list == null) {
            CMakeFileSettings.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<String> getDefines() {
        List<String> list = this.myDefines;
        if (list == null) {
            CMakeFileSettings.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NonNls
    public String toString() {
        return "FileSettings: {LanguageKind=" + this.myLanguageKind + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leadingFlags";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trailingFlags";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeFileSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageKind";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadingFlags";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrailingFlags";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

