/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.google.gson.JsonParseException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.cpp.cmake.presets.problems.PresetProblem;
import com.jetbrains.cidr.gson.GsonMalformedJsonError;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0018\u0010\u0005\u001a\u00060\u0001j\u0002`\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/FileParsingException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "file", "Ljava/nio/file/Path;", "cause", "(Ljava/nio/file/Path;Ljava/lang/Exception;)V", "getCause", "()Ljava/lang/Exception;", "getFile", "()Ljava/nio/file/Path;", "asProblem", "Lcom/jetbrains/cidr/cpp/cmake/presets/problems/PresetProblem;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.cmake"})
public final class FileParsingException
extends Exception {
    @NotNull
    private final Path file;
    @NotNull
    private final Exception cause;

    @NotNull
    public final PresetProblem asProblem(@NotNull Project project) {
        PresetProblem presetProblem;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(this.file);
        if (virtualFile == null) {
            throw (Throwable)new IllegalStateException("Path " + this.file + " cannot be found in VFS");
        }
        Exception exception = this.getCause();
        if (exception instanceof JsonParseException) {
            Object object = this.getCause().getCause();
            if (object == null || (object = ((Throwable)object).getLocalizedMessage()) == null) {
                object = ((JsonParseException)this.getCause()).getLocalizedMessage();
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cause.cause?.localizedMe\u2026?: cause.localizedMessage");
            presetProblem = new PresetProblem(this, project, virtualFile, project, virtualFile, (String)object){
                private final GsonMalformedJsonError error;
                final /* synthetic */ FileParsingException this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;

                public int getLine() {
                    return this.error.getLine() - 1;
                }

                public int getColumn() {
                    return this.error.getColumn() - 1;
                }
                {
                    this.this$0 = this$0;
                    this.$project = $captured_local_variable$1;
                    this.$virtualFile = $captured_local_variable$2;
                    super($super_call_param$3, $super_call_param$4, $super_call_param$5, null, 8, null);
                    this.error = new GsonMalformedJsonError(this.getText());
                }
            };
        } else {
            String string = this.getCause().getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cause.localizedMessage");
            presetProblem = new PresetProblem(project, virtualFile, string, null, 8, null);
        }
        return presetProblem;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public Exception getCause() {
        return this.cause;
    }

    public FileParsingException(@NotNull Path file, @NotNull Exception cause) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.file = file;
        this.cause = cause;
    }
}

