/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.cmake.presets.EmptySchemaException;
import com.jetbrains.cidr.cpp.cmake.presets.FileParsingException;
import com.jetbrains.cidr.cpp.cmake.presets.GenericPresetException;
import com.jetbrains.cidr.cpp.cmake.presets.NoPresetFilesException;
import com.jetbrains.cidr.cpp.cmake.presets.NullObjectException;
import com.jetbrains.cidr.cpp.cmake.presets.Schema;
import com.jetbrains.cidr.cpp.cmake.presets.SchemaWithDuplicateNamesException;
import com.jetbrains.cidr.cpp.cmake.presets.SchemaWithEmptyPresetNamesException;
import com.jetbrains.cidr.cpp.cmake.presets.UnsupportedSchemaException;
import com.jetbrains.cidr.cpp.cmake.presets.VersionedSchema;
import com.jetbrains.cidr.cpp.cmake.presets.v2.BuildPresetV2;
import com.jetbrains.cidr.cpp.cmake.presets.v2.ConfigurePresetV2;
import com.jetbrains.cidr.cpp.cmake.presets.v2.SchemaV2;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006H\u0002\u001a\u001a\u0010\b\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u0006H\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0001\u001a$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"cmakePresetsFileName", "", "cmakeUserPresetsFileName", "checkBuildPresets", "", "presets", "", "Lcom/jetbrains/cidr/cpp/cmake/presets/v2/BuildPresetV2;", "checkConfigurePresets", "Lcom/jetbrains/cidr/cpp/cmake/presets/v2/ConfigurePresetV2;", "getProjectPresetsFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "getProjectUserPresetsFile", "isPresetFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "parseCMakePresets", "Lcom/jetbrains/cidr/cpp/cmake/presets/Schema;", "path", "globalContent", "userContent", "readSchema", "Lcom/jetbrains/cidr/cpp/cmake/presets/v2/SchemaV2;", "content", "readSchemaAndHandleErrors", "Lkotlin/Pair;", "intellij.clion.cmake"})
public final class ParseKt {
    private static final String cmakePresetsFileName = "CMakePresets.json";
    private static final String cmakeUserPresetsFileName = "CMakeUserPresets.json";

    @NotNull
    public static final Path getProjectPresetsFile(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path path = projectPath.resolve(cmakePresetsFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectPath.resolve(cmakePresetsFileName)");
        return path;
    }

    @NotNull
    public static final Path getProjectPresetsFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(CMakeWorkspace.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        CMakeWorkspace workspace = (CMakeWorkspace)((Object)object);
        Path path = workspace.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"workspace.projectPath");
        return ParseKt.getProjectPresetsFile(path);
    }

    @NotNull
    public static final Path getProjectUserPresetsFile(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path path = projectPath.resolve(cmakeUserPresetsFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectPath.resolve(cmakeUserPresetsFileName)");
        return path;
    }

    @NotNull
    public static final Path getProjectUserPresetsFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(CMakeWorkspace.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        CMakeWorkspace workspace = (CMakeWorkspace)((Object)object);
        Path path = workspace.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"workspace.projectPath");
        return ParseKt.getProjectUserPresetsFile(path);
    }

    public static final boolean isPresetFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)cmakePresetsFileName) || Intrinsics.areEqual((Object)file.getName(), (Object)cmakeUserPresetsFileName);
    }

    public static final boolean isPresetFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)cmakePresetsFileName) || Intrinsics.areEqual((Object)file.getName(), (Object)cmakeUserPresetsFileName);
    }

    @NotNull
    public static final Schema parseCMakePresets(@NotNull Project project) {
        Pair<Path, SchemaV2> pair;
        Pair<Path, SchemaV2> pair2;
        boolean bl;
        String userContent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path presetsFile = ParseKt.getProjectPresetsFile(project);
        String globalContent = PathKt.exists((Path)presetsFile) ? FileUtil.loadFile((File)presetsFile.toFile()) : null;
        Path userPresetsFile = ParseKt.getProjectUserPresetsFile(project);
        String string = userContent = PathKt.exists((Path)userPresetsFile) ? FileUtil.loadFile((File)userPresetsFile.toFile()) : null;
        if (globalContent == null && userContent == null) {
            throw (Throwable)new NoPresetFilesException();
        }
        String string2 = globalContent;
        if (string2 != null) {
            String string3 = string2;
            boolean bl2 = false;
            bl = false;
            String it = string3;
            boolean bl3 = false;
            pair2 = ParseKt.readSchemaAndHandleErrors(presetsFile, globalContent);
        } else {
            pair2 = null;
        }
        Pair<Path, SchemaV2> globalSchema = pair2;
        String string4 = userContent;
        if (string4 != null) {
            String string5 = string4;
            bl = false;
            boolean bl4 = false;
            String it = string5;
            boolean bl5 = false;
            pair = ParseKt.readSchemaAndHandleErrors(userPresetsFile, userContent);
        } else {
            pair = null;
        }
        Pair<Path, SchemaV2> userSchema = pair;
        Path path = presetsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"presetsFile.parent");
        return new Schema(path, globalSchema, userSchema).postProcess();
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public static final Schema parseCMakePresets(@NotNull Path path, @NotNull String globalContent, @Nullable String userContent) {
        Pair<Path, SchemaV2> pair;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)globalContent, (String)"globalContent");
        Path path2 = path;
        Pair<Path, SchemaV2> pair2 = ParseKt.readSchemaAndHandleErrors(path, globalContent);
        String string = userContent;
        if (string != null) {
            void it;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = string2;
            Pair<Path, SchemaV2> pair3 = pair2;
            Path path3 = path2;
            boolean bl3 = false;
            Pair<Path, SchemaV2> pair4 = ParseKt.readSchemaAndHandleErrors(path, (String)it);
            path2 = path3;
            pair2 = pair3;
            pair = pair4;
        } else {
            pair = null;
        }
        Pair<Path, SchemaV2> pair5 = pair;
        Pair<Path, SchemaV2> pair6 = pair2;
        Path path4 = path2;
        return new Schema(path4, pair6, pair5).postProcess();
    }

    public static /* synthetic */ Schema parseCMakePresets$default(Path path, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return ParseKt.parseCMakePresets(path, string, string2);
    }

    private static final Pair<Path, SchemaV2> readSchemaAndHandleErrors(Path path, String content) {
        Pair pair;
        try {
            pair = TuplesKt.to((Object)path, (Object)ParseKt.readSchema(content));
        }
        catch (GenericPresetException ex) {
            throw (Throwable)new FileParsingException(path, ex);
        }
        catch (JsonParseException ex) {
            throw (Throwable)new FileParsingException(path, (Exception)((Object)ex));
        }
        return pair;
    }

    @NotNull
    public static final SchemaV2 readSchema(@NotNull String content) {
        SchemaV2 schema;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        VersionedSchema versionedSchema = (VersionedSchema)new Gson().fromJson(content, VersionedSchema.class);
        if (versionedSchema == null) {
            throw (Throwable)new EmptySchemaException();
        }
        Integer n = versionedSchema.getVersion();
        if (n == null || n != 2) {
            throw (Throwable)new UnsupportedSchemaException(versionedSchema.getVersion());
        }
        SchemaV2 schemaV2 = schema = (SchemaV2)new Gson().fromJson(content, SchemaV2.class);
        Intrinsics.checkNotNullExpressionValue((Object)schemaV2, (String)"schema");
        ParseKt.checkBuildPresets(schemaV2.getBuildPresets());
        ParseKt.checkConfigurePresets(schema.getConfigurePresets());
        return schema;
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkBuildPresets(List<? extends BuildPresetV2> presets) {
        void $this$mapIndexedTo$iv$iv;
        if (presets == null) {
            throw (Throwable)new NullObjectException("buildPresets");
        }
        Iterable $this$mapIndexed$iv = presets;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object t : $this$mapIndexedTo$iv$iv) {
            String string;
            void preset;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BuildPresetV2 buildPresetV2 = (BuildPresetV2)t;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (preset == null) {
                void idx;
                throw (Throwable)new NullObjectException("buildPresets[" + (int)idx + ']');
            }
            if (preset.getName() == null) {
                throw (Throwable)new SchemaWithEmptyPresetNamesException();
            }
            collection.add(string);
        }
        List buildPresetNames = (List)destination$iv$iv;
        Iterable $this$groupingBy$iv = buildPresetNames;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : map2.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            boolean bl3 = false;
            if (!(it > 1)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Set duplicates = ((Map)result$iv).keySet();
        Collection collection = duplicates;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new SchemaWithDuplicateNamesException(CollectionsKt.toList((Iterable)duplicates));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfigurePresets(List<? extends ConfigurePresetV2> presets) {
        void $this$mapIndexedTo$iv$iv;
        if (presets == null) {
            throw (Throwable)new NullObjectException("configurePresets");
        }
        Iterable $this$mapIndexed$iv = presets;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object t : $this$mapIndexedTo$iv$iv) {
            String string;
            void preset;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ConfigurePresetV2 configurePresetV2 = (ConfigurePresetV2)t;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            if (preset == null) {
                void idx;
                throw (Throwable)new NullObjectException("configurePresets[" + (int)idx + ']');
            }
            if (preset.getName() == null) {
                throw (Throwable)new SchemaWithEmptyPresetNamesException();
            }
            collection.add(string);
        }
        List configurePresetNames = (List)destination$iv$iv;
        Iterable $this$groupingBy$iv = configurePresetNames;
        boolean $i$f$groupingBy = false;
        Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<String, String>($this$groupingBy$iv){
            final /* synthetic */ Iterable $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            @NotNull
            public Iterator<String> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                String it = (String)element;
                boolean bl = false;
                return var2_2;
            }
        }));
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map2 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : map2.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            boolean bl3 = false;
            if (!(it > 1)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Set duplicates = ((Map)result$iv).keySet();
        Collection collection = duplicates;
        boolean bl4 = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new SchemaWithDuplicateNamesException(CollectionsKt.toList((Iterable)duplicates));
        }
    }
}

