/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.CMakeTargetToConfigProvider;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.ui.CidrEnvironmentVariablesComponent;
import com.jetbrains.cidr.ui.CidrProgramParametersPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeBuildConfigurationHelper
extends CidrBuildConfigurationHelper<CMakeConfiguration, CMakeTarget> {
    private static final Key<Map<BuildTargetData, ConfigurationTypeBase>> TARGET_TO_CONFIG_TYPE = Key.create((String)"TARGET_TO_CONFIG_TYPE");
    @NotNull
    private final Project myProject;

    @Nls
    @NotNull
    public String getConfigurationTitle() {
        String string = CLionCMakeBundle.message("cmake.profile", new Object[0]);
        if (string == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean allowEditBuildConfiguration() {
        return false;
    }

    public CMakeBuildConfigurationHelper(@NotNull Project project) {
        if (project == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    @NotNull
    public String getProjectName() {
        CMakeModel model = CMakeWorkspace.getInstance(this.myProject).getModel();
        String string = model == null ? "Project" : model.getProjectName();
        if (string == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public CMakeTarget createBuildAllVirtualTarget() {
        HashSet<String> added = new HashSet<String>();
        ArrayList<CMakeConfiguration> allConfigurations = new ArrayList<CMakeConfiguration>();
        for (CMakeTarget target : this.getTargets()) {
            for (CMakeConfiguration config : target.getBuildConfigurations()) {
                if (!added.add(config.getName())) continue;
                allConfigurations.add(config);
            }
        }
        allConfigurations.sort((o1, o2) -> Comparing.compare((int)o1.getProfileId(), (int)o2.getProfileId()));
        return new CMakeTarget(this.getProjectName(), CLionCMakeBundle.message("cmake.all.targets.name", new Object[0]), allConfigurations){

            @Override
            public boolean isExecutable() {
                return false;
            }

            @Override
            @Nullable
            public Icon getIcon() {
                return CMakeTarget.META_TARGET_ICON;
            }
        };
    }

    @NotNull
    public List<CMakeConfiguration> findAllProfileConfigurations() {
        CMakeTarget allTarget = this.createBuildAllVirtualTarget();
        List<CMakeConfiguration> list = allTarget.getBuildConfigurations().stream().map(CMakeConfiguration::getProfileName).distinct().map(profileName -> (CMakeConfiguration)this.findConfiguration(allTarget, (String)profileName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<CMakeTarget> getTargets() {
        List<CMakeTarget> list = CMakeWorkspace.getInstance(this.myProject).getModelTargets();
        if (list == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void mapTargetToConfigurationType() {
        Application application = ApplicationManager.getApplication();
        if (!application.isHeadlessEnvironment() && !application.isUnitTestMode() && application.isDispatchThread()) {
            CidrLog.LOG.error("mapTargetToConfigurationType should not be called from EDT!");
        }
        long start = System.currentTimeMillis();
        List<CMakeTarget> targets = this.getTargets();
        HashMap target2type = new HashMap(targets.size());
        targets.forEach(target -> target2type.put(new BuildTargetData(target.getProjectName(), target.getName()), this.getTargetTypeFromExtensions((CMakeTarget)target)));
        CidrLog.LOG.info("The time taken to discover the test framework from the context:" + (System.currentTimeMillis() - start) + " ms");
        TARGET_TO_CONFIG_TYPE.set((UserDataHolder)this.myProject, target2type);
    }

    @Nullable
    public ConfigurationTypeBase getTargetTypeFromExtensions(@NotNull CMakeTarget target) {
        if (target == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(5);
        }
        for (CMakeTargetToConfigProvider provider2 : CMakeTargetToConfigProvider.EP_NAME.getExtensionList()) {
            ConfigurationTypeBase type = provider2.getConfigTypeByTargetType(target, this);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public CMakeRunConfigurationType getDefaultTargetType(@NotNull CMakeTarget target) {
        Map target2type;
        if (target == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(6);
        }
        if ((target2type = (Map)TARGET_TO_CONFIG_TYPE.get((UserDataHolder)this.myProject)) == null) {
            CidrLog.LOG.warn("Lost target to configuration type mapping");
        } else {
            ConfigurationTypeBase testType = (ConfigurationTypeBase)target2type.get(new BuildTargetData(target.getProjectName(), target.getName()));
            if (testType instanceof CMakeRunConfigurationType) {
                CMakeRunConfigurationType cMakeRunConfigurationType = (CMakeRunConfigurationType)testType;
                if (cMakeRunConfigurationType == null) {
                    CMakeBuildConfigurationHelper.$$$reportNull$$$0(7);
                }
                return cMakeRunConfigurationType;
            }
        }
        CMakeAppRunConfigurationType cMakeAppRunConfigurationType = CMakeAppRunConfigurationType.getInstance();
        if (cMakeAppRunConfigurationType == null) {
            CMakeBuildConfigurationHelper.$$$reportNull$$$0(8);
        }
        return cMakeAppRunConfigurationType;
    }

    @NotNull
    public CommonProgramParametersPanel createCommonPanelForTests() {
        return new CidrProgramParametersPanel(){

            @NotNull
            protected EnvironmentVariablesComponent createEnvironmentVariablesComponent() {
                return new CidrEnvironmentVariablesComponent();
            }

            protected void initComponents() {
                super.initComponents();
                this.myProgramInputRedirectPanel.setVisible(false);
                this.myConsoleOptionsPanel.setVisible(false);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/CMakeBuildConfigurationHelper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTitle";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/CMakeBuildConfigurationHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllProfileConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromExtensions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTargetType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

