/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.external.system.project;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.jetbrains.cidr.cpp.external.system.ClionExternalSystemBundle;
import com.jetbrains.cidr.cpp.external.system.project.CLionExternalLoadNotificationAware;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/external/system/project/CLionExternalLoadNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "Lcom/intellij/openapi/util/Key;", "Companion", "intellij.clion.externalSystem"})
public final class CLionExternalLoadNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
        ProjectRootManager rootManager;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (project.isDisposed()) {
            return null;
        }
        ProjectRootManager projectRootManager = rootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"rootManager");
        VirtualFile virtualFile = projectRootManager.getFileIndex().getContentRootForFile(file);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"rootManager.fileIndex.ge\u2026File(file) ?: return null");
        VirtualFile contentRoot = virtualFile;
        if (Intrinsics.areEqual((Object)contentRoot, (Object)file) && rootManager.getContentRoots().length == 1) {
            return null;
        }
        Iterator iterator = CLionExternalLoadNotificationAware.Companion.getEP_NAME().extensions().iterator();
        while (iterator.hasNext()) {
            CLionExternalLoadNotificationAware notificationAware = (CLionExternalLoadNotificationAware)iterator.next();
            if (!notificationAware.isBuildFile(project, file)) continue;
            VirtualFile virtualFile2 = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"file.parent");
            String string = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.parent.path");
            if (notificationAware.isLinkedProject(project, string)) continue;
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
            panel2.setText(ClionExternalSystemBundle.message("load.project.notification.text", notificationAware.getSystemId().getReadableName()));
            panel2.createActionLabel(ClionExternalSystemBundle.message("load.project.action.text", notificationAware.getSystemId().getReadableName()), new Runnable(notificationAware, project, file){
                final /* synthetic */ CLionExternalLoadNotificationAware $notificationAware;
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $file;

                public final void run() {
                    VirtualFile virtualFile = this.$file.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
                    this.$notificationAware.linkAndLoadProject(this.$project, virtualFile);
                }
                {
                    this.$notificationAware = cLionExternalLoadNotificationAware;
                    this.$project = project;
                    this.$file = virtualFile;
                }
            });
            return panel2;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        KEY = new Key("com.jetbrains.cidr.cpp.external.system.project.CLionExternalLoadNotificationProvider");
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/external/system/project/CLionExternalLoadNotificationProvider$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.clion.externalSystem"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

