/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileGroupByKindStrategy;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileGroupingStrategy;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileRootTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class MemoryProfileTreeDataModel
extends DefaultTreeModel {
    @NotNull
    private final Set<MemoryProfileError> myErrors;
    @NotNull
    private MemoryProfileGroupingStrategy myGroupingStrategy;
    @NotNull
    private final Project myProject;

    public MemoryProfileTreeDataModel(@NotNull String profilerName, @NotNull Project project) {
        if (profilerName == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(1);
        }
        super(new MemoryProfileRootTreeNode(profilerName, project));
        this.myErrors = new LinkedHashSet<MemoryProfileError>();
        this.setDefaultGroupingStrategy();
        this.myProject = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(2);
        }
        return project;
    }

    @NotNull
    public MemoryProfileGroupingStrategy getGroupingStrategy() {
        MemoryProfileGroupingStrategy memoryProfileGroupingStrategy = this.myGroupingStrategy;
        if (memoryProfileGroupingStrategy == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(3);
        }
        return memoryProfileGroupingStrategy;
    }

    public void setGroupingStrategy(@NotNull MemoryProfileGroupingStrategy groupingStrategy) {
        if (groupingStrategy == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(4);
        }
        this.myGroupingStrategy = groupingStrategy;
        this.reGroup();
    }

    public void setDefaultGroupingStrategy() {
        this.setGroupingStrategy(new MemoryProfileGroupByKindStrategy(this));
    }

    @NotNull
    public List<MemoryProfileError> getErrors() {
        List<MemoryProfileError> list = Collections.unmodifiableList(new ArrayList<MemoryProfileError>(this.myErrors));
        if (list == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean hasErrors() {
        return !this.myErrors.isEmpty();
    }

    public boolean retainAll(@NotNull Collection<MemoryProfileError> errors) {
        if (errors == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(6);
        }
        return this.myErrors.retainAll(errors);
    }

    public boolean remove(@NotNull MemoryProfileError error) {
        if (error == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(7);
        }
        return this.myErrors.remove(error);
    }

    public void addError(@NotNull MemoryProfileError error) {
        if (error == null) {
            MemoryProfileTreeDataModel.$$$reportNull$$$0(8);
        }
        if (this.myErrors.add(error)) {
            this.myGroupingStrategy.insertToTree(error);
        }
        if (this.myErrors.size() == 1) {
            this.nodeStructureChanged((TreeNode)this.getRoot());
        }
    }

    private void reGroup() {
        MemoryProfileRootTreeNode rootNode = (MemoryProfileRootTreeNode)this.getRoot();
        rootNode.removeAllChildren();
        for (MemoryProfileError error : this.myErrors) {
            this.myGroupingStrategy.insertToTree(error);
        }
        this.nodeStructureChanged(rootNode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/profiling/MemoryProfileTreeDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingStrategy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/MemoryProfileTreeDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupingStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setGroupingStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

