/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.sanitizers;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileProblemDescription;
import com.jetbrains.cidr.cpp.sanitizers.SanitizersUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SanitizerOutputConsumer
implements Consumer<String> {
    @RegExp
    private static final String ID = "(?:[0-9]+)";
    @RegExp
    private static final String SANITIZER = "[A-Za-z]+Sanitizer";
    private static final Pattern[] BEGIN_PATTERNS = new Pattern[]{Pattern.compile("^((?:==(?:[0-9]+)==)?(?:ERROR|WARNING): [A-Za-z]+Sanitizer:) .*$"), Pattern.compile("^((?:.*) runtime error: )(.*)")};
    private static final Pattern[] END_PATTERNS = new Pattern[]{Pattern.compile("==(?:[0-9]+)==ABORTING"), Pattern.compile("[A-Za-z]+Sanitizer: reported .*"), Pattern.compile("Exiting"), Pattern.compile("SUMMARY: [A-Za-z]+Sanitizer: .*")};
    @NotNull
    private final MemoryProfileTreeDataModel myDataModel;
    @NotNull
    private final CidrToolEnvironment myEnvironment;
    @Nullable
    private final File myWorkingDirectory;
    @NotNull
    private final Project myProject;
    @Nullable
    private MemoryProfileError myCurrentError;
    @NotNull
    private String myPreviousLine;

    public SanitizerOutputConsumer(@NotNull MemoryProfileTreeDataModel dataModel, @NotNull CidrToolEnvironment environment2, @Nullable File workingDirectory, @NotNull Project project) {
        if (dataModel == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(0);
        }
        if (environment2 == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(1);
        }
        if (project == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(2);
        }
        this.myPreviousLine = "";
        this.myDataModel = dataModel;
        this.myEnvironment = environment2;
        this.myWorkingDirectory = workingDirectory;
        this.myProject = project;
    }

    public void consume(@Nullable String line) {
        if (StringUtil.isEmpty((String)line)) {
            return;
        }
        if (this.parseBegin(line) || this.parseEnd(line)) {
            return;
        }
        if (this.myCurrentError == null) {
            return;
        }
        MemoryProfileFrame frame = SanitizersUtil.readFrameFromText(line, this.myEnvironment, this.myWorkingDirectory, this.myProject);
        if (frame != null) {
            MemoryProfileProblemDescription description = this.getProblemDescriptionForFrame();
            description.getStack().pushFrame(frame);
        }
        this.myPreviousLine = line;
    }

    public void finish() {
        if (this.myCurrentError != null) {
            this.addErrorToModel(this.myCurrentError);
            this.myCurrentError = null;
        }
    }

    private MemoryProfileProblemDescription getProblemDescriptionForFrame() {
        List<MemoryProfileProblemDescription> descriptions = this.myCurrentError.getProblemDescriptions();
        if (descriptions.isEmpty()) {
            descriptions.add(new MemoryProfileProblemDescription(this.getProblemText()));
            return descriptions.get(descriptions.size() - 1);
        }
        MemoryProfileProblemDescription description = descriptions.get(descriptions.size() - 1);
        if (StringUtil.isNotEmpty((String)this.myPreviousLine) && SanitizersUtil.readFrameFromText(this.myPreviousLine, this.myEnvironment, this.myWorkingDirectory, this.myProject) != null) {
            return description;
        }
        if (description.hasText() && description.getStack().isEmpty()) {
            return description;
        }
        descriptions.add(new MemoryProfileProblemDescription(this.getProblemText()));
        return descriptions.get(descriptions.size() - 1);
    }

    @NotNull
    private String getProblemText() {
        return StringUtil.startsWithChar((CharSequence)this.myPreviousLine, (char)'=') ? "" : SanitizerOutputConsumer.trimAndCapitalize(this.myPreviousLine);
    }

    private boolean parseBegin(@NotNull String line) {
        if (line == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(3);
        }
        for (Pattern pattern : BEGIN_PATTERNS) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String prefix = matcher.group(1);
            String suffix = line.substring(prefix.length());
            if (this.myCurrentError != null) {
                this.addErrorToModel(this.myCurrentError);
            }
            this.myCurrentError = new MemoryProfileError();
            this.myCurrentError.setCaption(SanitizerOutputConsumer.trimAndCapitalize(suffix));
            return true;
        }
        return false;
    }

    private boolean parseEnd(@NotNull String line) {
        if (line == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(4);
        }
        if (Arrays.stream(END_PATTERNS).anyMatch(pattern -> pattern.matcher(line).find())) {
            if (this.myCurrentError != null) {
                this.addErrorToModel(this.myCurrentError);
                this.myCurrentError = null;
            }
            return true;
        }
        return false;
    }

    private void addErrorToModel(@NotNull MemoryProfileError error) {
        Application application;
        if (error == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(5);
        }
        if ((application = ApplicationManager.getApplication()).isDispatchThread()) {
            this.myDataModel.addError(error);
        } else {
            application.invokeLater(() -> this.myDataModel.addError(error));
        }
    }

    @NotNull
    private static String trimAndCapitalize(@NotNull String str) {
        if (str == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(6);
        }
        String string = StringUtil.capitalize((String)StringUtil.trim((String)str));
        if (string == null) {
            SanitizerOutputConsumer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/sanitizers/SanitizerOutputConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/sanitizers/SanitizerOutputConsumer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "trimAndCapitalize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseBegin";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseEnd";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addErrorToModel";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trimAndCapitalize";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

