/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.sanitizers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SanitizersUtil {
    @NonNls
    public static final String STACK_TRACE_FORMAT_SEPARATOR = "###";
    @NonNls
    public static final String STACK_TRACE_FORMAT = StringUtil.join(Arrays.asList("pc_%p", "func_%f", "file_%s", "line_%l", "obj_%M"), (String)"###");
    public static final Version MIN_CLANG_VERSION = new Version(3, 8, 0);
    public static final Version MIN_APPLE_CLANG_VERSION = new Version(8, 0, 0);
    public static final Version MIN_GCC_VERSION = new Version(5, 0, 0);

    private SanitizersUtil() {
    }

    public static boolean compiledWithSanitizeSwitch(@NotNull CidrRunConfiguration applicableConfiguration) {
        if (applicableConfiguration == null) {
            SanitizersUtil.$$$reportNull$$$0(0);
        }
        return CidrExecutionUtil.compiledWithCompilerSwitches(applicableConfiguration, ContainerUtil.newArrayList((Object[])new String[]{"-fsanitize="}));
    }

    public static boolean compilerSupported(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind languageKind, @NotNull OCCompilerKind compilerKind) {
        if (configuration == null) {
            SanitizersUtil.$$$reportNull$$$0(1);
        }
        if (languageKind == null) {
            SanitizersUtil.$$$reportNull$$$0(2);
        }
        if (compilerKind == null) {
            SanitizersUtil.$$$reportNull$$$0(3);
        }
        if (compilerKind != ClangCompilerKind.INSTANCE && compilerKind != GCCCompilerKind.INSTANCE && compilerKind != ClangClCompilerKind.INSTANCE) {
            return false;
        }
        List defines = configuration.getCompilerSettings(languageKind).getPreprocessorDefines();
        int major = 0;
        int minor = 0;
        if (compilerKind == ClangCompilerKind.INSTANCE || compilerKind == ClangClCompilerKind.INSTANCE) {
            for (String define : defines) {
                if (define.contains("__clang_major__")) {
                    major = SanitizersUtil.parseVersionFromMacro(define);
                    continue;
                }
                if (!define.contains("__clang_minor__")) continue;
                minor = SanitizersUtil.parseVersionFromMacro(define);
            }
            Version version = new Version(major, minor, 0);
            return version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_CLANG_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_CLANG_VERSION.minor)) || version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_APPLE_CLANG_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_APPLE_CLANG_VERSION.minor));
        }
        for (String define : defines) {
            if (define.contains("__GNUC__")) {
                major = SanitizersUtil.parseVersionFromMacro(define);
                continue;
            }
            if (!define.contains("__GNUC_MINOR__")) continue;
            minor = SanitizersUtil.parseVersionFromMacro(define);
        }
        Version version = new Version(major, minor, 0);
        return version.isOrGreaterThan(Integer.valueOf(SanitizersUtil.MIN_GCC_VERSION.major), Integer.valueOf(SanitizersUtil.MIN_GCC_VERSION.minor));
    }

    private static int parseVersionFromMacro(@NotNull String define) {
        List defineParts;
        if (define == null) {
            SanitizersUtil.$$$reportNull$$$0(4);
        }
        return (defineParts = StringUtil.split((String)define, (String)" ")).size() == 3 ? StringUtil.parseInt((String)((String)defineParts.get(2)), (int)0) : 0;
    }

    @Nullable
    public static MemoryProfileFrame readFrameFromText(@NotNull String frameText, @NotNull CidrToolEnvironment environment2, @Nullable File workingDirectory, @NotNull Project project) {
        if (frameText == null) {
            SanitizersUtil.$$$reportNull$$$0(5);
        }
        if (environment2 == null) {
            SanitizersUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            SanitizersUtil.$$$reportNull$$$0(7);
        }
        List frameParts = StringUtil.split((String)frameText, (String)STACK_TRACE_FORMAT_SEPARATOR);
        frameParts.replaceAll(part -> part.trim());
        if (frameParts.size() != 5) {
            return null;
        }
        HashSet emptyValues = ContainerUtil.newHashSet((Object[])new String[]{"<null>", "0", "??", ""});
        MemoryProfileFrame frame = new MemoryProfileFrame();
        for (String part2 : frameParts) {
            String obj;
            if (part2.startsWith("pc_")) {
                String pc = part2.substring("pc_".length());
                if (emptyValues.contains(pc)) continue;
                frame.setInstructionPointer(pc);
                continue;
            }
            if (part2.startsWith("func_")) {
                String function = part2.substring("func_".length());
                if (emptyValues.contains(function)) continue;
                frame.setFunction(function);
                continue;
            }
            if (part2.startsWith("file_")) {
                File localFile;
                String rawFilePath = part2.substring("file_".length());
                File rawFile = new File(rawFilePath);
                String fileName = StringUtil.notNullize((String)rawFile.getName());
                if (!emptyValues.contains(fileName)) {
                    frame.setFile(fileName);
                }
                String directory = null;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    directory = rawFile.getParent();
                } else if (FileUtil.exists((String)rawFilePath)) {
                    directory = StringUtil.notNullize((String)rawFile.getParent());
                } else if (FileUtil.exists((String)environment2.toLocalPath(rawFilePath))) {
                    localFile = new File(environment2.toLocalPath(rawFilePath));
                    directory = StringUtil.notNullize((String)localFile.getParent());
                } else if (FileUtil.exists((String)environment2.toLocalPath(workingDirectory, rawFilePath))) {
                    localFile = new File(environment2.toLocalPath(workingDirectory, rawFilePath));
                    directory = StringUtil.notNullize((String)localFile.getParent());
                } else {
                    GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
                    VirtualFile projectDirFile = (VirtualFile)ApplicationManager.getApplication().runReadAction(() -> {
                        Collection projectDirFiles = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)scope);
                        return (VirtualFile)ContainerUtil.getFirstItem((Collection)projectDirFiles);
                    });
                    if (projectDirFile != null) {
                        directory = StringUtil.notNullize((String)projectDirFile.getParent().getPath());
                    }
                }
                if (!StringUtil.isNotEmpty((String)directory) || emptyValues.contains(directory)) continue;
                frame.setDirectory(directory);
                continue;
            }
            if (part2.startsWith("line_")) {
                String line = part2.substring("line_".length());
                if (emptyValues.contains(line)) continue;
                frame.setLine(line);
                continue;
            }
            if (!part2.startsWith("obj_") || emptyValues.contains(obj = part2.substring("obj_".length()))) continue;
            frame.setBinary(obj);
        }
        return frame;
    }

    @NotNull
    public static String writeFrameToText(@NotNull MemoryProfileFrame frame) {
        if (frame == null) {
            SanitizersUtil.$$$reportNull$$$0(8);
        }
        return SanitizersUtil.writeFrameToText(frame, "");
    }

    @NotNull
    public static String writeFrameToText(@NotNull MemoryProfileFrame frame, @NotNull String emptyValue) {
        if (frame == null) {
            SanitizersUtil.$$$reportNull$$$0(9);
        }
        if (emptyValue == null) {
            SanitizersUtil.$$$reportNull$$$0(10);
        }
        Map placeholderToValueMap = ContainerUtil.newHashMap((Pair)Pair.create((Object)"%p", (Object)StringUtil.notNullize((String)frame.getInstructionPointer(), (String)emptyValue)), (Pair[])new Pair[]{Pair.create((Object)"%f", (Object)StringUtil.notNullize((String)frame.getFunction(), (String)emptyValue)), Pair.create((Object)"%s", (Object)(StringUtil.isNotEmpty((String)frame.getFile()) && StringUtil.isNotEmpty((String)frame.getDirectory()) ? FileUtil.join((String[])new String[]{frame.getDirectory(), frame.getFile()}) : emptyValue)), Pair.create((Object)"%l", (Object)StringUtil.notNullize((String)frame.getLine(), (String)emptyValue)), Pair.create((Object)"%M", (Object)StringUtil.notNullize((String)frame.getBinary(), (String)emptyValue))});
        StringBuilder builder = new StringBuilder(STACK_TRACE_FORMAT);
        for (Map.Entry entry : placeholderToValueMap.entrySet()) {
            int startIndex = builder.indexOf((String)entry.getKey());
            builder.replace(startIndex, startIndex + ((String)entry.getKey()).length(), (String)entry.getValue());
        }
        String string = builder.toString();
        if (string == null) {
            SanitizersUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/sanitizers/SanitizersUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "writeFrameToText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compiledWithSanitizeSwitch";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compilerSupported";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseVersionFromMacro";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFrameFromText";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeFrameToText";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

