/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFile;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.toolchains.CMakeBasedDevEnvironmentChecker;
import com.jetbrains.cidr.cpp.toolchains.CMakeBasedDevEnvironmentCheckerKt;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.DevEnvironment;
import com.jetbrains.cidr.cpp.toolchains.DevEnvironmentChecker;
import com.jetbrains.cidr.cpp.toolchains.DevEnvironmentKt;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CMakeBasedDevEnvironmentChecker;", "Lcom/jetbrains/cidr/cpp/toolchains/DevEnvironmentChecker;", "()V", "checkDevEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/DevEnvironment;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "intellij.clion.cmake"})
public final class CMakeBasedDevEnvironmentChecker
implements DevEnvironmentChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public DevEnvironment checkDevEnvironment(@Nullable CPPEnvironment environment2) {
        boolean bl;
        void cxxCompiler;
        void cCompiler;
        void make;
        void errorExtra;
        void error;
        if (environment2 == null) {
            return DevEnvironmentKt.getEMPTY_DEV_ENVIRONMENT();
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        Ref.ObjectRef objectRef4 = new Ref.ObjectRef();
        objectRef4.element = null;
        Ref.ObjectRef objectRef5 = new Ref.ObjectRef();
        objectRef5.element = null;
        Function2<String, String, Unit> $fun$setError$1 = new Function2<String, String, Unit>((Ref.ObjectRef)error, (Ref.ObjectRef)errorExtra, (Ref.ObjectRef)make, (Ref.ObjectRef)cCompiler, (Ref.ObjectRef)cxxCompiler){
            final /* synthetic */ Ref.ObjectRef $error;
            final /* synthetic */ Ref.ObjectRef $errorExtra;
            final /* synthetic */ Ref.ObjectRef $make;
            final /* synthetic */ Ref.ObjectRef $cCompiler;
            final /* synthetic */ Ref.ObjectRef $cxxCompiler;

            public final void invoke(@Nullable String text, @Nullable String extraText) {
                this.$error.element = text;
                this.$errorExtra.element = extraText;
                this.$make.element = null;
                this.$cCompiler.element = null;
                this.$cxxCompiler.element = null;
            }

            public static /* synthetic */ void invoke$default(checkDevEnvironment.1 var0, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = CLionCMakeBundle.message("cmake.dev.environment.general.error", new Object[0]);
                }
                if ((n & 2) != 0) {
                    string2 = "";
                }
                var0.invoke(string, string2);
            }
            {
                this.$error = objectRef;
                this.$errorExtra = objectRef2;
                this.$make = objectRef3;
                this.$cCompiler = objectRef4;
                this.$cxxCompiler = objectRef5;
                super(2);
            }
        };
        StringBuilder output = new StringBuilder();
        Path projectDir = null;
        try {
            HostMachine hostMachine = environment2.getHostMachine();
            Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
            Object host = hostMachine;
            projectDir = host.createTempDirectory("cmake_check_environment", null);
            Path path = Files.createTempDirectory(projectDir, "_build", new FileAttribute[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirectory(projectDir, \"_build\")");
            Path outputDir = path;
            Files.write(projectDir.resolve("CMakeLists.txt"), (Iterable<? extends CharSequence>)CollectionsKt.listOf((Object)"project(cmake_test_run)\n"), new OpenOption[0]);
            CMakeRunner.CMakeOutput cMakeOutput = CMakeGenerator.runCMakeGenerator(environment2, projectDir, outputDir, (List<String>)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)cMakeOutput, (String)"CMakeGenerator.runCMakeG\u2026, outputDir, emptyList())");
            CMakeRunner.CMakeOutput processOutput = cMakeOutput;
            CharSequence charSequence = processOutput.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"processOutput.diagnostics");
            CMakeBasedDevEnvironmentCheckerKt.access$appendParagraph(output, charSequence);
            CharSequence charSequence2 = processOutput.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"processOutput.output");
            CMakeBasedDevEnvironmentCheckerKt.access$appendParagraph(output, charSequence2);
            if (processOutput.getExitCode() != 0) {
                CharSequence charSequence3 = output;
                boolean bl2 = false;
                if (charSequence3.length() > 0) {
                    output.append("\n");
                }
                output.append(CLionCMakeBundle.message("cmake.dev.environment.error.code", processOutput.getExitCode()));
                checkDevEnvironment.1.invoke$default($fun$setError$1, null, output.toString(), 1, null);
            }
            try {
                CMakeCacheFile cache2 = new CMakeCacheFile(outputDir.resolve("CMakeCache.txt"), "UTF-8");
                make.element = CMakeBasedDevEnvironmentCheckerKt.access$getValueFromCacheFile(cache2, "CMAKE_MAKE_PROGRAM", environment2, outputDir);
                cCompiler.element = CMakeBasedDevEnvironmentCheckerKt.access$getValueFromCacheFile(cache2, "CMAKE_C_COMPILER", environment2, outputDir);
                cxxCompiler.element = CMakeBasedDevEnvironmentCheckerKt.access$getValueFromCacheFile(cache2, "CMAKE_CXX_COMPILER", environment2, outputDir);
                if (environment2.isMinGW()) {
                    CPPToolSet toolSet;
                    CMakeVariable sh;
                    if (((String)make.element == null || (String)cCompiler.element == null || (String)cxxCompiler.element == null) && (sh = cache2.getVariable("CMAKE_SH")) != null && !sh.isNotFound() && environment2.resolveEnvPathToLocalExecutable((File)outputDir.toFile(), (String)sh.getValue()).isResolvedToExecutable) {
                        checkDevEnvironment.1.invoke$default($fun$setError$1, CLionCMakeBundle.message("cmake.dev.environment.mingw.sh.value.path.error", sh.getValue()), null, 2, null);
                    }
                    CPPToolSet cPPToolSet = environment2.getToolSet();
                    Intrinsics.checkNotNullExpressionValue((Object)cPPToolSet, (String)"environment.toolSet");
                    CPPToolSet cPPToolSet2 = toolSet = cPPToolSet;
                    if (cPPToolSet2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.cpp.toolchains.MinGW");
                    }
                    if (!((MinGW)cPPToolSet2).isMinGW64() && !((MinGW)toolSet).getSubFile("bin/zlib1.dll").exists()) {
                        checkDevEnvironment.1.invoke$default($fun$setError$1, CLionCMakeBundle.message("cmake.dev.environment.mingw.zlib.not.found", new Object[0]), null, 2, null);
                    }
                }
            }
            catch (CMakeException cache2) {
                // empty catch block
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            if (ExceptionUtil.causedBy((Throwable)e, CMakeException.class) || ExceptionUtil.causedBy((Throwable)e, IOException.class)) {
                CPPLog.LOG.debug((Throwable)e);
            } else {
                CPPLog.LOG.error((Throwable)e);
            }
            CPPLog.LOG.info("CMake execute result\n" + output);
            String string = ExceptionUtil.getMessage((Throwable)e);
            if (string != null) {
                String string2 = string;
                bl = false;
                boolean it = false;
                String it2 = string2;
                boolean bl3 = false;
                String string3 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                CMakeBasedDevEnvironmentCheckerKt.access$appendParagraph(output, string3);
            }
            if (!(e instanceof CMakeException)) {
                String string4 = ExceptionUtil.getThrowableText((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ExceptionUtil.getThrowableText(e)");
                CMakeBasedDevEnvironmentCheckerKt.access$appendParagraph(output, string4);
            }
            checkDevEnvironment.1.invoke$default($fun$setError$1, null, output.toString(), 1, null);
        }
        finally {
            Path path = projectDir;
            if (path != null) {
                Path path2 = path;
                boolean bl4 = false;
                bl = false;
                Path it = path2;
                boolean bl5 = false;
                PathKt.delete$default((Path)projectDir, (boolean)false, (int)1, null);
            }
        }
        return new DevEnvironment((String)make.element, (String)cCompiler.element, (String)cxxCompiler.element, (String)error.element, (String)errorExtra.element);
    }
}

