/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.valgrind.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionProfilingBundle;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileDataKeys;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileErrorCaptionTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValgrindSuppressAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ValgrindSuppressAction.class);

    public void update(@NotNull AnActionEvent e) {
        MemoryProfileError errorToSuppress;
        if (e == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(0);
        }
        DataContext context = e.getDataContext();
        MemoryProfileTreeDataModel treeDataModel = (MemoryProfileTreeDataModel)MemoryProfileDataKeys.TREE_MODEL.getData(context);
        MemoryProfileTreeNode selectedNode = (MemoryProfileTreeNode)MemoryProfileDataKeys.SELECTED_NODE.getData(context);
        MemoryProfileError memoryProfileError = errorToSuppress = selectedNode instanceof MemoryProfileErrorCaptionTreeNode ? ((MemoryProfileErrorCaptionTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        MemoryProfileError errorToSuppress;
        if (e == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(1);
        }
        MemoryProfileTreeNode selectedNode = (MemoryProfileTreeNode)e.getData(MemoryProfileDataKeys.SELECTED_NODE);
        MemoryProfileTreeDataModel treeDataModel = (MemoryProfileTreeDataModel)e.getData(MemoryProfileDataKeys.TREE_MODEL);
        MemoryProfileError memoryProfileError = errorToSuppress = selectedNode instanceof MemoryProfileErrorCaptionTreeNode ? ((MemoryProfileErrorCaptionTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            LOG.warn("Failed to apply ValgrindSuppressAction, because either MemoryProfileTreeDataModel or MemoryProfileError is null");
            return;
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor.setTitle(CLionProfilingBundle.message("valgrind.suppress.action.title", new Object[0]));
        descriptor.setDescription(CLionProfilingBundle.message("valgrind.suppress.action.description", new Object[0]));
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, null, null, files -> {
            String suppressionFilePath = ((VirtualFile)files.get(0)).getPath();
            if (!FileUtil.exists((String)suppressionFilePath)) {
                LOG.warn("Failed to append suppression, because file does not exist");
                return;
            }
            try {
                FileUtil.appendToFile((File)new File(suppressionFilePath), (String)ValgrindSuppressAction.getSuppression(errorToSuppress));
                treeDataModel.remove(errorToSuppress);
                MemoryProfileUtil.removeNode(selectedNode, treeDataModel);
            }
            catch (IOException exc) {
                LOG.warn("Failed to append suppression: " + exc);
            }
        });
    }

    @NotNull
    private static String getSuppression(@NotNull MemoryProfileError error) {
        if (error == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(2);
        }
        String suppression = error.getSuppression();
        MemoryProfileFrame innermostFrame = MemoryProfileUtil.getInnermostNavigatableStackFrame(error);
        String suppressionName = innermostFrame == null ? "Suppression" : (StringUtil.isNotEmpty((String)innermostFrame.getFunction()) ? innermostFrame.getFunction() : innermostFrame.getBinary());
        @NonNls String insertSuppressionNameHolder = "<insert_a_suppression_name_here>";
        suppression = suppression.replace("<insert_a_suppression_name_here>", suppressionName);
        suppression = suppression.trim();
        String string = "\n" + suppression + "\n";
        if (string == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/valgrind/actions/ValgrindSuppressAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/valgrind/actions/ValgrindSuppressAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppression";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

