/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.coverage;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.cidr.execution.coverage.CidrBranchCoverageFileData;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import com.jetbrains.cidr.execution.coverage.CidrProjectData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 -2\u00020\u0001:\u0002-.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014JB\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001cH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\bH\u0003J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0007J\u001a\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0010H\u0007J\"\u0010(\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020#2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0010H\u0007J\u0012\u0010*\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010,\u001a\u00020\u001aH\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator;", "Lcom/intellij/coverage/SimpleCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myFileBranchCoverageInfos", "", "", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$FileBranchCoverageInfo;", "annotate", "", "contentRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "dataManager", "Lcom/intellij/coverage/CoverageDataManager;", "data", "Lcom/intellij/rt/coverage/data/ProjectData;", "annotator", "Lcom/intellij/coverage/SimpleCoverageAnnotator$Annotator;", "collectBranchCoverage", "directory", "index", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "trackTestFolders", "", "visitedDirs", "", "collectFileBranchCoverage", "file", "suiteBundle", "getBranchCoverageInformationString", "info", "getDirBranchCoverageInformationString", "Lcom/intellij/psi/PsiDirectory;", "manager", "getFileBranchCoverageInformationString", "psiFile", "Lcom/intellij/psi/PsiFile;", "getSummaryCoverageInformationString", "currentSuite", "onSuiteChosen", "newSuite", "shouldCollectCoverageInsideLibraryDirs", "Companion", "FileBranchCoverageInfo", "intellij.cidr.coverage"})
public final class CidrCoverageAnnotator
extends SimpleCoverageAnnotator {
    private final Map<String, FileBranchCoverageInfo> myFileBranchCoverageInfos;
    @NotNull
    public static final Companion Companion = new Companion(null);

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return false;
    }

    public void onSuiteChosen(@Nullable CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileBranchCoverageInfos.clear();
    }

    @Nls
    @Nullable
    public final String getFileBranchCoverageInformationString(@NotNull PsiFile psiFile, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"psiFile.virtualFile");
        VirtualFile file = virtualFile.getCanonicalFile();
        if (file == null) {
            file = psiFile.getVirtualFile();
        }
        boolean bl = file != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile2 = file;
        Intrinsics.checkNotNull((Object)virtualFile2);
        String string = CidrCoverageAnnotator.access$normalizeFilePath$s-481081054(virtualFile2.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeFilePath(file!!.path)");
        String path = string;
        FileBranchCoverageInfo coverageInfo = this.myFileBranchCoverageInfos.get(path);
        if (coverageInfo == null || coverageInfo.getTotalBranchesCount() == 0) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.getCoveredBranchesCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return this.getBranchCoverageInformationString(coverageInfo);
    }

    @Nls
    @Nullable
    public final String getDirBranchCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            return null;
        }
        VirtualFile virtualFile = directory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"directory.virtualFile");
        FileBranchCoverageInfo coverageInfo = this.myFileBranchCoverageInfos.get(CidrCoverageAnnotator.access$normalizeFilePath$s-481081054(virtualFile.getPath()));
        if (coverageInfo == null || coverageInfo.getTotalBranchesCount() == 0) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.getCoveredBranchesCount() > 0 ? CoverageBundle.message((String)"coverage.view.text.covered", (Object[])new Object[0]) : null;
        }
        return this.getBranchCoverageInformationString(coverageInfo);
    }

    @Nls
    @Nullable
    public final String getSummaryCoverageInformationString(@NotNull PsiDirectory directory, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)currentSuite, (String)"currentSuite");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        String coverageInformation = super.getDirCoverageInformationString(directory, currentSuite, manager);
        String branchCoverageInformation = this.getDirBranchCoverageInformationString(directory, manager);
        if (coverageInformation != null && branchCoverageInformation != null) {
            return coverageInformation + ", " + branchCoverageInformation;
        }
        return coverageInformation;
    }

    protected void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data, @NotNull Project project, @Nullable SimpleCoverageAnnotator.Annotator annotator) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.annotate(contentRoot, suite, dataManager, data, project, annotator);
        if (contentRoot.isValid() && CidrCoverageSettings.Companion.getInstance().getBranchCoverage()) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
            ProjectFileIndex index = projectFileIndex;
            boolean trackTestFolders = suite.isTrackTestFolders();
            this.collectBranchCoverage(contentRoot, dataManager, index, trackTestFolders, suite, new HashSet());
        }
    }

    private final FileBranchCoverageInfo collectBranchCoverage(VirtualFile directory, CoverageDataManager dataManager, ProjectFileIndex index, boolean trackTestFolders, CoverageSuitesBundle suite, Set<? super VirtualFile> visitedDirs) {
        VirtualFile[] children2;
        if (!index.isInContent(directory) && !index.isInLibrary(directory)) {
            return null;
        }
        if (visitedDirs.contains(directory)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && index.isInLibrary(directory)) {
            return null;
        }
        visitedDirs.add((VirtualFile)directory);
        boolean isInTestSrcContent = TestSourcesFilter.isTestSources((VirtualFile)directory, (Project)this.getProject());
        if (!trackTestFolders && isInTestSrcContent) {
            return null;
        }
        FileBranchCoverageInfo branchCoverageInfo = new FileBranchCoverageInfo(0, 0);
        VirtualFile[] virtualFileArray = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(new Computable(directory){
            final /* synthetic */ VirtualFile $directory;

            public final VirtualFile[] compute() {
                return this.$directory.getChildren();
            }
            {
                this.$directory = virtualFile;
            }
        });
        if (virtualFileArray == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"dataManager.doInReadActi\u2026hildren }) ?: return null");
        for (VirtualFile fileOrDir : children2 = virtualFileArray) {
            FileBranchCoverageInfo fileBranchCoverageInfo;
            if (fileOrDir.isDirectory()) {
                FileBranchCoverageInfo childBranchCoverageInfo = this.collectBranchCoverage(fileOrDir, dataManager, index, trackTestFolders, suite, visitedDirs);
                if (childBranchCoverageInfo == null) continue;
                FileBranchCoverageInfo fileBranchCoverageInfo2 = branchCoverageInfo;
                fileBranchCoverageInfo2.setTotalBranchesCount(fileBranchCoverageInfo2.getTotalBranchesCount() + childBranchCoverageInfo.getTotalBranchesCount());
                FileBranchCoverageInfo fileBranchCoverageInfo3 = branchCoverageInfo;
                fileBranchCoverageInfo3.setCoveredBranchesCount(fileBranchCoverageInfo3.getCoveredBranchesCount() + childBranchCoverageInfo.getCoveredBranchesCount());
                continue;
            }
            if (!suite.getCoverageEngine().coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileBranchCoverageInfo = this.collectFileBranchCoverage(fileOrDir, dataManager, suite)) == null) continue;
            FileBranchCoverageInfo fileBranchCoverageInfo4 = branchCoverageInfo;
            fileBranchCoverageInfo4.setTotalBranchesCount(fileBranchCoverageInfo4.getTotalBranchesCount() + fileBranchCoverageInfo.getTotalBranchesCount());
            FileBranchCoverageInfo fileBranchCoverageInfo5 = branchCoverageInfo;
            fileBranchCoverageInfo5.setCoveredBranchesCount(fileBranchCoverageInfo5.getCoveredBranchesCount() + fileBranchCoverageInfo.getCoveredBranchesCount());
        }
        String string = CidrCoverageAnnotator.access$normalizeFilePath$s-481081054(directory.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeFilePath(directory.path)");
        this.myFileBranchCoverageInfos.put(string, branchCoverageInfo);
        return branchCoverageInfo;
    }

    private final FileBranchCoverageInfo collectFileBranchCoverage(VirtualFile file, CoverageDataManager dataManager, CoverageSuitesBundle suiteBundle) {
        for (CoverageSuite suite : suiteBundle.getSuites()) {
            CidrProjectData projectData;
            if ((CidrProjectData)suite.getCoverageData(dataManager) == null) {
                continue;
            }
            String string = FileUtil.toCanonicalPath((String)file.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toCanonicalPath(file.path)");
            CidrBranchCoverageFileData branchCoverageData = projectData.getBranchCoverageData(string);
            if (branchCoverageData == null) continue;
            FileBranchCoverageInfo branchCoverageInfo = new FileBranchCoverageInfo(branchCoverageData.getTotalBranches(), branchCoverageData.getCoveredBranches());
            String string2 = CidrCoverageAnnotator.access$normalizeFilePath$s-481081054(file.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalizeFilePath(file.path)");
            this.myFileBranchCoverageInfos.put(string2, branchCoverageInfo);
            return branchCoverageInfo;
        }
        return null;
    }

    @Nls
    private final String getBranchCoverageInformationString(FileBranchCoverageInfo info) {
        String string = CidrCoverageBundle.message("coverage.view.branches.covered", CidrCoverageAnnotator.access$calcPercent$s-481081054(info.getCoveredBranchesCount(), info.getTotalBranchesCount()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CidrCoverageBundle.messa\u2026info.totalBranchesCount))");
        return string;
    }

    public CidrCoverageAnnotator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myFileBranchCoverageInfos = new HashMap();
    }

    public static final /* synthetic */ String access$normalizeFilePath$s-481081054(String p0) {
        return SimpleCoverageAnnotator.normalizeFilePath((String)p0);
    }

    public static final /* synthetic */ int access$calcPercent$s-481081054(int p0, int p1) {
        return SimpleCoverageAnnotator.calcPercent((int)p0, (int)p1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$FileBranchCoverageInfo;", "", "totalBranchesCount", "", "coveredBranchesCount", "(II)V", "getCoveredBranchesCount", "()I", "setCoveredBranchesCount", "(I)V", "getTotalBranchesCount", "setTotalBranchesCount", "intellij.cidr.coverage"})
    public static final class FileBranchCoverageInfo {
        private int totalBranchesCount;
        private int coveredBranchesCount;

        public final int getTotalBranchesCount() {
            return this.totalBranchesCount;
        }

        public final void setTotalBranchesCount(int n) {
            this.totalBranchesCount = n;
        }

        public final int getCoveredBranchesCount() {
            return this.coveredBranchesCount;
        }

        public final void setCoveredBranchesCount(int n) {
            this.coveredBranchesCount = n;
        }

        public FileBranchCoverageInfo(int totalBranchesCount, int coveredBranchesCount) {
            this.totalBranchesCount = totalBranchesCount;
            this.coveredBranchesCount = coveredBranchesCount;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.coverage"})
    public static final class Companion {
        @NotNull
        public final CidrCoverageAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(CidrCoverageAnnotator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (CidrCoverageAnnotator)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

