/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCompletionProvider;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCMakeCaseSensitiveCompletionProvider
extends AbstractCMakeCompletionProvider {
    private final List<String> myVariants;
    private final boolean myBoldCompletion;
    private final boolean myPutCaretInsideParentheses;

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords) {
        this(completionWords, false);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion) {
        this(completionWords, boldCompletion, true);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(String[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(Arrays.asList(completionWords), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(IElementType[] completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this(ContainerUtil.map((Object[])completionWords, type -> type.toString()), boldCompletion, putCaretInsideParentheses);
    }

    public AbstractCMakeCaseSensitiveCompletionProvider(List<String> completionWords, boolean boldCompletion, boolean putCaretInsideParentheses) {
        this.myVariants = completionWords;
        this.myBoldCompletion = boldCompletion;
        this.myPutCaretInsideParentheses = putCaretInsideParentheses;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(2);
        }
        CMakeCodeStyleSettings settings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)parameters.getOriginalFile(), CMakeCodeStyleSettings.class);
        Case keywordCase = Case.resolveByValue(AbstractCMakeCaseSensitiveCompletionProvider.getCaseVariableValue(settings));
        String stringToComplete = parameters.getPosition().getText().replace("IntellijIdeaRulezzz", "");
        boolean toUpper = keywordCase == Case.TO_UPPER || keywordCase == Case.DO_NOT_CHANGE && stringToComplete.length() > 0 && Character.isUpperCase(stringToComplete.charAt(0));
        result.caseInsensitive().addAllElements((Iterable)ContainerUtil.map(this.myVariants, s -> CMakeCompletionUtils.createStandardCommandItem(toUpper ? StringUtil.toUpperCase((String)s) : s, this.myBoldCompletion, this.myPutCaretInsideParentheses, Collections.emptyList())));
    }

    private static int getCaseVariableValue(@NotNull CMakeCodeStyleSettings settings) {
        if (settings == null) {
            AbstractCMakeCaseSensitiveCompletionProvider.$$$reportNull$$$0(3);
        }
        return settings.FORCE_COMMANDS_CASE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cmake/completion/contributors/providers/AbstractCMakeCaseSensitiveCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCaseVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

