/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeResolveLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeCommandReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference {
    private static final boolean USE_CACHE = true;

    public CMakeCommandReference(PsiElement element, TextRange textRange) {
        super(element, textRange);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CMakeCommandReference.$$$reportNull$$$0(0);
        }
        if (CMakeCommandReferenceHelper.commandNamesEqualByText(element, this.myElement)) {
            CMakeArgument cMakeArgument;
            if (CMakeCommandReferenceHelper.isCommandCall(element)) {
                return true;
            }
            if (CMakeCommandReferenceHelper.isCommandDefinition(element) && (cMakeArgument = CMakeCommandReferenceHelper.getCMakeArgument(element)).isCommandDefinitionName()) {
                return true;
            }
        }
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache cache2 = ResolveCache.getInstance((Project)this.getElement().getProject());
        ResolveResult[] resolveResultArray = cache2.resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode1) -> reference.multiResolveWithoutCaching(), false, incompleteCode);
        if (resolveResultArray == null) {
            CMakeCommandReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    protected ResolveResult[] multiResolveWithoutCaching() {
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        this.fillCommandsFromProject(commands, true);
        return commands.toArray(ResolveResult.EMPTY_ARRAY);
    }

    private List<ResolveResult> fillCommandReferencesFromModule(@NotNull List<ResolveResult> commands, @NotNull PsiFile containingFile, @Nullable Module module, boolean checkForTextEquality) {
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            CMakeCommandReference.$$$reportNull$$$0(3);
        }
        if (module != null) {
            List virtualFiles;
            if (checkForTextEquality) {
                CacheManager cacheManager = CacheManager.getInstance((Project)module.getProject());
                virtualFiles = ContainerUtil.filter((Object[])cacheManager.getVirtualFilesWithWord(this.myElement.getText(), (short)255, module.getModuleWithLibrariesScope(), true), file -> FileTypeRegistry.getInstance().isFileOfType(file, CMakeListsFileType.INSTANCE));
            } else {
                virtualFiles = new ArrayList();
                ArrayList finalVirtualFiles = virtualFiles;
                FileTypeIndex.processFiles((FileType)CMakeListsFileType.INSTANCE, file -> {
                    finalVirtualFiles.add(file);
                    return true;
                }, (GlobalSearchScope)module.getModuleWithLibrariesScope());
            }
            virtualFiles.sort((o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
            for (VirtualFile virtualFile : virtualFiles) {
                PsiFile psiFile = this.myElement.getManager().findFile(virtualFile);
                if (containingFile.equals(psiFile)) continue;
                this.fillCommandsFromFile(commands, psiFile, checkForTextEquality);
            }
        }
        return commands;
    }

    private List<ResolveResult> fillCommandsFromFile(final @NotNull List<ResolveResult> commands, @Nullable PsiFile file, final boolean checkForTextEquality) {
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(4);
        }
        PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                boolean isCommandDefinition;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (isCommandDefinition = element instanceof CMakeRoutine) {
                    boolean isCommandDefinitionName;
                    CMakeArgument argumentElement = ((CMakeRoutine)element).getFirstArgument();
                    boolean argumentExists = argumentElement != null;
                    boolean bl = isCommandDefinitionName = argumentExists && argumentElement.isCommandDefinitionName();
                    if (isCommandDefinitionName) {
                        if (checkForTextEquality) {
                            boolean isOurCommandName;
                            CMakeLiteral cMakeLiteral = argumentElement.getCMakeLiteral();
                            boolean bl2 = isOurCommandName = cMakeLiteral != null && cMakeLiteral.getText().equalsIgnoreCase(CMakeCommandReference.this.myElement.getText());
                            if (isOurCommandName) {
                                commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                                return true;
                            }
                        } else {
                            commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                            return true;
                        }
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cmake/resolve/CMakeCommandReference$1", "execute"));
            }
        });
        return commands;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public Object @NotNull [] getVariants() {
        List<ResolveResult> commands = this.collectCommandsFromProjectOrCache();
        Object[] completionForCommandDefinition = this.getCompletionForCommandDefinition();
        if (completionForCommandDefinition != null) {
            if (completionForCommandDefinition == null) {
                CMakeCommandReference.$$$reportNull$$$0(5);
            }
            return completionForCommandDefinition;
        }
        return this.getCompletion(commands);
    }

    @NotNull
    private List<ResolveResult> collectCommandsFromProjectOrCache() {
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        ResolveCache cache2 = ResolveCache.getInstance((Project)this.getElement().getProject());
        ContainerUtil.addAll(commands, (Object[])cache2.resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode) -> {
            ArrayList<ResolveResult> cacheResults = new ArrayList<ResolveResult>();
            this.fillCommandsFromProject(cacheResults, false);
            return cacheResults.toArray(ResolveResult.EMPTY_ARRAY);
        }, false, false));
        ArrayList<ResolveResult> arrayList = commands;
        if (arrayList == null) {
            CMakeCommandReference.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private Object @Nullable [] getCompletionForCommandDefinition() {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        if (this.myElement instanceof CMakeArgument) {
            if (((CMakeArgument)this.myElement).isCommandDefinitionName()) {
                return LookupElement.EMPTY_ARRAY;
            }
            if (((CMakeArgument)this.myElement).isEndCommandDefinitionName()) {
                CMakeArgument commandDefinitionName = ((CMakeArgument)this.myElement).getCommandDefinitionName();
                if (commandDefinitionName != null) {
                    variants.add(CMakeCompletionUtils.createCommandItem(commandDefinitionName.getText(), this.myElement.getContainingFile().getName(), Collections.emptyList(), true, false));
                }
                return variants.toArray();
            }
        }
        return null;
    }

    private Object @NotNull [] getCompletion(List<ResolveResult> commands) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        for (ResolveResult command : commands) {
            PsiElement psiElement = command.getElement();
            CMakeResolveLog.LOG.assertTrue(psiElement instanceof CMakeArgument);
            CMakeArgument cMakeArgument = (CMakeArgument)psiElement;
            CMakeLiteral cMakeLiteral = cMakeArgument.getCMakeLiteral();
            CMakeResolveLog.LOG.assertTrue(cMakeLiteral != null);
            String textToComplete = CMakeCompletionUtils.convertCommandToProperCase(psiElement.getContainingFile(), cMakeLiteral.getText());
            List<CMakeArgument> argumentList = cMakeArgument.getParentCommandArguments().getCMakeArgumentList();
            List<CMakeArgument> argumentsInCompletion = argumentList.subList(1, argumentList.size());
            String filename = CMakeFileLocationUtil.getLocationInFile(psiElement, false);
            boolean addParentheses = !(this.myElement instanceof CMakeArgument);
            variants.add(CMakeCompletionUtils.createCommandItem(textToComplete, filename, argumentsInCompletion, cMakeArgument.isFunctionName(), addParentheses));
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            CMakeCommandReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    private void fillCommandsFromProject(@NotNull List<ResolveResult> commands, boolean checkForTextEquality) {
        PsiFile currentFile;
        if (commands == null) {
            CMakeCommandReference.$$$reportNull$$$0(8);
        }
        if ((currentFile = this.myElement.getContainingFile()) != null) {
            this.fillCommandsFromFile(commands, currentFile, checkForTextEquality);
            VirtualFile virtualFile = currentFile.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = currentFile.getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null) {
                Module module = ProjectRootManager.getInstance((Project)this.myElement.getProject()).getFileIndex().getModuleForFile(virtualFile);
                this.fillCommandReferencesFromModule(commands, currentFile, module, checkForTextEquality);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PsiReferenceBase base = (PsiReferenceBase)o;
        if (this.getElement() != null ? !this.getElement().equals(base.getElement()) : base.getElement() != null) {
            return false;
        }
        return !(this.getRangeInElement() != null ? !this.getRangeInElement().equals((Object)base.getRangeInElement()) : base.getRangeInElement() != null);
    }

    public int hashCode() {
        int result = this.getElement() != null ? this.getElement().hashCode() : 0;
        result = 31 * result + (this.getRangeInElement() != null ? this.getRangeInElement().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/resolve/CMakeCommandReference";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/resolve/CMakeCommandReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommandsFromProjectOrCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandReferencesFromModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandsFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandsFromProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

