/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.spellchecker;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.spellchecker.tokenizer.TokenizerBase;
import com.intellij.util.Consumer;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSpellCheckingStrategy
extends SpellcheckingStrategy {
    private static final TokenSet PLAIN_ID_HOLDERS = TokenSet.create((IElementType[])new IElementType[]{CMakeTokenTypes.ID, CMakeTokenTypes.LITERAL});
    private static final NotNullLazyKey<TokenizerBase<PsiElement>, Project> PREFIX_TOKENIZER = NotNullLazyKey.create((String)"PREFIX_TOKENIZER", project -> new TokenizerBase((Splitter)new PlainTextSplitterWithPrefixes((Project)project)));

    @NotNull
    public Tokenizer getTokenizer(@NotNull PsiElement element) {
        ASTNode node2;
        if (element == null) {
            CMakeSpellCheckingStrategy.$$$reportNull$$$0(0);
        }
        if ((node2 = element.getNode()) != null && PLAIN_ID_HOLDERS.contains(node2.getElementType())) {
            Tokenizer tokenizer = (Tokenizer)PREFIX_TOKENIZER.getValue((UserDataHolder)element.getProject());
            if (tokenizer == null) {
                CMakeSpellCheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        if (element instanceof PsiComment) {
            if (SuppressionUtil.isSuppressionComment((PsiElement)element)) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    CMakeSpellCheckingStrategy.$$$reportNull$$$0(2);
                }
                return tokenizer;
            }
            Tokenizer tokenizer = (Tokenizer)PREFIX_TOKENIZER.getValue((UserDataHolder)element.getProject());
            if (tokenizer == null) {
                CMakeSpellCheckingStrategy.$$$reportNull$$$0(3);
            }
            return tokenizer;
        }
        Tokenizer tokenizer = EMPTY_TOKENIZER;
        if (tokenizer == null) {
            CMakeSpellCheckingStrategy.$$$reportNull$$$0(4);
        }
        return tokenizer;
    }

    private static String getWord(@NotNull String text, int start, int end) {
        if (text == null) {
            CMakeSpellCheckingStrategy.$$$reportNull$$$0(5);
        }
        return StringUtil.toLowerCase((String)text.substring(start, end));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/spellchecker/CMakeSpellCheckingStrategy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/spellchecker/CMakeSpellCheckingStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTokenizer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PlainTextSplitterWithPrefixes
    extends PlainTextSplitter {
        @NonNls
        private static final String[] KNOWN_WORD_PREFIXES = new String[]{"asm", "bin", "bit", "boost", "build", "code", "cpp", "cxx", "doc", "debug", "dbg", "dll", "exe", "gnu", "gcc", "help", "jit", "lib", "link", "llvm", "ms", "native", "non", "ocaml", "obj", "pkg", "python", "release", "rel", "root", "src", "xc"};
        @NonNls
        private static final String KNOWN_SINGLE_CHAR_SWITCHER_PREFIXES = "bigfrtlmXWD";
        private static final Pattern EXTENDED_WORD_AND_HASH_NOT_SPECIAL = Pattern.compile("(&[^;]+;)|((0x[0-9]*)?\\p{L}+'?\\p{L}[_\\p{L}]*)");
        private static final Splitter HASH_NOT_SPECIAL_TEXT_SPLITTER = new TextSplitter(){

            @NotNull
            @Contract(pure=true)
            protected Pattern getExtendedWordAndSpecial() {
                Pattern pattern = EXTENDED_WORD_AND_HASH_NOT_SPECIAL;
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pattern;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cmake/spellchecker/CMakeSpellCheckingStrategy$PlainTextSplitterWithPrefixes$1", "getExtendedWordAndSpecial"));
            }
        };
        private final SpellCheckerManager mySpeller;

        PlainTextSplitterWithPrefixes(Project project) {
            this.mySpeller = SpellCheckerManager.getInstance((Project)project);
        }

        public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
            if (range == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(1);
            }
            super.split(text, range, text == null ? consumer : this.wrapConsumer(text, consumer));
        }

        @NotNull
        @Contract(pure=true)
        private Consumer<TextRange> wrapConsumer(@NotNull String text, @NotNull Consumer<TextRange> consumer) {
            if (text == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(3);
            }
            Consumer consumer2 = range -> {
                int start = range.getStartOffset();
                int end = range.getEndOffset();
                assert (!ApplicationManager.getApplication().isDispatchThread());
                String word = CMakeSpellCheckingStrategy.getWord(text, start, end);
                if (!this.mySpeller.hasProblem(word)) {
                    return;
                }
                if (!(start <= 0 || text.charAt(start - 1) != '-' || start - 2 >= 0 && "\"' \t\n,".indexOf(text.charAt(start - 2)) < 0 || KNOWN_SINGLE_CHAR_SWITCHER_PREFIXES.indexOf(text.charAt(start)) < 0 || this.mySpeller.hasProblem(word = CMakeSpellCheckingStrategy.getWord(text, ++start, end)))) {
                    return;
                }
                for (int i = 0; i < KNOWN_WORD_PREFIXES.length; ++i) {
                    String prefix = KNOWN_WORD_PREFIXES[i];
                    if (!StringUtil.startsWith((CharSequence)word, (CharSequence)prefix)) continue;
                    if ((start += prefix.length()) >= end) break;
                    word = CMakeSpellCheckingStrategy.getWord(text, start, end);
                    if (!this.mySpeller.hasProblem(word)) {
                        return;
                    }
                    i = 0;
                }
                consumer.consume((Object)TextRange.create((int)start, (int)end));
            };
            if (consumer2 == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(4);
            }
            return consumer2;
        }

        @NotNull
        protected Splitter getTextSplitter() {
            Splitter splitter = HASH_NOT_SPECIAL_TEXT_SPLITTER;
            if (splitter == null) {
                PlainTextSplitterWithPrefixes.$$$reportNull$$$0(5);
            }
            return splitter;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cmake/spellchecker/CMakeSpellCheckingStrategy$PlainTextSplitterWithPrefixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cmake/spellchecker/CMakeSpellCheckingStrategy$PlainTextSplitterWithPrefixes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapConsumer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "split";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapConsumer";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

