/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileLexerAdapter;
import com.jetbrains.lang.makefile.MakefileParser;
import com.jetbrains.lang.makefile.MakefileStubFileElementType;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\r\u0010\u0017\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/lang/makefile/MakefileParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "()V", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/jetbrains/lang/makefile/MakefileFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "createLexer", "Lcom/jetbrains/lang/makefile/MakefileLexerAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/jetbrains/lang/makefile/MakefileParser;", "getCommentTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getFileNodeType", "Lcom/jetbrains/lang/makefile/MakefileStubFileElementType;", "getStringLiteralElements", "getWhitespaceTokens", "Companion", "intellij.makefile"})
public final class MakefileParserDefinition
implements ParserDefinition {
    @NotNull
    private static final TokenSet WHITE_SPACES;
    @NotNull
    private static final TokenSet COMMENTS;
    @NotNull
    private static final MakefileStubFileElementType FILE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public MakefileStubFileElementType getFileNodeType() {
        return FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.EMPTY");
        return tokenSet;
    }

    @NotNull
    public MakefileFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return new MakefileFile(viewProvider);
    }

    @NotNull
    public MakefileParser createParser(@Nullable Project project) {
        return new MakefileParser();
    }

    @NotNull
    public MakefileLexerAdapter createLexer(@Nullable Project project) {
        return new MakefileLexerAdapter();
    }

    @NotNull
    public PsiElement createElement(@Nullable ASTNode node) {
        PsiElement psiElement = MakefileTypes.Factory.createElement(node);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"MakefileTypes.Factory.createElement(node)");
        return psiElement;
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(TokenType.WHITE_SPACE)");
        WHITE_SPACES = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{MakefileTypes.COMMENT, MakefileTypes.DOC_COMMENT});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"TokenSet.create(Makefile\u2026akefileTypes.DOC_COMMENT)");
        COMMENTS = tokenSet2;
        FILE = new MakefileStubFileElementType();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/lang/makefile/MakefileParserDefinition$Companion;", "", "()V", "COMMENTS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "getCOMMENTS", "()Lcom/intellij/psi/tree/TokenSet;", "FILE", "Lcom/jetbrains/lang/makefile/MakefileStubFileElementType;", "getFILE", "()Lcom/jetbrains/lang/makefile/MakefileStubFileElementType;", "WHITE_SPACES", "getWHITE_SPACES", "intellij.makefile"})
    public static final class Companion {
        @NotNull
        public final TokenSet getWHITE_SPACES() {
            return WHITE_SPACES;
        }

        @NotNull
        public final TokenSet getCOMMENTS() {
            return COMMENTS;
        }

        @NotNull
        public final MakefileStubFileElementType getFILE() {
            return FILE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

