/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001d\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkDestination", "", "findOurFlavor", "Ljava/awt/datatransfer/DataFlavor;", "flavors", "", "([Ljava/awt/datatransfer/DataFlavor;)Ljava/awt/datatransfer/DataFlavor;", "update", "Companion", "intellij.database.impl"})
public final class CreateDataSourceFromSettings
extends DumbAwareAction {
    @Deprecated
    @NotNull
    private static final String MIME_SUFFIX;
    @NotNull
    private static final Companion Companion;

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || !this.checkDestination(e)) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = false;
        Transferable t = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (t != null) {
            if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
                enabled = true;
            } else {
                DataFlavor[] dataFlavorArray = t.getTransferDataFlavors();
                Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"t.transferDataFlavors");
                if (this.findOurFlavor(dataFlavorArray) != null) {
                    enabled = true;
                } else if (!t.isDataFlavorSupported(DataFlavor.imageFlavor) && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    enabled = true;
                }
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(enabled);
    }

    private final boolean checkDestination(AnActionEvent e) {
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.place");
        if (StringsKt.endsWith$default((String)string, (String)"DatabaseViewToolbar", (boolean)false, (int)2, null)) {
            return true;
        }
        String string2 = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.place");
        if (StringsKt.endsWith$default((String)string2, (String)"DatabaseViewPopup", (boolean)false, (int)2, null)) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"e.dataContext");
            return DatabaseViewTreeFun.isSelectedOneGroup(dataContext);
        }
        return false;
    }

    private final DataFlavor findOurFlavor(DataFlavor[] flavors) {
        DataFlavor dataFlavor;
        block1: {
            DataFlavor[] $this$firstOrNull$iv = flavors;
            boolean $i$f$firstOrNull = false;
            DataFlavor[] dataFlavorArray = $this$firstOrNull$iv;
            int n = dataFlavorArray.length;
            for (int j = 0; j < n; ++j) {
                DataFlavor element$iv;
                DataFlavor it2 = element$iv = dataFlavorArray[j];
                boolean bl = false;
                String string = it2.getMimeType();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.mimeType");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)MIME_SUFFIX, (boolean)false, (int)2, null)) continue;
                dataFlavor = element$iv;
                break block1;
            }
            dataFlavor = null;
        }
        return dataFlavor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        DataSourceSettingsHelperKt.importDataSourcesFromClipboard(project2);
    }

    static {
        Companion = new Companion(null);
        MIME_SUFFIX = "class=" + Reflection.getOrCreateKotlinClass(DataSourceSettingsCapsule.class).getQualifiedName();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/actions/CreateDataSourceFromSettings$Companion;", "", "()V", "MIME_SUFFIX", "", "getMIME_SUFFIX", "()Ljava/lang/String;", "intellij.database.impl"})
    private static final class Companion {
        @NotNull
        public final String getMIME_SUFFIX() {
            return MIME_SUFFIX;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

