/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.DataSourceSettingsHelperKt;
import com.intellij.database.dataSource.DataSourceSerializedSettingsTransferable;
import com.intellij.database.dataSource.DataSourceSettingsCapsule;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012\u001a\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0000\u001a\u001c\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0000\u001a\u0018\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a \u0010\u001c\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a#\u0010\u001c\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\u0006\u0010\b\u001a\u00020\tH\u0003\u00a2\u0006\u0002\b \u001a\u0018\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\n\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010#\u001a\u0004\u0018\u00010$\u001a(\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\r0&j\b\u0012\u0004\u0012\u00020\r`'2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0013\u0010)\u001a\u00020\u000b2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b*\u001a&\u0010+\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010(\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\u0001\u001a&\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010(\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010/\u001a\u0002002\u0006\u0010(\u001a\u00020\u0001\u001a\u001e\u00101\u001a\u00020\u000b2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u0001032\u0006\u0010(\u001a\u00020\u0001H\u0000\u001a\u001c\u00104\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000106\u001a\"\u00107\u001a\b\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0.\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"DATA_SOURCE_RAW_SETTINGS_BEGIN", "", "DATA_SOURCE_RAW_SETTINGS_END", "DATA_SOURCE_SETTINGS_BEGIN", "DATA_SOURCE_SETTINGS_END", "DATA_SOURCE_SETTINGS_HEADER", "addSuffixIfNeeded", "originalName", "project", "Lcom/intellij/openapi/project/Project;", "applyDataSource", "", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "createDataSourceFromSettings", "buffer", "doCopyDataSourceSettings", "dss", "", "exportDataSourcesSettings", "exportSettings", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "finishTestDataSource", "dataSource", "storage", "Lcom/intellij/database/access/DatabaseCredentials;", "focusOnDataSources", "dataSources", "dbDataSources", "Lcom/intellij/database/psi/DbDataSource;", "focusOnDbDataSources", "getDataSourceNames", "getTextFromClipboard", "getTransferableFromClipboard", "Ljava/awt/datatransfer/Transferable;", "importDataSourceFromText", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "text", "importDataSourcesFromClipboard", "Lorg/jetbrains/annotations/Nullable;", "importDataSourcesFromTextDirectly", "groupPath", "importDataSourcesFromTextViaDialog", "", "isDataSourceSettings", "", "putExportedSettingsIntoTheClipboard", "ids", "", "removeDataSources", "dsIds", "", "showDataSourcesConfigurationDialog", "intellij.database.impl"})
public final class DataSourceSettingsHelperKt {
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_HEADER = "#DataSourceSettings#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_BEGIN = "#BEGIN#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_END = "#END#";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_BEGIN = "<data-source source=\"LOCAL\" ";
    @NotNull
    public static final String DATA_SOURCE_RAW_SETTINGS_END = "</data-source>";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String doCopyDataSourceSettings(@NotNull Collection<? extends LocalDataSource> dss2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(dss2, (String)"dss");
        String string = DataSourceSettingsHelperKt.exportDataSourcesSettings(dss2);
        if (string == null) {
            return null;
        }
        String text2 = string;
        Iterable $this$map$iv = dss2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2;
            void it2;
            LocalDataSource localDataSource = (LocalDataSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getUniqueId(), (String)"it.uniqueId");
            collection.add(string2);
        }
        DataSourceSettingsHelperKt.putExportedSettingsIntoTheClipboard((List)destination$iv$iv, text2);
        return text2;
    }

    @Nullable
    public static final String exportDataSourcesSettings(@NotNull Collection<? extends LocalDataSource> dss2) {
        Intrinsics.checkNotNullParameter(dss2, (String)"dss");
        StringBuilder b2 = new StringBuilder(1024);
        b2.append(DATA_SOURCE_SETTINGS_HEADER).append('\n');
        for (LocalDataSource charSequence : dss2) {
            DataSourceSettingsHelperKt.exportSettings(charSequence, b2);
        }
        CharSequence charSequence = b2;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        return b2.toString();
    }

    public static final void putExportedSettingsIntoTheClipboard(@NotNull Iterable<String> ids, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Collection $this$toTypedArray$iv = CollectionsKt.toList(ids);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        DataSourceSerializedSettingsTransferable transferHandle = new DataSourceSerializedSettingsTransferable(stringArray, text2);
        CopyPasteManager.getInstance().setContents((Transferable)transferHandle);
    }

    public static final void exportSettings(@NotNull LocalDataSource ds, @NotNull StringBuilder b2) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        b2.append("#LocalDataSource: ").append(ds.getName()).append('\n');
        StringBuffer text2 = ds.copySettings(null);
        b2.append(DATA_SOURCE_SETTINGS_BEGIN).append('\n');
        b2.append(text2);
        if (b2.charAt(b2.length() - 1) != '\n') {
            b2.append('\n');
        }
        b2.append(DATA_SOURCE_SETTINGS_END).append('\n').append('\n');
    }

    public static final void importDataSourcesFromClipboard(@NotNull Project project) {
        String string;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                string = DataSourceSettingsHelperKt.getTextFromClipboard();
                if (string == null) break block5;
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                if (string != null) break block6;
            }
            return;
        }
        String text2 = string;
        if (DataSourceSettingsHelperKt.isDataSourceSettings(text2)) {
            DataSourceSettingsHelperKt.importDataSourcesFromTextViaDialog(text2, project, "");
        }
    }

    private static final String getTextFromClipboard() {
        Transferable t = DataSourceSettingsHelperKt.getTransferableFromClipboard();
        if (t == null) {
            return null;
        }
        if (t.isDataFlavorSupported(DataSourceSerializedSettingsTransferable.FLAVOR)) {
            Object object = t.getTransferData(DataSourceSerializedSettingsTransferable.FLAVOR);
            if (!(object instanceof DataSourceSettingsCapsule)) {
                object = null;
            }
            DataSourceSettingsCapsule dataSourceSettingsCapsule = (DataSourceSettingsCapsule)object;
            return dataSourceSettingsCapsule != null ? dataSourceSettingsCapsule.content : null;
        }
        if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            Object object = t.getTransferData(DataFlavor.stringFlavor);
            if (!(object instanceof String)) {
                object = null;
            }
            return (String)object;
        }
        return null;
    }

    @Nullable
    public static final Transferable getTransferableFromClipboard() {
        CopyPasteManager cpm;
        CopyPasteManager copyPasteManager = cpm = CopyPasteManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)copyPasteManager, (String)"cpm");
        return copyPasteManager.getContents();
    }

    public static final boolean isDataSourceSettings(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_SETTINGS_HEADER, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Collection<LocalDataSource> importDataSourcesFromTextDirectly(@NotNull String text2, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources = DataSourceSettingsHelperKt.importDataSourceFromText(text2, project);
        Iterator<LocalDataSource> iterator = dataSources.iterator();
        while (iterator.hasNext()) {
            LocalDataSource dataSource2;
            LocalDataSource localDataSource = dataSource2 = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"dataSource");
            localDataSource.setGroupName(groupPath);
            DataSourceSettingsHelperKt.applyDataSource(dataSource2, project);
        }
        DataSourceSettingsHelperKt.focusOnDataSources((Collection<? extends LocalDataSource>)dataSources, project);
        return dataSources;
    }

    @NotNull
    public static final List<DbDataSource> importDataSourcesFromTextViaDialog(@NotNull String text2, @NotNull Project project, @Nullable String groupPath) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ArrayList<LocalDataSource> dataSources = DataSourceSettingsHelperKt.importDataSourceFromText(text2, project);
        if (Intrinsics.areEqual((Object)groupPath, (Object)"") ^ true) {
            Iterator<LocalDataSource> iterator = dataSources.iterator();
            while (iterator.hasNext()) {
                LocalDataSource dataSource2;
                LocalDataSource localDataSource = dataSource2 = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"dataSource");
                localDataSource.setGroupName(groupPath);
            }
        }
        return DataSourceSettingsHelperKt.showDataSourcesConfigurationDialog(project, (List<? extends LocalDataSource>)dataSources);
    }

    private static final ArrayList<LocalDataSource> importDataSourceFromText(String text2, Project project) {
        ArrayList<LocalDataSource> dataSources = new ArrayList<LocalDataSource>();
        int p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)0, (boolean)false, (int)6, null);
        if (p1 != -1) {
            int q1;
            int p2;
            while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_END, (int)(q1 = p1 + DATA_SOURCE_SETTINGS_BEGIN.length()), (boolean)false, (int)4, null)) >= 0) {
                p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)(p2 + DATA_SOURCE_SETTINGS_END.length()), (boolean)false, (int)4, null);
                Collection collection = dataSources;
                Object object = text2;
                boolean bl = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = string.substring(q1, p2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = DataSourceSettingsHelperKt.createDataSourceFromSettings(string2, project);
                bl = false;
                collection.add(object);
            }
        } else {
            int p2;
            p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (int)0, (boolean)false, (int)6, null);
            while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_END, (int)p1, (boolean)false, (int)4, null)) >= 0) {
                int q2 = p2 + DATA_SOURCE_RAW_SETTINGS_END.length();
                Collection collection = dataSources;
                Object object = text2;
                boolean bl = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string.substring(p1, q2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = DataSourceSettingsHelperKt.createDataSourceFromSettings(string3, project);
                bl = false;
                collection.add(object);
                p1 = StringsKt.indexOf$default((CharSequence)text2, (String)DATA_SOURCE_RAW_SETTINGS_BEGIN, (int)q2, (boolean)false, (int)4, null);
            }
        }
        return dataSources;
    }

    @NotNull
    public static final List<DbDataSource> showDataSourcesConfigurationDialog(@NotNull Project project, @NotNull List<? extends LocalDataSource> dataSources) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
        if (dataSources.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List<DbDataSource> list = DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(project), CollectionsKt.first(dataSources), null, (Consumer<? super DatabaseConfigEditor>)new Consumer(dataSources){
            final /* synthetic */ List $dataSources;

            public final void consume(DatabaseConfigEditor editor) {
                for (LocalDataSource dataSource2 : this.$dataSources) {
                    DatabaseConfigEditor databaseConfigEditor = editor;
                    Intrinsics.checkNotNullExpressionValue((Object)databaseConfigEditor, (String)"editor");
                    DatabaseCredentials databaseCredentials = databaseConfigEditor.getSecretService();
                    Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"editor.secretService");
                    DataSourceSettingsHelperKt.access$finishTestDataSource(dataSource2, databaseCredentials);
                    editor.onCreated(dataSource2);
                }
            }
            {
                this.$dataSources = list;
            }
        });
        Intrinsics.checkNotNullExpressionValue(list, (String)"DataSourceManagerDialog.\u2026dataSource)\n      }\n    }");
        List<DbDataSource> dss2 = list;
        DataSourceSettingsHelperKt.focusOnDbDataSources((Collection<? extends DbDataSource>)dss2, project);
        return dss2;
    }

    public static final void applyDataSource(@NotNull LocalDataSource ds, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        DatabaseCredentials databaseCredentials = DatabaseCredentials.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"DatabaseCredentials.getInstance()");
        DataSourceSettingsHelperKt.finishTestDataSource(ds, databaseCredentials);
        DataSourceStorage.getProjectStorage(project).addDataSource(ds);
    }

    private static final void finishTestDataSource(LocalDataSource dataSource2, DatabaseCredentials storage) {
        block0: {
            String string = dataSource2.getAdditionalProperties().remove("test-user-password");
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it2 = string2;
            boolean bl3 = false;
            storage.setPassword(dataSource2, new OneTimeString(it2));
            dataSource2.setPasswordStorage(LocalDataSource.Storage.PERSIST);
            dataSource2.setAutoSynchronize(true);
        }
    }

    private static final LocalDataSource createDataSourceFromSettings(String buffer, Project project) {
        LocalDataSource localDataSource = LocalDataSource.createDataSourceFromSettings(buffer, project, false);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"LocalDataSource.createDa\u2026s(buffer, project, false)");
        LocalDataSource localDataSource2 = localDataSource;
        boolean bl = false;
        boolean bl2 = false;
        LocalDataSource $this$apply = localDataSource2;
        boolean bl3 = false;
        $this$apply.resolveDriver();
        if ($this$apply.getDatabaseDriver() == null) {
            $this$apply.ensureDriverConfigured();
        }
        $this$apply.setGlobal(project == null);
        String string = $this$apply.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        $this$apply.setName(DataSourceSettingsHelperKt.addSuffixIfNeeded(string, project));
        return localDataSource2;
    }

    private static final String addSuffixIfNeeded(String originalName, Project project) {
        Collection<String> existentNames = DataSourceSettingsHelperKt.getDataSourceNames(project);
        String name = originalName;
        int k = 1;
        while (existentNames.contains(name)) {
            name = originalName + " [" + ++k + ']';
        }
        return name;
    }

    private static final Collection<String> getDataSourceNames(Project project) {
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        Intrinsics.checkNotNullExpressionValue((Object)dataSourceStorage, (String)"DataSourceStorage.getProjectStorage(project)");
        List list = dataSourceStorage.getDataSourcesImpl().map((Function)getDataSourceNames.1.INSTANCE).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DataSourceStorage.getPro\u2026{ it.name }\n    .toList()");
        return list;
    }

    private static final void focusOnDataSources(Collection<? extends LocalDataSource> dataSources, Project project) {
        Project project2 = project;
        if (project2 == null) {
            DefaultProjectFactory defaultProjectFactory = DefaultProjectFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)defaultProjectFactory, (String)"DefaultProjectFactory.getInstance()");
            project2 = defaultProjectFactory.getDefaultProject();
        }
        Project p2 = project2;
        ArrayList dbDataSources = new ArrayList(dataSources.size());
        for (LocalDataSource localDataSource : dataSources) {
            DbDataSource x = DbImplUtil.getDbDataSource(p2, localDataSource);
            if (x == null) continue;
            Collection collection = dbDataSources;
            boolean bl = false;
            collection.add(x);
        }
        if (dbDataSources.isEmpty()) {
            return;
        }
        Collection collection = dbDataSources;
        Project project3 = p2;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"p");
        DataSourceSettingsHelperKt.focusOnDbDataSources(collection, project3);
    }

    @JvmName(name="focusOnDbDataSources")
    private static final void focusOnDbDataSources(Collection<? extends DbDataSource> dbDataSources, Project project) {
        Application application = ApplicationManager.getApplication();
        application.invokeLater(new Runnable(application, project, dbDataSources){
            final /* synthetic */ Application $application;
            final /* synthetic */ Project $project;
            final /* synthetic */ Collection $dbDataSources;

            public final void run() {
                this.$application.runReadAction(new Runnable(this){
                    final /* synthetic */ focusOnDataSources.1 this$0;

                    public final void run() {
                        DatabaseView.refreshViewAndSelect(this.this$0.$project, this.this$0.$dbDataSources);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$application = application;
                this.$project = project;
                this.$dbDataSources = collection;
            }
        });
    }

    public static final void removeDataSources(@NotNull Project project, @NotNull Set<String> dsIds) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(dsIds, (String)"dsIds");
        DataSourceStorage dataSourceStorage = DataSourceStorage.getProjectStorage(project);
        ArrayList dsToRemove = new ArrayList(dsIds.size());
        for (String id : dsIds) {
            LocalDataSource ds = dataSourceStorage.getDataSourceById(id);
            if (!(ds instanceof LocalDataSource)) continue;
            Collection collection = dsToRemove;
            boolean bl = false;
            collection.add(ds);
        }
        for (LocalDataSource ds : dsToRemove) {
            dataSourceStorage.removeDataSource(ds);
        }
    }

    public static final /* synthetic */ void access$finishTestDataSource(LocalDataSource dataSource2, DatabaseCredentials storage) {
        DataSourceSettingsHelperKt.finishTestDataSource(dataSource2, storage);
    }
}

