/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.database.Dbms;
import com.intellij.database.actions.DbActionUtils;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.liveTemplates.macros.DbContextMacroBase;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "update", "", "Companion", "DbContextTemplateAction", "intellij.database.impl"})
public final class DbContextTemplateGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(DbContextTemplateGroup.Companion.getTargetObject(e) != null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        DbElement dbElement = DbContextTemplateGroup.Companion.getTargetObject(e);
        if (dbElement == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        DbElement target = dbElement;
        Dbms dbms = target.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"target.dbms");
        TemplateContextType templateContextType = DbContextTemplateGroup.Companion.getContextType(dbms);
        if (templateContextType == null) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        TemplateContextType contextType = templateContextType;
        List templates = DbContextTemplateGroup.Companion.getApplicableTemplates(contextType);
        if (templates.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
            return AnAction.EMPTY_ARRAY;
        }
        int n = templates.size() + 1;
        AnAction[] anActionArray = new AnAction[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = n2++;
            AnAction[] anActionArray2 = anActionArray;
            boolean bl = false;
            Object var13_13 = null;
            anActionArray2[n4] = var13_13;
        }
        AnAction[] result2 = anActionArray;
        result2[0] = (AnAction)Separator.getInstance();
        n = 0;
        for (TemplateImpl template : (Iterable)templates) {
            void i2;
            result2[i2 + true] = (AnAction)new DbContextTemplateAction(template);
            ++i2;
        }
        return result2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0003J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$DbContextTemplateAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "template", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "(Lcom/intellij/codeInsight/template/impl/TemplateImpl;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPresentableText", "", "update", "intellij.database.impl"})
    private static final class DbContextTemplateAction
    extends DumbAwareAction {
        private final TemplateImpl template;

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            String string = this.template.getDescription();
            if (string == null) {
                string = "";
            }
            presentation.setText(StringUtil.capitalize((String)string));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DbElement dbElement = Companion.getTargetObject(e);
            if (dbElement == null) {
                return;
            }
            DbElement target = dbElement;
            Project project = target.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"target.project");
            Project project2 = project;
            boolean preferExisting = DatabaseSettings.getSettings().contextTemplateTarget == DatabaseSettings.ContextTemplateTarget.APPEND_TO_EXISTING_CONSOLE;
            Editor editor = DbActionUtils.findOrCreateEditor(target, preferExisting);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            DbActionUtils.moveCaretToEnd(editor2);
            editor2.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), (Object)new SoftReference((Object)target));
            TemplateEditingAdapter listener2 = new TemplateEditingAdapter(editor2){
                final /* synthetic */ Editor $editor;

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    Intrinsics.checkNotNullParameter((Object)template, (String)"template");
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }

                public void templateCancelled(@Nullable Template template) {
                    this.$editor.putUserData(DbContextMacroBase.Companion.getDB_CONTEXT_KEY(), null);
                }
                {
                    this.$editor = $captured_local_variable$0;
                }
            };
            TemplateManager.getInstance((Project)project2).startTemplate(editor2, (Template)this.template, (TemplateEditingListener)listener2);
        }

        @NlsSafe
        private final String getPresentableText(TemplateImpl template) {
            String string = template.getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"template.string");
            return string;
        }

        public DbContextTemplateAction(@NotNull TemplateImpl template) {
            Intrinsics.checkNotNullParameter((Object)template, (String)"template");
            this.template = template;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/actions/DbContextTemplateGroup$Companion;", "", "()V", "getApplicableTemplates", "", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "contextType", "Lcom/intellij/codeInsight/template/TemplateContextType;", "getContextType", "dbms", "Lcom/intellij/database/Dbms;", "getTargetObject", "Lcom/intellij/database/psi/DbElement;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<TemplateImpl> getApplicableTemplates(TemplateContextType contextType) {
            void $this$filterTo$iv$iv;
            Object v3;
            block7: {
                TemplateSettings templateSettings = TemplateSettings.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)templateSettings, (String)"TemplateSettings.getInstance()");
                List list = templateSettings.getTemplateGroups();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"TemplateSettings.getInstance().templateGroups");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TemplateGroup it2 = (TemplateGroup)element$iv;
                    boolean bl = false;
                    TemplateGroup templateGroup = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)templateGroup, (String)"it");
                    if (!Intrinsics.areEqual((Object)templateGroup.getName(), (Object)"SQL")) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            TemplateGroup templateGroup = v3;
            if (templateGroup == null) {
                return CollectionsKt.emptyList();
            }
            TemplateGroup group = templateGroup;
            List list = group.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"group.elements");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                TemplateImpl template;
                block8: {
                    template = (TemplateImpl)element$iv$iv;
                    boolean bl2 = false;
                    TemplateImpl templateImpl = template;
                    Intrinsics.checkNotNullExpressionValue((Object)templateImpl, (String)"template");
                    ArrayList arrayList = templateImpl.getVariables();
                    Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"template.variables");
                    Iterable $this$any$iv = arrayList;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Variable it3 = (Variable)element$iv;
                            boolean bl3 = false;
                            Variable variable = it3;
                            Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"it");
                            Expression expression = variable.getExpression();
                            if (!(expression instanceof MacroCallNode)) {
                                expression = null;
                            }
                            MacroCallNode macroCallNode = (MacroCallNode)expression;
                            if (!((macroCallNode != null ? macroCallNode.getMacro() : null) instanceof DbContextMacroBase)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!(bl && template.getTemplateContext().isEnabled(contextType))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final TemplateContextType getContextType(Dbms dbms) {
            TemplateContextType templateContextType;
            Object v3;
            TemplateContextType it2;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            List allTemplates;
            block3: {
                ExtensionPointName extensionPointName = TemplateContextType.EP_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)extensionPointName, (String)"TemplateContextType.EP_NAME");
                List list = extensionPointName.getExtensionList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"TemplateContextType.EP_NAME.extensionList");
                allTemplates = list;
                $this$firstOrNull$iv = allTemplates;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it2 = (TemplateContextType)element$iv;
                    boolean bl = false;
                    TemplateContextType templateContextType2 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)templateContextType2, (String)"it");
                    if (!Intrinsics.areEqual((Object)templateContextType2.getContextId(), (Object)("SQL_STATEMENT_" + dbms.getName()))) continue;
                    v3 = element$iv;
                    break block3;
                }
                v3 = null;
            }
            if ((templateContextType = (TemplateContextType)v3) == null) {
                Object v6;
                block4: {
                    $this$firstOrNull$iv = allTemplates;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it2 = (TemplateContextType)element$iv;
                        boolean bl = false;
                        TemplateContextType templateContextType3 = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)templateContextType3, (String)"it");
                        if (!Intrinsics.areEqual((Object)templateContextType3.getContextId(), (Object)"SQL_STATEMENT")) continue;
                        v6 = element$iv;
                        break block4;
                    }
                    v6 = null;
                }
                templateContextType = v6;
            }
            return templateContextType;
        }

        private final DbElement getTargetObject(AnActionEvent e) {
            DasTable gridTable;
            DasTable dasTable;
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = DataGridUtil.getDataGrid(e.getDataContext());
            if (dataGrid2 != null) {
                DataGrid dataGrid3 = dataGrid2;
                boolean bl = false;
                boolean bl2 = false;
                DataGrid it2 = dataGrid3;
                boolean bl3 = false;
                dasTable = DataGridUtil.getDatabaseTable(it2);
            } else {
                dasTable = gridTable = null;
            }
            if (gridTable instanceof DbElement) {
                return (DbElement)((Object)gridTable);
            }
            DatabaseView databaseView = (DatabaseView)((Object)e.getData(DatabaseView.DATABASE_VIEW_KEY));
            if (databaseView == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((Object)databaseView), (String)"e.getData(DatabaseView.D\u2026_VIEW_KEY) ?: return null");
            DatabaseView databaseView2 = databaseView;
            Object[] objectArray = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)databaseView2);
            Object object = objectArray != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : null;
            if (!(object instanceof DbElement)) {
                object = null;
            }
            return (DbElement)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

