/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceAction;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J.\u0010\u0013\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "chooseSqlDataSource", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "elements", "", "Lcom/intellij/database/psi/DbElement;", "compatibleSqlDataSources", "Lcom/intellij/sql/database/SqlDataSource;", "createSqlDataSourceAndDump", "sqlDs", "dump", "instantiateSqlDataSource", "isCompatible", "", "update", "LayoutAction", "intellij.database.impl"})
public final class DumpToDdlDataSourceAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Map byDs = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
        byDs.entrySet().removeIf(update.1.INSTANCE);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(byDs.size() == 1);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void ds;
        Map.Entry entry;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Map byDs = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
        Map.Entry entry2 = (Map.Entry)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)byDs.entrySet()), (Function1)actionPerformed.1.INSTANCE));
        if (entry2 == null) {
            return;
        }
        Map.Entry entry3 = entry = entry2;
        boolean bl = false;
        DasDataSource dasDataSource = (DasDataSource)entry3.getKey();
        entry3 = entry;
        bl = false;
        List elements = (List)entry3.getValue();
        void v2 = ds;
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.dataSource.LocalDataSource");
        }
        LocalDataSource cfr_ignored_0 = (LocalDataSource)v2;
        SqlDataSource sqlDs2 = (SqlDataSource)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)byDs.keySet()), (Function1)actionPerformed.sqlDs.1.INSTANCE), (Function1)((Function1)new Function1<SqlDataSource, Boolean>(this, (DasDataSource)ds){
            final /* synthetic */ DumpToDdlDataSourceAction this$0;
            final /* synthetic */ DasDataSource $ds;

            public final boolean invoke(@NotNull SqlDataSource it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return DumpToDdlDataSourceAction.access$isCompatible(this.this$0, it2, (LocalDataSource)this.$ds);
            }
            {
                this.this$0 = dumpToDdlDataSourceAction;
                this.$ds = dasDataSource;
                super(1);
            }
        })));
        if (sqlDs2 != null) {
            this.dump(project2, (LocalDataSource)ds, elements, sqlDs2);
        } else {
            this.chooseSqlDataSource(project2, e, (LocalDataSource)ds, elements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dump(Project project, LocalDataSource ds, List<? extends DbElement> elements, SqlDataSource sqlDs2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        DasModel dasModel = ds.getModel();
        if (!(dasModel instanceof BasicModel)) {
            dasModel = null;
        }
        BasicModel basicModel = (BasicModel)dasModel;
        if (basicModel == null) {
            return;
        }
        BasicModel model = basicModel;
        Iterable iterable = elements;
        TreePattern treePattern = ds.getIntrospectionScope();
        BasicModel basicModel2 = model;
        SqlDataSource sqlDataSource = sqlDs2;
        Project project2 = project;
        boolean $i$f$mapNotNull = false;
        void var8_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            BasicElement basicElement;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbElement it2 = (DbElement)element$iv$iv;
            boolean bl2 = false;
            if (DbImplUtil.getMaybeBasicElement(it2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            BasicElement it$iv$iv = basicElement;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        DumpToDdlDataSourceActionKt.dump(project2, sqlDataSource, basicModel2, treePattern, list, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void chooseSqlDataSource(Project project, AnActionEvent e, LocalDataSource ds, List<? extends DbElement> elements) {
        Object object;
        JBPopupFactory jBPopupFactory;
        SqlDataSource newOne;
        block5: {
            List<SqlDataSource> sqlDataSources;
            block4: {
                void it2;
                newOne = this.instantiateSqlDataSource(project);
                sqlDataSources = this.compatibleSqlDataSources(project, ds);
                if (sqlDataSources.isEmpty() && newOne != null) {
                    this.createSqlDataSourceAndDump(project, ds, elements, newOne);
                    return;
                }
                jBPopupFactory = JBPopupFactory.getInstance();
                object = newOne;
                if (object == null) break block4;
                SqlDataSource sqlDataSource = object;
                boolean bl = false;
                boolean bl2 = false;
                SqlDataSource sqlDataSource2 = sqlDataSource;
                JBPopupFactory jBPopupFactory2 = jBPopupFactory;
                boolean bl3 = false;
                List list = CollectionsKt.plus((Collection)sqlDataSources, (Object)it2);
                jBPopupFactory = jBPopupFactory2;
                object = list;
                if (object != null) break block5;
            }
            object = sqlDataSources;
        }
        jBPopupFactory.createPopupChooserBuilder((List)object).setRenderer((ListCellRenderer)new ColoredListCellRenderer<SqlDataSource>(newOne){
            final /* synthetic */ SqlDataSource $newOne;

            protected void customizeCellRenderer(@NotNull JList<? extends SqlDataSource> list, @Nullable SqlDataSource value2, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                if (Intrinsics.areEqual((Object)value2, (Object)this.$newOne)) {
                    this.setIcon(AllIcons.General.Add);
                    this.append(DatabaseBundle.message("create.ddl.data.source", new Object[0]));
                } else {
                    SqlDataSource sqlDataSource = value2;
                    this.setIcon(sqlDataSource != null ? sqlDataSource.getIcon(0) : null);
                    Object object = value2;
                    if (object == null || (object = object.getName()) == null) {
                        object = "";
                    }
                    this.append((String)object);
                }
            }
            {
                this.$newOne = $captured_local_variable$0;
            }
        }).setSelectionMode(0).setItemChosenCallback(new Consumer(this, newOne, project, ds, elements){
            final /* synthetic */ DumpToDdlDataSourceAction this$0;
            final /* synthetic */ SqlDataSource $newOne;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalDataSource $ds;
            final /* synthetic */ List $elements;

            public final void consume(SqlDataSource it2) {
                if (Intrinsics.areEqual((Object)it2, (Object)this.$newOne) && this.$newOne != null) {
                    DumpToDdlDataSourceAction.access$createSqlDataSourceAndDump(this.this$0, this.$project, this.$ds, this.$elements, this.$newOne);
                } else {
                    SqlDataSource sqlDataSource = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlDataSource, (String)"it");
                    DumpToDdlDataSourceAction.access$dump(this.this$0, this.$project, this.$ds, this.$elements, sqlDataSource);
                }
            }
            {
                this.this$0 = dumpToDdlDataSourceAction;
                this.$newOne = sqlDataSource;
                this.$project = project;
                this.$ds = localDataSource;
                this.$elements = list;
            }
        }).createPopup().showInBestPositionFor(e.getDataContext());
    }

    private final void createSqlDataSourceAndDump(Project project, LocalDataSource ds, List<? extends DbElement> elements, SqlDataSource sqlDs2) {
        sqlDs2.setName(ds.getName() + " (DDL)");
        sqlDs2.setCodeStyleName(ds.getCodeStyleName());
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project);
        if (dbPsiFacade == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.psi.DbPsiFacadeImpl");
        }
        DbPsiFacadeImpl facade = (DbPsiFacadeImpl)dbPsiFacade;
        DasDataSource dasDataSource = (DasDataSource)sqlDs2;
        DataSourceManager<SqlDataSource> dataSourceManager = DataSourceManager.byDataSource(project, SqlDataSource.class);
        Intrinsics.checkNotNull(dataSourceManager);
        DbDataSource dbDataSource = facade.createDataSourceWrapperElement(dasDataSource, dataSourceManager);
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"facade.createDataSourceW\u2026ataSource::class.java)!!)");
        DbDataSource wr = dbDataSource;
        DataSourceManagerDialog.showDialog(facade, CollectionsKt.listOf((Object)wr), null, (Consumer<? super DatabaseConfigEditor>)new Consumer(wr, ds){
            final /* synthetic */ DbDataSource $wr;
            final /* synthetic */ LocalDataSource $ds;

            public final void consume(DatabaseConfigEditor editor) {
                block0: {
                    AbstractDatabaseConfigurable configurable;
                    AbstractDatabaseConfigurable abstractDatabaseConfigurable = configurable = editor.getConfigurable(this.$wr, true, AbstractDatabaseConfigurable.class);
                    if (abstractDatabaseConfigurable == null) break block0;
                    abstractDatabaseConfigurable.setValue(ILazyParseableElementType.LANGUAGE_KEY, DbSqlUtilCore.getSqlDialect(this.$ds));
                }
            }
            {
                this.$wr = dbDataSource;
                this.$ds = localDataSource;
            }
        });
        this.dump(project, ds, elements, sqlDs2);
    }

    /*
     * WARNING - void declaration
     */
    private final SqlDataSource instantiateSqlDataSource(Project project) {
        void sqlDs2;
        block1: {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            DataSourceManager<SqlDataSource> dataSourceManager = DataSourceManager.byDataSource(project, SqlDataSource.class);
            if (dataSourceManager == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue(dataSourceManager, (String)"DataSourceManager.byData\u2026lass.java) ?: return null");
            DataSourceManager<SqlDataSource> manager = dataSourceManager;
            AnAction createAction2 = manager.getCreateDataSourceAction((Consumer<SqlDataSource>)new Consumer((Ref.ObjectRef)sqlDs2){
                final /* synthetic */ Ref.ObjectRef $sqlDs;

                public final void consume(SqlDataSource it2) {
                    this.$sqlDs.element = it2;
                }
                {
                    this.$sqlDs = objectRef;
                }
            });
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)SimpleDataContext.getProjectContext((Project)project));
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026tProjectContext(project))");
            AnActionEvent fakeEvent = anActionEvent;
            AnAction anAction = createAction2;
            if (anAction == null) break block1;
            anAction.actionPerformed(fakeEvent);
        }
        return (SqlDataSource)sqlDs2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final List<SqlDataSource> compatibleSqlDataSources(Project project, LocalDataSource ds) {
        void $this$mapNotNullTo$iv$iv;
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dbPsiFacade), (String)"DbPsiFacade.getInstance(project)");
        List<DbDataSource> list = dbPsiFacade.getDataSources();
        Intrinsics.checkNotNullExpressionValue(list, (String)"DbPsiFacade.getInstance(project).dataSources");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDataSource it2 = (DbDataSource)element$iv$iv;
            boolean bl2 = false;
            DbDataSource dbDataSource = it2;
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"it");
            DatabaseSystem $this$castSafelyTo$iv = dbDataSource.getDelegate();
            boolean $i$f$castSafelyTo = false;
            DatabaseSystem databaseSystem = $this$castSafelyTo$iv;
            if (!(databaseSystem instanceof SqlDataSource)) {
                databaseSystem = null;
            }
            if ((SqlDataSource)databaseSystem != null) {
                SqlDataSource sqlDataSource;
                boolean bl3 = false;
                boolean bl4 = false;
                SqlDataSource sds = sqlDataSource;
                boolean bl5 = false;
                object = this.isCompatible(sds, ds) ? sqlDataSource : null;
            } else {
                object = null;
            }
            if (object == null) continue;
            SqlDataSource sqlDataSource = object;
            boolean bl6 = false;
            boolean bl7 = false;
            SqlDataSource it$iv$iv = sqlDataSource;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isCompatible(SqlDataSource sqlDs2, LocalDataSource ds) {
        DasModel dasModel = sqlDs2.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"sqlDs.model");
        MetaModel metaModel = dasModel.getMetaModel();
        DasModel dasModel2 = ds.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel2, (String)"ds.model");
        return Intrinsics.areEqual((Object)metaModel, (Object)dasModel2.getMetaModel());
    }

    public static final /* synthetic */ boolean access$isCompatible(DumpToDdlDataSourceAction $this, SqlDataSource sqlDs2, LocalDataSource ds) {
        return $this.isCompatible(sqlDs2, ds);
    }

    public static final /* synthetic */ void access$createSqlDataSourceAndDump(DumpToDdlDataSourceAction $this, Project project, LocalDataSource ds, List elements, SqlDataSource sqlDs2) {
        $this.createSqlDataSourceAndDump(project, ds, elements, sqlDs2);
    }

    public static final /* synthetic */ void access$dump(DumpToDdlDataSourceAction $this, Project project, LocalDataSource ds, List elements, SqlDataSource sqlDs2) {
        $this.dump(project, ds, elements, sqlDs2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/actions/DumpToDdlDataSourceAction$LayoutAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.database.impl"})
    public static final class LayoutAction
    extends AnAction {
        /*
         * WARNING - void declaration
         */
        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Presentation presentation;
            block3: {
                void $this$any$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                Iterable iterable = DumpToDdlDataSourceActionKt.access$getElementsByDs(e).keySet();
                presentation = presentation2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DasDataSource it2 = (DasDataSource)element$iv;
                        boolean bl2 = false;
                        if (!(it2 instanceof SqlDataSource)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            presentation.setEnabledAndVisible(bl3);
        }

        /*
         * WARNING - void declaration
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Map items2 = DumpToDdlDataSourceActionKt.access$getElementsByDs(e);
            for (Map.Entry entry : items2.entrySet()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Project project;
                void ds;
                Object object = entry;
                boolean bl = false;
                DasDataSource dasDataSource = (DasDataSource)object.getKey();
                object = entry;
                bl = false;
                List elements = (List)object.getValue();
                if (!(ds instanceof SqlDataSource)) continue;
                Intrinsics.checkNotNull((Object)e.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
                DasModel dasModel = ((SqlDataSource)ds).getModel();
                if (dasModel == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicModel");
                }
                object = elements;
                TreePattern treePattern = null;
                BasicModel basicModel = (BasicModel)dasModel;
                SqlDataSource sqlDataSource = (SqlDataSource)ds;
                boolean $i$f$mapNotNull = false;
                void var9_9 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    BasicElement basicElement;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    DbElement it2 = (DbElement)element$iv$iv;
                    boolean bl3 = false;
                    if (DbImplUtil.getMaybeBasicElement(it2) == null) continue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    BasicElement it$iv$iv = basicElement;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                DumpToDdlDataSourceActionKt.dump(project, sqlDataSource, basicModel, treePattern, list, true);
            }
        }
    }
}

