/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.vfs.DbConsoleRootTypeCore;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import icons.DatabaseIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbConsoleRootType
extends ConsoleRootType
implements DbConsoleRootTypeCore {
    private static final String FILE_PREFIX = "console";

    DbConsoleRootType() {
        super("db", DatabaseBundle.message("DbConsoleRootType.database.consoles", new Object[0]));
    }

    @NotNull
    public static DbConsoleRootType getInstance() {
        DbConsoleRootType dbConsoleRootType = (DbConsoleRootType)DbConsoleRootType.findByClass(DbConsoleRootType.class);
        if (dbConsoleRootType == null) {
            DbConsoleRootType.$$$reportNull$$$0(0);
        }
        return dbConsoleRootType;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource2;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(2);
        }
        return (dataSource2 = DbVFSUtils.getDataSource(project, file)) != null ? (DbVFSUtils.isMongo(project, file) ? (Language)ObjectUtils.notNull((Object)ScriptModelUtilCore.getJSLanguage(), (Object)PlainTextLanguage.INSTANCE) : DbSqlUtilCore.getSqlDialect(dataSource2)) : null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(4);
        }
        DbDataSource dataSource2 = DbVFSUtils.getDataSource(project, file);
        if (file.isDirectory() && !Comparing.equal((Object)file, (Object)DbVFSUtils.getDataSourceRoot(file))) {
            return null;
        }
        return dataSource2 != null ? dataSource2.getIcon() : DatabaseIcons.Sql;
    }

    @NlsSafe
    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(6);
        }
        return this.substituteName(project, file, true);
    }

    @NlsSafe
    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file, boolean appendDataSourceName) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(8);
        }
        String name = file.isDirectory() ? file.getName() : file.getNameWithoutExtension();
        DbDataSource dataSource2 = DbVFSUtils.getDataSource(project, file);
        if (dataSource2 == null) {
            return null;
        }
        String uniqueId = Objects.requireNonNull(dataSource2.getUniqueId());
        if (file.isDirectory()) {
            return name.equals(uniqueId) ? dataSource2.getName() : name;
        }
        String rootPath = this.getContentRootPath(uniqueId);
        String fileParentPath = PathUtil.getParentPath((String)file.getPath());
        String relativeDir = StringUtil.startsWithIgnoreCase((String)fileParentPath, (String)rootPath) ? fileParentPath.substring(rootPath.length()) : "";
        String dataSourceName = DatabaseSettings.getSettings().shortenTabNames ? StringUtil.trimMiddle((String)dataSource2.getName(), (int)36) : dataSource2.getName();
        String s1 = FileUtilRt.toSystemDependentName((String)StringUtil.trimStart((String)StringUtil.trimEnd((String)(relativeDir + "/" + FileUtilRt.getNameWithoutExtension((String)file.getName()).replace(uniqueId, dataSourceName).replace("/console_", "/").replace("/console", "/")), (String)"/"), (String)"/"));
        boolean oneDatasource = DataSourceStorage.getProjectStorage(project).getDataSourcesImpl().skip(1).isEmpty();
        return s1.isEmpty() ? dataSourceName : (oneDatasource || !appendDataSourceName ? s1 : s1 + " [" + dataSourceName + "]");
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element2) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            DbConsoleRootType.$$$reportNull$$$0(10);
        }
        return DbVFSUtils.getDataSource(project, element2) == null;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull Disposable disposable2, @NotNull Runnable onUpdate) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(11);
        }
        if (disposable2 == null) {
            DbConsoleRootType.$$$reportNull$$$0(12);
        }
        if (onUpdate == null) {
            DbConsoleRootType.$$$reportNull$$$0(13);
        }
        project.getMessageBus().connect(disposable2).subscribe(DbPsiFacade.TOPIC, o -> onUpdate.run());
    }

    @NotNull
    public String getEntrySeparator() {
        return "\n;-- -. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(14);
        }
        String string = id + "/console";
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getContentRootPath(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(16);
        }
        String string = ScratchFileService.getInstance().getRootPath((RootType)this) + "/" + id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(18);
        }
        String string = id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getDefaultFileExtension() {
        return "sql";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPathName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryPathName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerTreeUpdater";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContentPathName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryPathName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

