/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DatabaseServiceViewContributor;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseClientLogView;
import com.intellij.database.console.session.DatabaseClientLogViewBase;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.console.session.DatabaseSessionViewServiceImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.Session;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0018\u0012\u0004\u0012\u00020\r0\u0017H\u0016J\u0018\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u001a\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\nH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R&\u0010\u0003\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl;", "Lcom/intellij/database/console/session/DatabaseSessionViewService;", "()V", "clientViews", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/database/console/session/DatabaseClientLogView;", "sessionViews", "Lcom/intellij/database/run/session/VisibleSession;", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "databaseSessionContributorListenSessions", "", "destroyView", "client", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "findDatabaseSession", "Lcom/intellij/database/console/session/DatabaseSession;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getClientView", "configurator", "Lkotlin/Function1;", "Lcom/intellij/database/console/session/DatabaseClientLogViewBase;", "getClientViewIfAny", "Lcom/intellij/database/run/session/LogView;", "getView", "session", "getViewIfAny", "initView", "key", "MyLanguageConsoleImpl", "intellij.database.impl"})
public final class DatabaseSessionViewServiceImpl
extends DatabaseSessionViewService {
    private final Map<VisibleSession<?>, DatabaseSessionLogView> sessionViews = new HashMap();
    private final Map<Pair<Project, VirtualFile>, DatabaseClientLogView> clientViews = new HashMap();

    @NotNull
    public DatabaseSessionLogView getView(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        DatabaseSessionLogView databaseSessionLogView = this.sessionViews.computeIfAbsent(session2, new Function(this, session2){
            final /* synthetic */ DatabaseSessionViewServiceImpl this$0;
            final /* synthetic */ DatabaseSession $session;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DatabaseSessionLogView apply(@NotNull VisibleSession<?> it2) {
                void var3_3;
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                ApplicationManager.getApplication().assertIsDispatchThread();
                LanguageConsoleImpl console = new LanguageConsoleImpl(this.$session.getProject(), this.$session.getTitle(), (Language)DbSqlUtil.getSqlDialect((LocalDataSource)this.$session.getTarget()));
                DatabaseSessionLogView view2 = new DatabaseSessionLogView((LanguageConsoleView)console, this.$session);
                Disposer.register((Disposable)this.$session, (Disposable)new Disposable(this){
                    final /* synthetic */ getView.1 this$0;

                    public final void dispose() {
                        DatabaseSessionViewServiceImpl.access$getSessionViews$p(this.this$0.this$0).remove(this.this$0.$session);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return var3_3;
            }
            {
                this.this$0 = databaseSessionViewServiceImpl;
                this.$session = databaseSession;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)databaseSessionLogView, (String)"sessionViews.computeIfAb\u2026sion) })\n      view\n    }");
        return databaseSessionLogView;
    }

    @Override
    public void initView(@NotNull DatabaseSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.getView(session2);
    }

    @Override
    @Nullable
    public LogView<?> getViewIfAny(@NotNull VisibleSession<?> session2) {
        Intrinsics.checkNotNullParameter(session2, (String)"session");
        return this.sessionViews.get(session2);
    }

    @NotNull
    public DatabaseClientLogView getClientView(@NotNull DatabaseSessionClientWithFile client, @NotNull Function1<? super DatabaseClientLogViewBase<DatabaseSessionClientWithFile>, Unit> configurator) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(configurator, (String)"configurator");
        Project project = ((DatabaseSession)client.getSession()).getProject();
        Pair<Project, VirtualFile> key = this.key(client);
        DatabaseClientLogView databaseClientLogView = this.clientViews.computeIfAbsent(key, new Function(this, project, client, configurator, key){
            final /* synthetic */ DatabaseSessionViewServiceImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ DatabaseSessionClientWithFile $client;
            final /* synthetic */ Function1 $configurator;
            final /* synthetic */ Pair $key;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DatabaseClientLogView apply(@NotNull Pair<? extends Project, ? extends VirtualFile> it2) {
                void var3_3;
                Intrinsics.checkNotNullParameter(it2, (String)"it");
                ApplicationManager.getApplication().assertIsDispatchThread();
                MyLanguageConsoleImpl console = new MyLanguageConsoleImpl(this.$project, this.$client.getTitle(), this.$client.getVirtualFile(), this.$client.getAutoClose());
                DatabaseClientLogView result2 = new DatabaseClientLogView((LanguageConsoleView)console, this.$client);
                this.$configurator.invoke((Object)result2);
                Disposer.register((Disposable)((Disposable)this.$project), (Disposable)result2);
                Disposer.register((Disposable)result2, (Disposable)new Disposable(this){
                    final /* synthetic */ getClientView.view.1 this$0;

                    public final void dispose() {
                        DatabaseSessionViewServiceImpl.access$getClientViews$p(this.this$0.this$0).remove(this.this$0.$key);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return var3_3;
            }
            {
                this.this$0 = databaseSessionViewServiceImpl;
                this.$project = project;
                this.$client = databaseSessionClientWithFile;
                this.$configurator = function1;
                this.$key = pair;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)databaseClientLogView, (String)"clientViews.computeIfAbs\u2026ey) })\n      result\n    }");
        DatabaseClientLogView view2 = databaseClientLogView;
        if (Intrinsics.areEqual(view2.getTarget(), (Object)client) ^ true) {
            view2.setTarget(client, client.getMessageBus());
            configurator.invoke((Object)view2);
        }
        return view2;
    }

    private final Pair<Project, VirtualFile> key(DatabaseSessionClientWithFile client) {
        return new Pair((Object)((DatabaseSession)client.getSession()).getProject(), (Object)client.getVirtualFile());
    }

    @Override
    @Nullable
    public LogView<DatabaseSessionClientWithFile> getClientViewIfAny(@NotNull DatabaseSessionClientWithFile client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        return client instanceof DataGridSessionClient ? ((DataGridSessionClient)client).getView() : (LogView)this.clientViews.get(this.key(client));
    }

    @Override
    public void destroyView(@NotNull DatabaseSessionClientWithFile client) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            LogView<DatabaseSessionClientWithFile> logView = this.getClientViewIfAny(client);
            if (logView == null) break block0;
            LogView<DatabaseSessionClientWithFile> logView2 = logView;
            boolean bl = false;
            boolean bl2 = false;
            LogView<DatabaseSessionClientWithFile> it2 = logView2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it2);
        }
    }

    @Override
    public void databaseSessionContributorListenSessions() {
        DatabaseServiceViewContributor.listenSessions();
    }

    @Override
    @Nullable
    public DatabaseSession findDatabaseSession(@NotNull AnActionEvent e) {
        DataGridSessionClient hookUp;
        DatabaseSession session2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return null");
        Project project2 = project;
        Object object = e.getData(Session.SESSION_KEY);
        if (!(object instanceof DatabaseSession)) {
            object = null;
        }
        if ((session2 = (DatabaseSession)object) != null) {
            return session2;
        }
        JdbcConsoleBase console = JdbcConsole.findConsole(e);
        if (console != null) {
            return (DatabaseSession)console.getSession();
        }
        DataGridSessionClient dataGridSessionClient = hookUp = (DataGridSessionClient)GridDataHookUpManager.getInstance(project2).getClient(e);
        return dataGridSessionClient != null ? dataGridSessionClient.getSession() : null;
    }

    public static final /* synthetic */ Map access$getSessionViews$p(DatabaseSessionViewServiceImpl $this) {
        return $this.sessionViews;
    }

    public static final /* synthetic */ Map access$getClientViews$p(DatabaseSessionViewServiceImpl $this) {
        return $this.clientViews;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/console/session/DatabaseSessionViewServiceImpl$MyLanguageConsoleImpl;", "Lcom/intellij/execution/console/LanguageConsoleImpl;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "autoClose", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "closeFile", "", "intellij.database.impl"})
    private static final class MyLanguageConsoleImpl
    extends LanguageConsoleImpl {
        private final boolean autoClose;

        protected void closeFile() {
            if (this.autoClose) {
                super.closeFile();
            }
        }

        public MyLanguageConsoleImpl(@NotNull Project project, @NotNull String title, @NotNull VirtualFile file, boolean autoClose) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            super(project, title, file);
            this.autoClose = autoClose;
        }
    }
}

