/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.TextDomain;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDomain
extends Domain {
    private final Cardinality.ElementsCardinality myCardinality;
    private final long myUpperBound;
    private final TextDomain.Length myLengthCaps;

    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long upperBound) {
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(0);
        }
        if (descriptor2 == null) {
            BinaryDomain.$$$reportNull$$$0(1);
        }
        this(name, descriptor2, PhysicalDomainType.BINARY, upperBound, TextDomain.Length.NONE);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long upperBound, long defaultValue, boolean bl, boolean bl2) {
        void variable;
        void narrowable;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            BinaryDomain.$$$reportNull$$$0(3);
        }
        this(name, descriptor2, PhysicalDomainType.BINARY, upperBound, narrowable != false ? TextDomain.Length.optional(defaultValue == -1L ? upperBound : defaultValue, (boolean)variable) : TextDomain.Length.fixed(defaultValue));
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, @NotNull PhysicalDomainType type, long upperBound, long defaultValue, boolean bl, boolean bl2) {
        void variable;
        void narrowable;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            BinaryDomain.$$$reportNull$$$0(5);
        }
        if (type == null) {
            BinaryDomain.$$$reportNull$$$0(6);
        }
        this(name, descriptor2, type, upperBound, narrowable != false ? TextDomain.Length.optional(defaultValue == -1L ? upperBound : defaultValue, (boolean)variable) : TextDomain.Length.fixed(defaultValue));
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, long upperBound, TextDomain.Length length) {
        void lengthCaps;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            BinaryDomain.$$$reportNull$$$0(8);
        }
        this(name, descriptor2, PhysicalDomainType.BINARY, upperBound, (TextDomain.Length)lengthCaps);
    }

    /*
     * WARNING - void declaration
     */
    public BinaryDomain(@NotNull String name, @NotNull ConversionPoint descriptor2, @NotNull PhysicalDomainType type, long upperBound, TextDomain.Length length) {
        void lengthCaps;
        if (name == null) {
            BinaryDomain.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            BinaryDomain.$$$reportNull$$$0(10);
        }
        if (type == null) {
            BinaryDomain.$$$reportNull$$$0(11);
        }
        super(descriptor2, type, name);
        this.myUpperBound = upperBound;
        this.myLengthCaps = lengthCaps;
        this.myCardinality = new Cardinality.ElementsCardinality(this.myUpperBound);
    }

    public long getUpperBound() {
        return this.myUpperBound;
    }

    public long getEffectiveUpperBound() {
        return this.myLengthCaps.getEffectiveLength(this.myUpperBound);
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.ElementsCardinality elementsCardinality = this.myCardinality;
        if (elementsCardinality == null) {
            BinaryDomain.$$$reportNull$$$0(12);
        }
        return elementsCardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(13);
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? (((BinaryDomain)domain).getEffectiveUpperBound() <= this.getEffectiveUpperBound() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.incompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            BinaryDomain.$$$reportNull$$$0(14);
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            BinaryDomain.$$$reportNull$$$0(15);
        }
        return o instanceof byte[] && this.getEffectiveUpperBound() > 0L ? (Object)Arrays.copyOf((byte[])o, (int)Math.min(this.getEffectiveUpperBound(), (long)((byte[])o).length)) : o;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            BinaryDomain.$$$reportNull$$$0(16);
        }
        BinaryDomain binaryDomain = this.myLengthCaps.isNarrowable() && domain instanceof BinaryDomain ? new BinaryDomain(this.simpleName(), this.getPoint(), this.getDomainType(), Math.min(((BinaryDomain)domain).getEffectiveUpperBound(), this.getEffectiveUpperBound()), this.myLengthCaps) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(17);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            BinaryDomain.$$$reportNull$$$0(18);
        }
        BinaryDomain binaryDomain = this.myLengthCaps.isNarrowable() ? new BinaryDomain(this.simpleName(), this.getPoint(), this.getDomainType(), Math.min((long)provider.getSize(), this.getEffectiveUpperBound()), this.myLengthCaps) : this;
        if (binaryDomain == null) {
            BinaryDomain.$$$reportNull$$$0(19);
        }
        return binaryDomain;
    }

    @Override
    @NotNull
    public String name() {
        Object object = this.myLengthCaps.shouldAddLength(this.getUpperBound()) ? this.simpleName() + "(" + this.getEffectiveUpperBound() + ")" : super.name();
        if (object == null) {
            BinaryDomain.$$$reportNull$$$0(20);
        }
        return object;
    }

    protected long getDefaultValue() {
        return this.myLengthCaps.defaultLength;
    }

    protected boolean isNarrowable() {
        return this.myLengthCaps.isNarrowable();
    }

    public boolean isVariable() {
        return this.myLengthCaps.isVariable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/BinaryDomain";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

