/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Operation;
import com.intellij.database.data.types.domain.OperationKt;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public interface OperationSupport {
    public static final OperationSupport DEFAULT_OPERATION_SUPPORT = new OperationSupport(){

        @Override
        public boolean supportsOperation(@NotNull Domain domain, @NotNull Operation operation) {
            if (domain == null) {
                1.$$$reportNull$$$0(0);
            }
            if (operation == null) {
                1.$$$reportNull$$$0(1);
            }
            return operation == OperationKt.EQUALS_TO_NULL_OPERATION || operation == OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION || (operation == OperationKt.LIKE_OPERATION ? LogicalType.isText(domain.getLogicType()) : (LogicalType.isNumeric(domain.getLogicType()) ? operation == OperationKt.EQUALS_TO_NUMBER_OPERATION : operation == OperationKt.EQUALS_TO_STRING_OPERATION));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/data/types/domain/OperationSupport$1";
            objectArray[2] = "supportsOperation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final OperationSupport SUPPORTS_NOTHING = OperationSupport.supports(OperationKt.EQUALS_TO_NULL_OPERATION, OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
    public static final OperationSupport SUPPORTS_LIKE = OperationSupport.supports(OperationKt.EQUALS_TO_STRING_OPERATION, OperationKt.LIKE_OPERATION, OperationKt.EQUALS_TO_NULL_OPERATION, OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
    public static final OperationSupport SUPPORTS_EQUALS = OperationSupport.supports(OperationKt.EQUALS_TO_STRING_OPERATION, OperationKt.EQUALS_TO_NULL_OPERATION, OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
    public static final OperationSupport SUPPORTS_NUMERIC_EQUALS = OperationSupport.supports(OperationKt.EQUALS_TO_NUMBER_OPERATION, OperationKt.EQUALS_TO_NULL_OPERATION, OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
    public static final OperationSupport SUPPORTS_NUMERIC_EQUALS_AND_LIKE_ONLY = OperationSupport.supports(OperationKt.LIKE_OPERATION, OperationKt.EQUALS_TO_NUMBER_OPERATION, OperationKt.EQUALS_TO_NULL_OPERATION, OperationKt.EQUALS_TO_PLACEHOLDER_OPERATION);
    public static final OperationSupport SUPPORTS_LIKE_ONLY = OperationSupport.supports(OperationKt.LIKE_OPERATION, OperationKt.EQUALS_TO_NULL_OPERATION);
    public static final OperationSupport SUPPORTS_FTS = new OperationSupport(){

        @Override
        public boolean supportsOperation(@NotNull Domain domain, @NotNull Operation operation) {
            if (domain == null) {
                2.$$$reportNull$$$0(0);
            }
            if (operation == null) {
                2.$$$reportNull$$$0(1);
            }
            return operation == OperationKt.FULL_TEXT_SEARCH_OPERATION || DEFAULT_OPERATION_SUPPORT.supportsOperation(domain, operation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/data/types/domain/OperationSupport$2";
            objectArray[2] = "supportsOperation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static OperationSupport supports(final Operation ... operations) {
        return new OperationSupport(){

            @Override
            public boolean supportsOperation(@NotNull Domain domain, @NotNull Operation operation) {
                if (domain == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (operation == null) {
                    3.$$$reportNull$$$0(1);
                }
                return ArrayUtil.contains((Object)operation, (Object[])operations);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "domain";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "operation";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/data/types/domain/OperationSupport$3";
                objectArray[2] = "supportsOperation";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean supportsOperation(@NotNull Domain var1, @NotNull Operation var2);
}

